/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportAction
extends ES6ImportAction {
    public TypeScriptImportAction(@Nullable Editor editor, @Nullable PsiElement context, @Nullable String name, @NotNull ES6ImportAction.ImportElementFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/lang/typescript/intentions/TypeScriptImportAction", "<init>"));
        }
        super(editor, context, name, filter);
    }

    @Override
    @NotNull
    protected List<JSElement> additionalProcessCandidates(@NotNull JSImportPlaceInfo info, @NotNull List<JSElement> candidates) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/intentions/TypeScriptImportAction", "additionalProcessCandidates"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/typescript/intentions/TypeScriptImportAction", "additionalProcessCandidates"));
        }
        assert (this.myContext != null);
        for (TypeScriptModule module : TypeScriptUtil.getAllRegularExternalModules(this.myContext.getProject(), this.myContext)) {
            String moduleName = module.getName();
            if (moduleName == null || !StringUtil.unquoteString((String)moduleName).equalsIgnoreCase(this.myName)) continue;
            candidates.add((JSElement)module);
            break;
        }
        List<JSElement> list = candidates.stream().filter(el -> {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/intentions/TypeScriptImportAction", "lambda$additionalProcessCandidates$0"));
            }
            PsiFile file = el.getContainingFile();
            if (!(file instanceof JSFile)) {
                return false;
            }
            return ((JSFile)file).isCommonJSModule() || TypeScriptConfigService.Provider.isAccessible(this.myContext.getProject(), info.getFile(), file.getVirtualFile());
        }).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptImportAction", "additionalProcessCandidates"));
        }
        return list;
    }

    @Override
    protected void runAction(@Nullable Editor editor, @NotNull String name, @NotNull JSElement elementToImport, @NotNull PsiElement place) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/intentions/TypeScriptImportAction", "runAction"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/intentions/TypeScriptImportAction", "runAction"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/intentions/TypeScriptImportAction", "runAction"));
        }
        TypeScriptAutoImportUtil.addImportStatement(editor, name, elementToImport, place);
    }
}

