/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLibraryProvider {
    public static final Logger LOG = Logger.getInstance(TypeScriptLibraryProvider.class);
    public static final String LIB_PREFIX = "lib";
    private static boolean SKIP_DEFAULT_LIBRARY = false;
    public static final Collection<String> FILES_FROM_TYPESCRIPT = ContainerUtil.immutableSet((Object[])new String[]{"lib.core.d.ts", "lib.core.es6.d.ts", "lib.core.es7.d.ts", "lib.webworker.d.ts", "lib.es5.d.ts", "lib.es7.d.ts", "lib.es2015.d.ts ", "lib.es2016.d.ts ", "lib.dom.iterable.d.ts", "lib.es2017.d.ts ", "lib.es2015.core.d.ts", "lib.es2016.core.d.ts", "lib.es2017.core.d.ts", "typescriptServices.d.ts", "lib.scriptHost.d.ts"});
    public static final String LIB_D_TS = "lib.d.ts";
    public static final String LIB_ES6_D_TS = "lib.es6.d.ts";
    public static final Collection<String> LIBS_D_TS = ContainerUtil.immutableSet((Object[])new String[]{"lib.d.ts", "lib.es6.d.ts"});
    public static final Collection<String> LIBS_EXTENDED = ContainerUtil.immutableSet((Object[])new String[]{"lib.es2016.array.include.d.ts", "lib.es2016.d.ts", "lib.es2017.d.ts", "lib.dom.iterable.d.ts", "lib.es2017.object.d.ts", "lib.es2017.sharedmemory.d.ts"});
    public static final String REACT_D_TS = "react.d.ts";
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> PREDEFINED_FILES = AtomicNotNullLazyValue.createValue(TypeScriptLibraryProvider::createPredefinedFiles);
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> LIB_D_TS_SET = AtomicNotNullLazyValue.createValue(() -> TypeScriptLibraryProvider.createLibSet(LIB_D_TS));
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> LIB_ES6_D_TS_SET = AtomicNotNullLazyValue.createValue(() -> TypeScriptLibraryProvider.createLibSet(LIB_ES6_D_TS));

    public static void setSkipDefaultLibrary(boolean noLib) {
        SKIP_DEFAULT_LIBRARY = noLib;
    }

    public static Set<VirtualFile> getAllPredefinedLibraryFiles() {
        return (Set)PREDEFINED_FILES.getValue();
    }

    @NotNull
    private static Set<VirtualFile> createLibSet(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "createLibSet"));
        }
        for (VirtualFile file : (Set)PREDEFINED_FILES.getValue()) {
            if (!name.equals(file.getName())) continue;
            Set set = ContainerUtil.immutableSet((Object[])new VirtualFile[]{file});
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "createLibSet"));
            }
            return set;
        }
        Set set = ContainerUtil.immutableSet((Object[])new VirtualFile[0]);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "createLibSet"));
        }
        return set;
    }

    @NotNull
    private static Set<VirtualFile> createPredefinedFiles() {
        ArrayList toProcess = ContainerUtil.newArrayList();
        toProcess.addAll(LIBS_D_TS);
        toProcess.addAll(LIBS_EXTENDED);
        Set<VirtualFile> set = toProcess.stream().map(name -> TypeScriptLibraryProvider.getTypeScriptPredefinedLibFile(name)).filter(el -> el != null).collect(Collectors.toSet());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "createPredefinedFiles"));
        }
        return set;
    }

    @Nullable
    private static VirtualFile getTypeScriptPredefinedLibFile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getTypeScriptPredefinedLibFile"));
        }
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        if (!(fileSystem instanceof LocalFileSystem)) {
            return null;
        }
        LocalFileSystem localFileSystem = (LocalFileSystem)fileSystem;
        File ioFile = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "external" + File.separator + name);
        VirtualFile file = JSLibraryUtil.findFileByIoFile(localFileSystem, ioFile);
        return JSLibraryUtil.convertFile(file);
    }

    @NotNull
    public static Set<VirtualFile> getPredefineLibraries(@NotNull Project project, @NotNull VirtualFile file) {
        Collection<TypeScriptConfig> includes;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getPredefineLibraries"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getPredefineLibraries"));
        }
        if (SKIP_DEFAULT_LIBRARY) {
            Set set = ContainerUtil.immutableSet((Object[])new VirtualFile[0]);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getPredefineLibraries"));
            }
            return set;
        }
        Collection<TypeScriptConfig> configs = TypeScriptConfigService.Provider.getConfigFiles(project);
        Collection<TypeScriptConfig> collection = includes = configs.size() <= 1 || TypeScriptUtil.isUnderNodeModules(file, project) ? configs : TypeScriptConfigService.Provider.getConfigInclude(project, file);
        if (includes.isEmpty()) {
            Set<VirtualFile> set = TypeScriptLibraryProvider.getLibraries(JSRootConfiguration.getInstance(project).getLanguageLevel().isES6Compatible(), null);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getPredefineLibraries"));
            }
            return set;
        }
        List additionalLibs = null;
        boolean targetES6 = false;
        for (TypeScriptConfig config : includes) {
            targetES6 |= config.getLanguageTarget() == TypeScriptConfig.LanguageTarget.ES6 || config.hasES6Lib();
            Collection<String> names = config.getLibNames();
            if (names.isEmpty()) continue;
            if (additionalLibs == null) {
                additionalLibs = ContainerUtil.newSmartList();
            }
            additionalLibs.addAll(names);
        }
        Set<VirtualFile> set = TypeScriptLibraryProvider.getLibraries(targetES6, additionalLibs);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getPredefineLibraries"));
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getLibraries(boolean isES6, @Nullable List<String> additionalLibs) {
        Set defaultLibrary;
        Set set = defaultLibrary = isES6 ? (Set)LIB_ES6_D_TS_SET.getValue() : (Set)LIB_D_TS_SET.getValue();
        if (additionalLibs == null || additionalLibs.isEmpty()) {
            Set set2 = defaultLibrary;
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getLibraries"));
            }
            return set2;
        }
        HashSet result = ContainerUtil.newHashSet((Iterable)defaultLibrary);
        for (VirtualFile file : TypeScriptLibraryProvider.getAllPredefinedLibraryFiles()) {
            int endIndex;
            String rawName = file.getName();
            if (LIBS_D_TS.contains(rawName)) continue;
            int startIndex = LIB_PREFIX.length() + 1;
            if (startIndex > (endIndex = rawName.length() - ".d.ts".length()) || endIndex > rawName.length()) {
                LOG.error("Name rage error start:" + startIndex + " end: " + endIndex + " name " + rawName);
                continue;
            }
            String name = rawName.substring(startIndex, endIndex);
            if (!additionalLibs.contains(name)) continue;
            result.add(file);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProvider", "getLibraries"));
        }
        return hashSet;
    }
}

