/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.psi.impl.TypeScriptModuleTextReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptExternalModuleReferenceContributor
implements JSModuleReferenceContributor {
    @Override
    @NotNull
    public PsiReference[] getCommonJSModuleReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/typescript/modules/TypeScriptExternalModuleReferenceContributor", "getCommonJSModuleReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/typescript/modules/TypeScriptExternalModuleReferenceContributor", "getCommonJSModuleReferences"));
        }
        PsiReference[] psiReferenceArray = TypeScriptExternalModuleReferenceContributor.getReferences(unquotedRefText, host, offset, provider, true);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/modules/TypeScriptExternalModuleReferenceContributor", "getCommonJSModuleReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/typescript/modules/TypeScriptExternalModuleReferenceContributor", "getAllReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/typescript/modules/TypeScriptExternalModuleReferenceContributor", "getAllReferences"));
        }
        PsiReference[] psiReferenceArray = TypeScriptExternalModuleReferenceContributor.getReferences(unquotedRefText, host, offset, provider, false);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/modules/TypeScriptExternalModuleReferenceContributor", "getAllReferences"));
        }
        return psiReferenceArray;
    }

    private static PsiReference[] getReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider, boolean isCommonJS) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/typescript/modules/TypeScriptExternalModuleReferenceContributor", "getReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/typescript/modules/TypeScriptExternalModuleReferenceContributor", "getReferences"));
        }
        String requiredModuleName = FileUtilRt.toSystemIndependentName((String)unquotedRefText);
        final Project project = host.getProject();
        if (!StringUtil.startsWith((CharSequence)requiredModuleName, (CharSequence)"./") && !StringUtil.startsWith((CharSequence)requiredModuleName, (CharSequence)"../")) {
            final boolean isSoft = isCommonJS || !DialectDetector.isTypeScript(host);
            return new PsiReference[]{new TypeScriptModuleTextReference(host, requiredModuleName, offset){

                @Override
                public boolean isSoft() {
                    return isSoft;
                }

                @Override
                @NotNull
                public Object[] getVariants() {
                    Collection<TypeScriptModule> modules = TypeScriptUtil.getAllRegularExternalModules(project, this.myElement);
                    HashSet moduleNames = ContainerUtil.newHashSet();
                    HashSet result = ContainerUtil.newHashSet();
                    for (JSElement jSElement : modules) {
                        LookupItem<Object> item;
                        String unquoteString;
                        String name = jSElement.getName();
                        if (StringUtil.isEmpty((String)name) || !moduleNames.add(unquoteString = StringUtil.unquoteString((String)name)) || (item = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)jSElement, unquoteString, JSLookupPriority.MAX_PRIORITY, false, false)) == null) continue;
                        result.add(item);
                    }
                    Object[] objectArray = result.toArray();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/modules/TypeScriptExternalModuleReferenceContributor$1", "getVariants"));
                    }
                    return objectArray;
                }
            }};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/typescript/modules/TypeScriptExternalModuleReferenceContributor", "isApplicable"));
        }
        return true;
    }
}

