/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptAddImportExecutor {
    @NotNull
    private final String myImportedName;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final PsiElement myPlace;
    @NotNull
    private final Project myProject;

    public TypeScriptAddImportExecutor(@NotNull String name, @Nullable Editor editor, @NotNull PsiElement place) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "<init>"));
        }
        this.myImportedName = name;
        this.myEditor = editor;
        this.myPlace = place;
        this.myProject = place.getProject();
    }

    public final void execute(@NotNull JSElement elementToImport) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "execute"));
        }
        PsiFile file = this.myPlace.getContainingFile();
        if (!this.executeImpl(elementToImport)) {
            TypeScriptAutoImportUtil.showError(this.myProject, this.myEditor);
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(file);
    }

    private boolean executeForNamespaceAndModuleImport(@NotNull JSElement elementToImport) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "executeForNamespaceAndModuleImport"));
        }
        PsiElement current = elementToImport.getParent();
        PsiElement lastElement = null;
        while (current != null) {
            PsiElement parent = current.getParent();
            if (parent != null && ES6PsiUtil.isExternalModule(parent)) {
                lastElement = current;
                break;
            }
            current = parent;
        }
        if (!(lastElement instanceof JSQualifiedNamedElement)) {
            return false;
        }
        JSQualifiedNamedElement element = (JSQualifiedNamedElement)lastElement;
        String moduleName = element.getName();
        if (moduleName == null) {
            return false;
        }
        if (!this.hasImportForNamespace(element, moduleName) && !new TypeScriptAddImportExecutor(moduleName, this.myEditor, this.myPlace).executeImpl((JSElement)element)) {
            return false;
        }
        return this.executeForImportType(elementToImport, ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE);
    }

    private boolean hasImportForNamespace(@NotNull JSQualifiedNamedElement element, @NotNull String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "hasImportForNamespace"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "hasImportForNamespace"));
        }
        PsiElement scope = ES6CreateImportUtil.getScopeToAdd(this.myPlace, false);
        if (scope == null) {
            return false;
        }
        JSTypeResolveResult result = TypeScriptImportHandler.getInstance().resolveName(name, this.myPlace);
        return result.getElements().contains(element);
    }

    private boolean executeImpl(@NotNull JSElement elementToImport) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "executeImpl"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        JSElement elementContainer = ES6PsiUtil.getExportScope((PsiElement)elementToImport);
        JSElement placeContainer = ES6PsiUtil.getExportScope(this.myPlace);
        if (elementContainer == null || elementContainer.isEquivalentTo((PsiElement)placeContainer)) {
            return true;
        }
        JSQualifiedName namespace = TypeScriptAddImportExecutor.getElementNamespace(elementToImport);
        ES6ImportPsiUtil.ImportExportType importType = this.getImportType(elementToImport, (PsiElement)elementContainer, namespace);
        if (importType == null) {
            return false;
        }
        return this.executeForImportType(elementToImport, importType);
    }

    @Nullable
    private static JSQualifiedName getElementNamespace(@NotNull JSElement elementToImport) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "getElementNamespace"));
        }
        return elementToImport instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)elementToImport).getNamespace() : null;
    }

    public boolean executeForImportType(@NotNull JSElement elementToImport, @NotNull ES6ImportPsiUtil.ImportExportType importType) {
        String moduleOrNamespaceName;
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "executeForImportType"));
        }
        if (importType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importType", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "executeForImportType"));
        }
        if (importType == ES6ImportPsiUtil.ImportExportType.TS_NS_AND_MODULE) {
            return this.executeForNamespaceAndModuleImport(elementToImport);
        }
        JSQualifiedName namespace = TypeScriptAddImportExecutor.getElementNamespace(elementToImport);
        JSElement elementContainer = ES6PsiUtil.getExportScope((PsiElement)elementToImport);
        if (elementContainer == null) {
            return false;
        }
        PsiElement externalModule = null;
        if (importType == ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE) {
            moduleOrNamespaceName = namespace == null ? this.myImportedName : namespace + "." + this.myImportedName;
        } else {
            String externalModuleName = null;
            PsiElement rawExternalModule = this.getRawExternalModule(elementToImport, (PsiElement)elementContainer, namespace);
            if (rawExternalModule == null) {
                return false;
            }
            if (rawExternalModule instanceof PsiFile) {
                PsiFile moduleFile = (PsiFile)rawExternalModule;
                JSModuleNameInfo moduleNameWithResolve = TypeScriptAutoImportUtil.getExternalFileModuleName(this.myProject, elementToImport, moduleFile, this.myPlace);
                if (moduleNameWithResolve != null) {
                    externalModuleName = moduleNameWithResolve.getPath();
                    VirtualFile module = moduleNameWithResolve.getModule();
                    if (module != null) {
                        externalModule = PsiManager.getInstance((Project)this.myProject).findFile(module);
                    }
                }
            } else if (rawExternalModule instanceof TypeScriptModule) {
                externalModule = rawExternalModule;
                String rawName = ((TypeScriptModule)rawExternalModule).getName();
                if (rawName == null) {
                    return false;
                }
                externalModuleName = ES6ImportPsiUtil.wrapWithQuotesFromSettings(StringUtil.unquoteString((String)rawName), (PsiElement)elementToImport);
            }
            if (externalModuleName == null) {
                return false;
            }
            moduleOrNamespaceName = externalModuleName;
        }
        return this.createImportOrUseExisting(elementToImport.getName(), externalModule, moduleOrNamespaceName, importType);
    }

    @Nullable
    public PsiElement getRawExternalModule(@NotNull JSElement elementToImport, @NotNull PsiElement elementContainer, @Nullable JSQualifiedName namespace) {
        PsiElement externalModuleForContainer;
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "getRawExternalModule"));
        }
        if (elementContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementContainer", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "getRawExternalModule"));
        }
        if (ES6PsiUtil.isExternalModule((PsiElement)elementToImport)) {
            return elementToImport;
        }
        if (elementContainer instanceof TypeScriptModule && ((TypeScriptModule)elementContainer).isAugmentation()) {
            return elementContainer.getParent();
        }
        if (namespace == null) {
            return elementContainer.getContainingFile();
        }
        PsiElement psiElement = externalModuleForContainer = ES6PsiUtil.isExternalModule(elementContainer) ? elementContainer : elementContainer.getParent();
        if (!ES6PsiUtil.isExternalModule(externalModuleForContainer)) {
            return null;
        }
        if (externalModuleForContainer instanceof TypeScriptModule) {
            String currentModuleName = ((TypeScriptModule)externalModuleForContainer).getName();
            if (currentModuleName == null) {
                return null;
            }
            return externalModuleForContainer;
        }
        return elementContainer.getContainingFile();
    }

    public boolean createImportOrUseExisting(@Nullable String exportedName, @Nullable PsiElement externalModule, @NotNull String moduleOrNamespaceName, @NotNull ES6ImportPsiUtil.ImportExportType importType) {
        if (moduleOrNamespaceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleOrNamespaceName", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "createImportOrUseExisting"));
        }
        if (importType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importType", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "createImportOrUseExisting"));
        }
        PsiElement scope = ES6CreateImportUtil.getScopeToAdd(this.myPlace, importType != ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE);
        if (scope == null) {
            return false;
        }
        if (this.tryToUseExistingImport(moduleOrNamespaceName, externalModule, importType, scope)) {
            return true;
        }
        PsiElement importPsi = this.createTypeScriptOrES6Import(exportedName, moduleOrNamespaceName, importType);
        if (importPsi == null) {
            return false;
        }
        ES6CreateImportUtil.findPlaceAndInsertImport(scope, importPsi, this.myEditor);
        return true;
    }

    @Nullable
    private PsiElement createTypeScriptOrES6Import(@Nullable String exportedName, @NotNull String externalModuleName, @NotNull ES6ImportPsiUtil.ImportExportType importType) {
        if (externalModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalModuleName", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "createTypeScriptOrES6Import"));
        }
        if (importType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importType", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "createTypeScriptOrES6Import"));
        }
        if (importType.isES6()) {
            ES6ImportPsiUtil.CreateImportExportInfo info = new ES6ImportPsiUtil.CreateImportExportInfo(exportedName, this.myImportedName, importType);
            return ES6ImportPsiUtil.createImportExport(this.myPlace, info, externalModuleName);
        }
        ES6ImportPsiUtil.CreateImportExportInfo info = new ES6ImportPsiUtil.CreateImportExportInfo(this.myImportedName, importType);
        return TypeScriptAutoImportUtil.createTypeScriptImport(this.myPlace, info, externalModuleName);
    }

    @Nullable
    public ES6ImportPsiUtil.ImportExportType getImportType(@NotNull JSElement elementToImport, @NotNull PsiElement elementContainer, @Nullable JSQualifiedName namespace) {
        TypeScriptModule container;
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "getImportType"));
        }
        if (elementContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementContainer", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "getImportType"));
        }
        if (ES6PsiUtil.isExternalModule((PsiElement)elementToImport)) {
            return ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL;
        }
        if (elementContainer instanceof TypeScriptModule && (container = (TypeScriptModule)elementContainer).isAugmentation()) {
            if (TypeScriptAutoImportUtil.isSelfExportedAugmentationModule(container)) {
                return ES6ImportPsiUtil.ImportExportType.SPECIFIER;
            }
            return null;
        }
        JSExportAssignment exportAssignment = TypeScriptAutoImportUtil.getExportAssignment(elementContainer);
        if (exportAssignment instanceof TypeScriptExportAssignment) {
            if (elementToImport instanceof TypeScriptModule) {
                return ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL;
            }
            return ES6ImportPsiUtil.ImportExportType.TS_REQUIRE_IMPORT;
        }
        if (namespace != null && elementContainer instanceof TypeScriptModule && !ES6PsiUtil.isExternalModule(elementContainer)) {
            PsiElement module = ES6PsiUtil.findExternalModule(elementContainer);
            if (module == null) {
                return ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE;
            }
            JSExportAssignment externalModuleExportAssignment = TypeScriptAutoImportUtil.getExportAssignment(module);
            if (externalModuleExportAssignment == null || elementContainer.getParent() != module) {
                return ES6ImportPsiUtil.ImportExportType.TS_NS_AND_MODULE;
            }
        }
        ES6ImportPsiUtil.ImportExportType isExportDefault = ES6ImportPsiUtil.ImportExportType.DEFAULT;
        if (elementToImport instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)elementToImport).getAttributeList();
            if (!(elementToImport.getParent() instanceof JSExportAssignment) && attributeList != null && elementToImport instanceof JSElementBase && ((JSElementBase)elementToImport).isExported()) {
                isExportDefault = ES6ImportPsiUtil.ImportExportType.SPECIFIER;
            }
        }
        return isExportDefault;
    }

    public boolean tryToUseExistingImport(@NotNull String externalModuleName, @Nullable PsiElement externalModule, @NotNull ES6ImportPsiUtil.ImportExportType importType, @NotNull PsiElement scope) {
        PsiElement grandParent;
        if (externalModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalModuleName", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "tryToUseExistingImport"));
        }
        if (importType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importType", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "tryToUseExistingImport"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor", "tryToUseExistingImport"));
        }
        PsiElement parent = this.myPlace.getParent();
        if (parent instanceof ES6ImportSpecifier && (grandParent = parent.getParent()) instanceof ES6ImportDeclaration && ((ES6ImportDeclaration)grandParent).getFromClause() == null) {
            return ES6CreateImportUtil.insertFromClause((ES6ImportDeclaration)grandParent, externalModuleName);
        }
        if (JSCodeStyleSettings.isMergeImports(this.myPlace) && importType.isES6()) {
            ES6ImportDeclaration possibleImport = ES6ImportPsiUtil.findExistingES6Import(scope, externalModule, externalModuleName, true);
            return possibleImport != null && ES6ImportPsiUtil.tryToAddImportToExistingDeclaration(possibleImport, this.myImportedName, importType);
        }
        return false;
    }
}

