/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptReferenceContributor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.typescript.intentions.TypeScriptReferencesLibraryFix;
import com.intellij.lang.typescript.psi.TypeScriptReferencePathValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReferencePathValidatorImpl
implements TypeScriptReferencePathValidator {
    public static final TypeScriptReferencePathValidator INSTANCE = new TypeScriptReferencePathValidatorImpl();
    private static final Key<ParameterizedCachedValue<List<VirtualFile>, JSFile>> OUT_OF_PROJECT_REFERENCES_KEY = Key.create((String)"TS.FILES.OUT.OF.PROJECT.REFS");
    private static final ParameterizedCachedValueProvider<List<VirtualFile>, JSFile> OUT_OF_PROJECT_REFERENCES_PROVIDER = new ParameterizedCachedValueProvider<List<VirtualFile>, JSFile>(){

        @Nullable
        public CachedValueProvider.Result<List<VirtualFile>> compute(JSFile file) {
            Project project = file.getProject();
            Object[] includedFiles = FileIncludeManager.getManager((Project)project).getIncludedFiles(file.getVirtualFile(), true, true);
            if (includedFiles.length == 0) {
                return CachedValueProvider.Result.create((Object)ContainerUtil.emptyList(), (Object[])new Object[]{file});
            }
            GlobalSearchScope scope = TypeScriptReferencePathValidatorImpl.getAllScope(file);
            List outOfProjectFiles = ContainerUtil.filter((Object[])includedFiles, file1 -> !scope.accept(file1) && TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file1.getFileType()));
            ArrayList depends = ContainerUtil.newArrayListWithCapacity((int)(outOfProjectFiles.size() + 1));
            depends.add(file);
            depends.addAll(outOfProjectFiles);
            return CachedValueProvider.Result.create((Object)outOfProjectFiles, (Collection)depends);
        }
    };

    @Override
    public boolean hasOutOfProjectReferences(@NotNull JSFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptReferencePathValidatorImpl", "hasOutOfProjectReferences"));
        }
        return !this.getOutOfProjectReferences(file).isEmpty();
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getOutOfProjectReferences(@NotNull JSFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptReferencePathValidatorImpl", "getOutOfProjectReferences"));
        }
        List value = (List)CachedValuesManager.getManager((Project)file.getProject()).getParameterizedCachedValue((UserDataHolder)file, OUT_OF_PROJECT_REFERENCES_KEY, OUT_OF_PROJECT_REFERENCES_PROVIDER, false, (Object)file);
        List list = value == null ? ContainerUtil.emptyList() : value;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptReferencePathValidatorImpl", "getOutOfProjectReferences"));
        }
        return list;
    }

    @Override
    public void checkReferences(@NotNull PsiComment comment, @NotNull AnnotationHolder holder, boolean error) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/typescript/psi/TypeScriptReferencePathValidatorImpl", "checkReferences"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/typescript/psi/TypeScriptReferencePathValidatorImpl", "checkReferences"));
        }
        PsiElement parent = comment.getParent();
        if (!(parent instanceof JSFile)) {
            return;
        }
        JSFile file = (JSFile)parent;
        if (!this.hasOutOfProjectReferences(file)) {
            return;
        }
        GlobalSearchScope scope = TypeScriptReferencePathValidatorImpl.getAllScope(file);
        if (!scope.accept(((JSFile)parent).getVirtualFile())) {
            return;
        }
        Matcher matcher = TypeScriptReferenceContributor.TYPESCRIPT_REFERENCE_PATH.matcher(comment.getText());
        if (!matcher.matches()) {
            return;
        }
        boolean valid = true;
        for (PsiReference reference : comment.getReferences()) {
            PsiElement resolve;
            if (reference instanceof FileReference && !((FileReference)reference).isLast() || !((resolve = reference.resolve()) instanceof JSFile) || !DialectDetector.isTypeScript(resolve)) continue;
            JSFile resolvedFile = (JSFile)resolve;
            if (!scope.accept(resolvedFile.getVirtualFile())) {
                valid = false;
                break;
            }
            if (!this.hasOutOfProjectReferences(resolvedFile)) continue;
            valid = false;
            error = false;
            break;
        }
        if (!valid) {
            this.createErrorAnnotationWithQuickFix(file, comment, holder, error);
        }
    }

    @NotNull
    private static GlobalSearchScope getAllScope(@NotNull JSFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptReferencePathValidatorImpl", "getAllScope"));
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)file.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptReferencePathValidatorImpl", "getAllScope"));
        }
        return globalSearchScope;
    }

    public void createErrorAnnotationWithQuickFix(@NotNull JSFile file, @NotNull PsiComment host, @NotNull AnnotationHolder holder, boolean error) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptReferencePathValidatorImpl", "createErrorAnnotationWithQuickFix"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/typescript/psi/TypeScriptReferencePathValidatorImpl", "createErrorAnnotationWithQuickFix"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/typescript/psi/TypeScriptReferencePathValidatorImpl", "createErrorAnnotationWithQuickFix"));
        }
        Collection<VirtualFile> files = this.getOutOfProjectReferences(file);
        assert (!files.isEmpty());
        new JSAnnotatorProblemReporter(holder).registerProblem((PsiElement)host, "The reference includes files outside the project", error ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.WEAK_WARNING, new TypeScriptReferencesLibraryFix((PsiElement)host));
    }
}

