/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings;

import com.intellij.application.options.editor.AutoImportOptionsProvider;
import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class JSImportOptionsProvider
implements AutoImportOptionsProvider {
    private JBCheckBox myAddTypeScriptImports;
    private JBCheckBox myAddES6Imports;
    private JPanel myPanel = new JPanel((LayoutManager)new GridLayoutManager(4, 1));

    public JSImportOptionsProvider() {
        this.myPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JSBundle.message((String)"es6.auto.import.options.title", (Object[])new Object[0])));
        this.myAddES6Imports = new JBCheckBox(JSBundle.message((String)"es6.auto.import.options.completion.add.imports", (Object[])new Object[0]));
        this.myAddTypeScriptImports = new JBCheckBox(JSBundle.message((String)"typescript.auto.import.options.completion.add.imports", (Object[])new Object[0]));
        this.myPanel.add((Component)this.myAddES6Imports, this.createConstraints(0));
        this.myPanel.add((Component)JSImportOptionsProvider.createLinkComponent("JavaScript"), this.createConstraints(1));
        this.myPanel.add((Component)this.myAddTypeScriptImports, this.createConstraints(2));
        this.myPanel.add((Component)JSImportOptionsProvider.createLinkComponent("TypeScript"), this.createConstraints(3));
    }

    @NotNull
    private static HyperlinkLabel createLinkComponent(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/settings/JSImportOptionsProvider", "createLinkComponent"));
        }
        HyperlinkLabel label = new HyperlinkLabel();
        label.setHyperlinkText("Find more configuration options in ", "Code Style", "");
        label.addHyperlinkListener(e -> {
            Settings settings;
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/settings/JSImportOptionsProvider", "lambda$createLinkComponent$0"));
            }
            DataContext context = (DataContext)DataManager.getInstance().getDataContextFromFocus().getResult();
            if (context != null && (settings = (Settings)Settings.KEY.getData(context)) != null) {
                Configurable configurable = settings.find("preferences.sourceCode." + name);
                settings.select(configurable);
            }
        });
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)label);
        HyperlinkLabel hyperlinkLabel = label;
        if (hyperlinkLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/settings/JSImportOptionsProvider", "createLinkComponent"));
        }
        return hyperlinkLabel;
    }

    @NotNull
    public GridConstraints createConstraints(int row) {
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(row);
        constraints.setAnchor(9);
        GridConstraints gridConstraints = constraints;
        if (gridConstraints == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/settings/JSImportOptionsProvider", "createConstraints"));
        }
        return gridConstraints;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        return settings.isShowTypeScriptAutoImport() != this.myAddTypeScriptImports.isSelected() || settings.isShowJavaScriptAutoImport() != this.myAddES6Imports.isSelected();
    }

    public void apply() throws ConfigurationException {
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        settings.setShowTypeScriptAutoImport(this.myAddTypeScriptImports.isSelected());
        settings.setShowJavaScriptAutoImport(this.myAddES6Imports.isSelected());
    }

    public void reset() {
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        this.myAddTypeScriptImports.setSelected(settings.isShowTypeScriptAutoImport());
        this.myAddES6Imports.setSelected(settings.isShowJavaScriptAutoImport());
    }

    public void disposeUIResources() {
    }
}

