/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.settings.exclude.TypeScriptGeneratedFilesManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGeneratedFilesExcludePolicy
implements DirectoryIndexExcludePolicy {
    private final TypeScriptGeneratedFilesManager myManager;

    public TypeScriptGeneratedFilesExcludePolicy(@Nullable TypeScriptGeneratedFilesManager manager) {
        this.myManager = manager;
    }

    @NotNull
    public VirtualFile[] getExcludeRootsForProject() {
        if (!TypeScriptCompilerSettings.excludeGeneratedJSFiles() || ApplicationManager.getApplication().isUnitTestMode()) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesExcludePolicy", "getExcludeRootsForProject"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        if (this.myManager == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesExcludePolicy", "getExcludeRootsForProject"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        List result = ContainerUtil.newSmartList();
        ReadAction.run(() -> result.addAll(this.myManager.getExcludedPlainJSFiles()));
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesExcludePolicy", "getExcludeRootsForProject"));
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFilePointer[] getExcludeRootsForModule(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesExcludePolicy", "getExcludeRootsForModule"));
        }
        if (VirtualFilePointer.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesExcludePolicy", "getExcludeRootsForModule"));
        }
        return VirtualFilePointer.EMPTY_ARRAY;
    }
}

