/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.TypeScriptJSXFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.settings.exclude.TypeScriptGeneratedFilesManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeScriptGeneratedFilesStartupActivity
implements StartupActivity {
    public static final String[] JS_AND_DTS_EXTENSIONS = new String[]{".js.map", ".js", ".jsx", ".d.ts"};

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesStartupActivity", "runActivity"));
        }
        final TypeScriptGeneratedFilesManager generatedFilesManager = TypeScriptGeneratedFilesManager.getInstance(project);
        if (generatedFilesManager == null) {
            return;
        }
        if (!generatedFilesManager.isProjectProcessed()) {
            TypeScriptGeneratedFilesStartupActivity.addPlainJavaScriptAndDeclarationFilesToExclude(project, generatedFilesManager);
        }
        project.getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesStartupActivity$1", "after"));
                }
                List excludedFiles = null;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile candidate;
                    if (!(vFileEvent instanceof VFileCreateEvent) || !TypeScriptGeneratedFilesStartupActivity.shouldExcludeFile(candidate = vFileEvent.getFile())) continue;
                    if (excludedFiles == null) {
                        excludedFiles = ContainerUtil.newSmartList();
                    }
                    excludedFiles.add(candidate);
                }
                if (excludedFiles != null) {
                    generatedFilesManager.addFiles(excludedFiles);
                    TypeScriptGeneratedFilesStartupActivity.updateProject(project, generatedFilesManager);
                }
            }
        });
    }

    private static void updateProject(@NotNull Project project, TypeScriptGeneratedFilesManager generatedFilesManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesStartupActivity", "updateProject"));
        }
        TransactionGuard.submitTransaction((Disposable)project, generatedFilesManager::updateProject);
    }

    private static void addPlainJavaScriptAndDeclarationFilesToExclude(@NotNull Project project, TypeScriptGeneratedFilesManager generatedFilesManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesStartupActivity", "addPlainJavaScriptAndDeclarationFilesToExclude"));
        }
        Runnable runnable = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesStartupActivity", "lambda$addPlainJavaScriptAndDeclarationFilesToExclude$3"));
            }
            Runnable action = () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesStartupActivity", "lambda$null$2"));
                }
                if (project.isDisposed() || !project.isOpen() || !TypeScriptCompilerSettings.excludeGeneratedJSFiles()) {
                    return;
                }
                ArrayList toExcludeFiles = ContainerUtil.newArrayList();
                FileTypeIndex.processFiles((FileType)TypeScriptFileType.INSTANCE, file -> TypeScriptGeneratedFilesStartupActivity.addFileToExclude(toExcludeFiles, file), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
                FileTypeIndex.processFiles((FileType)TypeScriptJSXFileType.INSTANCE, file -> TypeScriptGeneratedFilesStartupActivity.addFileToExclude(toExcludeFiles, file), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
                generatedFilesManager.setFiles(toExcludeFiles);
                generatedFilesManager.updateVersion();
                if (!toExcludeFiles.isEmpty()) {
                    TypeScriptGeneratedFilesStartupActivity.updateProject(project, generatedFilesManager);
                }
            };
            DumbService.getInstance((Project)project).runReadActionInSmartMode(action);
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(runnable);
        }
    }

    private static boolean shouldExcludeFile(VirtualFile candidateToExclude) {
        if (candidateToExclude == null) {
            return false;
        }
        String name = candidateToExclude.getName();
        String jsExtension = JSFileReference.findExtension(name, JS_AND_DTS_EXTENSIONS);
        if (jsExtension == null) {
            return false;
        }
        String jsFileNameWithoutExtension = TypeScriptUtil.getNameWithoutExtension(name, jsExtension);
        VirtualFile directory = candidateToExclude.getParent();
        if (directory == null) {
            return false;
        }
        for (String ext : TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DTS) {
            VirtualFile child = directory.findChild(jsFileNameWithoutExtension + ext);
            if (child == null) continue;
            return true;
        }
        return false;
    }

    private static boolean addFileToExclude(ArrayList<VirtualFile> toExcludeFiles, VirtualFile file) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String fileName = file.getName();
        String extension = JSFileReference.findExtension(fileName, TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DTS);
        if (StringUtil.isEmpty((String)extension)) {
            return true;
        }
        VirtualFile directory = file.getParent();
        String tsFileNameWithoutExtension = TypeScriptUtil.getNameWithoutExtension(fileName, extension);
        if (!StringUtil.isEmpty((String)tsFileNameWithoutExtension)) {
            for (VirtualFile virtualFile : directory.getChildren()) {
                String jsFileNameWithoutExtension;
                String jsExtension;
                String jsCandidateName = virtualFile.getName();
                if (!jsCandidateName.startsWith(tsFileNameWithoutExtension) || (jsExtension = JSFileReference.findExtension(jsCandidateName, JS_AND_DTS_EXTENSIONS)) == null || !tsFileNameWithoutExtension.equals(jsFileNameWithoutExtension = TypeScriptUtil.getNameWithoutExtension(jsCandidateName, jsExtension))) continue;
                toExcludeFiles.add(virtualFile);
            }
        }
        return true;
    }
}

