/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.TimingLog;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.serialization.CannotLoadJpsModelException;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsElementExtensionSerializerBase;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;

public abstract class JpsLoaderBase {
    private static final Logger LOG = Logger.getInstance(JpsLoaderBase.class);
    private static final int MAX_ATTEMPTS = 5;
    private final JpsMacroExpander myMacroExpander;

    protected JpsLoaderBase(JpsMacroExpander macroExpander) {
        this.myMacroExpander = macroExpander;
    }

    protected Element loadRootElement(@NotNull Path file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/model/serialization/JpsLoaderBase", "loadRootElement"));
        }
        return JpsLoaderBase.loadRootElement(file, this.myMacroExpander);
    }

    protected <E extends JpsElement> void loadComponents(@NotNull Path dir, String defaultFileName, JpsElementExtensionSerializerBase<E> serializer, E element) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/jps/model/serialization/JpsLoaderBase", "loadComponents"));
        }
        String fileName = serializer.getConfigFileName();
        Path configFile = dir.resolve(fileName != null ? fileName : defaultFileName);
        Runnable timingLog = TimingLog.startActivity("loading: " + configFile.getFileName() + ":" + serializer.getComponentName());
        Element componentTag = Files.exists(configFile, new LinkOption[0]) ? JDomSerializationUtil.findComponent(this.loadRootElement(configFile), serializer.getComponentName()) : null;
        if (componentTag != null) {
            serializer.loadExtension(element, componentTag);
        } else {
            serializer.loadExtensionWithDefaultSettings(element);
        }
        timingLog.run();
    }

    protected static Element loadRootElement(@NotNull Path file, JpsMacroExpander macroExpander) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/model/serialization/JpsLoaderBase", "loadRootElement"));
        }
        try {
            Element element = JpsLoaderBase.tryLoadRootElement(file);
            macroExpander.substitute(element, SystemInfo.isFileSystemCaseSensitive);
            return element;
        }
        catch (JDOMException e) {
            throw new CannotLoadJpsModelException(file.toFile(), "Cannot parse xml file " + file.toAbsolutePath() + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CannotLoadJpsModelException(file.toFile(), "Cannot read file " + file.toAbsolutePath() + ": " + e.getMessage(), e);
        }
    }

    private static Element tryLoadRootElement(@NotNull Path file) throws IOException, JDOMException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/model/serialization/JpsLoaderBase", "tryLoadRootElement"));
        }
        for (int i = 0; i < 4; ++i) {
            try {
                return JDOMUtil.load((Reader)Files.newBufferedReader(file));
            }
            catch (Exception e) {
                LOG.info("Loading attempt #" + i + " failed", (Throwable)e);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return JDOMUtil.load((Reader)Files.newBufferedReader(file));
    }
}

