/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.TimingLog;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsLoaderBase;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.PathMacroUtil;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactSerializer;
import org.jetbrains.jps.model.serialization.facet.JpsFacetSerializer;
import org.jetbrains.jps.model.serialization.impl.JpsModuleSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.impl.JpsProjectSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkTableSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleClasspathSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModulePropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleRootModelSerializer;
import org.jetbrains.jps.model.serialization.runConfigurations.JpsRunConfigurationSerializer;
import org.jetbrains.jps.service.SharedThreadPool;

public class JpsProjectLoader
extends JpsLoaderBase {
    private static final Logger LOG = Logger.getInstance(JpsProjectLoader.class);
    private static final BoundedTaskExecutor ourThreadPool = new BoundedTaskExecutor("JpsProjectLoader pool", (Executor)SharedThreadPool.getInstance(), Runtime.getRuntime().availableProcessors());
    public static final String CLASSPATH_ATTRIBUTE = "classpath";
    public static final String CLASSPATH_DIR_ATTRIBUTE = "classpath-dir";
    private final JpsProject myProject;
    private final Map<String, String> myPathVariables;

    private JpsProjectLoader(JpsProject project, Map<String, String> pathVariables, Path baseDir) {
        super(JpsProjectLoader.createProjectMacroExpander(pathVariables, baseDir));
        this.myProject = project;
        this.myPathVariables = pathVariables;
        this.myProject.getContainer().setChild(JpsProjectSerializationDataExtensionImpl.ROLE, (JpsElement)new JpsProjectSerializationDataExtensionImpl(baseDir));
    }

    static JpsMacroExpander createProjectMacroExpander(Map<String, String> pathVariables, @NotNull Path baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "createProjectMacroExpander"));
        }
        JpsMacroExpander expander = new JpsMacroExpander(pathVariables);
        expander.addFileHierarchyReplacements("PROJECT_DIR", baseDir.toFile());
        return expander;
    }

    public static void loadProject(JpsProject project, Map<String, String> pathVariables, String projectPath) throws IOException {
        Path file = Paths.get(FileUtil.toCanonicalPath((String)projectPath), new String[0]);
        if (Files.isRegularFile(file, new LinkOption[0]) && projectPath.endsWith(".ipr")) {
            new JpsProjectLoader(project, pathVariables, file.getParent()).loadFromIpr(file);
        } else {
            Path directory;
            Path dotIdea = file.resolve(".idea");
            if (Files.isDirectory(dotIdea, new LinkOption[0])) {
                directory = dotIdea;
            } else if (Files.isDirectory(file, new LinkOption[0]) && file.endsWith(".idea")) {
                directory = file;
            } else {
                throw new IOException("Cannot find IntelliJ IDEA project files at " + projectPath);
            }
            new JpsProjectLoader(project, pathVariables, directory.getParent()).loadFromDirectory(directory);
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static String getDirectoryBaseProjectName(@NotNull Path dir) {
        block25: {
            Throwable throwable;
            Stream<String> stream;
            block22: {
                String string;
                block23: {
                    block24: {
                        if (dir == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "getDirectoryBaseProjectName"));
                        }
                        stream = Files.lines(dir.resolve(".name"));
                        throwable = null;
                        String value = stream.findFirst().map(String::trim).orElse(null);
                        if (value == null) break block22;
                        string = value;
                        if (stream == null) break block23;
                        if (throwable == null) break block24;
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block23;
                    }
                    stream.close();
                }
                String string2 = string;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "getDirectoryBaseProjectName"));
                }
                return string2;
            }
            try {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
                break block25;
                {
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (stream != null) {
                                if (throwable != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string = dir.getParent().getFileName().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "getDirectoryBaseProjectName"));
        }
        return string;
    }

    private void loadFromDirectory(@NotNull Path dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "loadFromDirectory"));
        }
        this.myProject.setName(JpsProjectLoader.getDirectoryBaseProjectName(dir));
        JpsSdkType<?> projectSdkType = this.loadProjectRoot(this.loadRootElement(dir.resolve("misc.xml")));
        for (JpsModelSerializerExtension jpsModelSerializerExtension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsProjectExtensionSerializer jpsProjectExtensionSerializer : jpsModelSerializerExtension.getProjectExtensionSerializers()) {
                this.loadComponents(dir, "misc.xml", jpsProjectExtensionSerializer, this.myProject);
            }
        }
        this.loadModules(this.loadRootElement(dir.resolve("modules.xml")), projectSdkType);
        Runnable timingLog = TimingLog.startActivity("loading project libraries");
        for (Path path : JpsProjectLoader.listXmlFiles(dir.resolve("libraries"))) {
            this.loadProjectLibraries(this.loadRootElement(path));
        }
        timingLog.run();
        Runnable runnable = TimingLog.startActivity("loading artifacts");
        for (Path path : JpsProjectLoader.listXmlFiles(dir.resolve("artifacts"))) {
            this.loadArtifacts(this.loadRootElement(path));
        }
        runnable.run();
        if (JpsProjectLoader.hasRunConfigurationSerializers()) {
            Runnable runnable2 = TimingLog.startActivity("loading run configurations");
            for (Path configurationFile : JpsProjectLoader.listXmlFiles(dir.resolve("runConfigurations"))) {
                JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, this.loadRootElement(configurationFile));
            }
            Path path = dir.resolve("workspace.xml");
            if (Files.exists(path, new LinkOption[0])) {
                Element runManager = JDomSerializationUtil.findComponent(this.loadRootElement(path), "RunManager");
                JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, runManager);
            }
            runnable2.run();
        }
    }

    private static boolean hasRunConfigurationSerializers() {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            if (extension.getRunConfigurationPropertiesSerializers().isEmpty()) continue;
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<Path> listXmlFiles(@NotNull Path dir) {
        List list;
        Throwable throwable;
        DirectoryStream<Path> stream;
        block17: {
            block18: {
                if (dir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "listXmlFiles"));
                }
                stream = Files.newDirectoryStream(dir, it -> it.getFileName().toString().endsWith(".xml") && Files.isRegularFile(it, new LinkOption[0]));
                throwable = null;
                list = ContainerUtil.collect(stream.iterator());
                if (stream == null) break block17;
                if (throwable == null) break block18;
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block17;
            }
            stream.close();
        }
        List list2 = list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "listXmlFiles"));
        }
        return list2;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (stream != null) {
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                stream.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    List<Path> list3 = Collections.emptyList();
                    if (list3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "listXmlFiles"));
                    }
                    return list3;
                }
            }
        }
    }

    private void loadFromIpr(@NotNull Path iprFile) {
        if (iprFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iprFile", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "loadFromIpr"));
        }
        Element iprRoot = this.loadRootElement(iprFile);
        String projectName = FileUtil.getNameWithoutExtension((String)iprFile.getFileName().toString());
        this.myProject.setName(projectName);
        Path iwsFile = iprFile.getParent().resolve(projectName + ".iws");
        Element iwsRoot = Files.exists(iwsFile, new LinkOption[0]) ? this.loadRootElement(iwsFile) : null;
        JpsSdkType<?> projectSdkType = this.loadProjectRoot(iprRoot);
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsProjectExtensionSerializer jpsProjectExtensionSerializer : extension.getProjectExtensionSerializers()) {
                Element rootTag = "workspace.xml".equals(jpsProjectExtensionSerializer.getConfigFileName()) ? iwsRoot : iprRoot;
                Element component = JDomSerializationUtil.findComponent(rootTag, jpsProjectExtensionSerializer.getComponentName());
                if (component != null) {
                    jpsProjectExtensionSerializer.loadExtension(this.myProject, component);
                    continue;
                }
                jpsProjectExtensionSerializer.loadExtensionWithDefaultSettings(this.myProject);
            }
        }
        this.loadModules(iprRoot, projectSdkType);
        this.loadProjectLibraries(JDomSerializationUtil.findComponent(iprRoot, "libraryTable"));
        this.loadArtifacts(JDomSerializationUtil.findComponent(iprRoot, "ArtifactManager"));
        if (JpsProjectLoader.hasRunConfigurationSerializers()) {
            JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, JDomSerializationUtil.findComponent(iprRoot, "ProjectRunConfigurationManager"));
            JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, JDomSerializationUtil.findComponent(iwsRoot, "RunManager"));
        }
    }

    private void loadArtifacts(@Nullable Element artifactManagerComponent) {
        JpsArtifactSerializer.loadArtifacts(this.myProject, artifactManagerComponent);
    }

    @Nullable
    private JpsSdkType<?> loadProjectRoot(Element root) {
        JpsSdkType<?> sdkType = null;
        Element rootManagerElement = JDomSerializationUtil.findComponent(root, "ProjectRootManager");
        if (rootManagerElement != null) {
            String sdkName = rootManagerElement.getAttributeValue("project-jdk-name");
            String sdkTypeId = rootManagerElement.getAttributeValue("project-jdk-type");
            if (sdkName != null) {
                sdkType = JpsSdkTableSerializer.getSdkType(sdkTypeId);
                JpsSdkTableSerializer.setSdkReference(this.myProject.getSdkReferencesTable(), sdkName, sdkType);
            }
        }
        return sdkType;
    }

    private void loadProjectLibraries(@Nullable Element libraryTableElement) {
        JpsLibraryTableSerializer.loadLibraries(libraryTableElement, this.myProject.getLibraryCollection());
    }

    private void loadModules(Element root, @Nullable JpsSdkType<?> projectSdkType) {
        Runnable timingLog = TimingLog.startActivity("loading modules");
        Element componentRoot = JDomSerializationUtil.findComponent(root, "ProjectModuleManager");
        if (componentRoot == null) {
            return;
        }
        THashSet foundFiles = new THashSet();
        ArrayList<Path> moduleFiles = new ArrayList<Path>();
        for (Element moduleElement : JDOMUtil.getChildren((Element)componentRoot.getChild("modules"), (String)"module")) {
            String path = moduleElement.getAttributeValue("filepath");
            Path file = Paths.get(path, new String[0]);
            if (!foundFiles.add(file)) continue;
            moduleFiles.add(file);
        }
        List<JpsModule> modules = JpsProjectLoader.loadModules(moduleFiles, projectSdkType, this.myPathVariables);
        for (JpsModule module : modules) {
            this.myProject.addModule(module);
        }
        timingLog.run();
    }

    @NotNull
    public static List<JpsModule> loadModules(@NotNull List<Path> moduleFiles, @Nullable JpsSdkType<?> projectSdkType, @NotNull Map<String, String> pathVariables) {
        ArrayList<JpsModule> arrayList;
        Path externalModuleDir;
        if (moduleFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFiles", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "loadModules"));
        }
        if (pathVariables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathVariables", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "loadModules"));
        }
        ArrayList<JpsModule> modules = new ArrayList<JpsModule>();
        ArrayList<Future> futureModuleFilesContents = new ArrayList<Future>();
        String externalProjectConfigDir = System.getProperty("external.project.config");
        Path path = externalModuleDir = StringUtil.isEmptyOrSpaces((String)externalProjectConfigDir) ? null : Paths.get(externalProjectConfigDir, "modules");
        if (externalModuleDir != null) {
            LOG.info("External project config dir is used: " + externalProjectConfigDir);
        }
        for (Path path2 : moduleFiles) {
            futureModuleFilesContents.add(ourThreadPool.submit(() -> {
                Path externalPath;
                if (pathVariables == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathVariables", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "lambda$loadModules$1"));
                }
                JpsMacroExpander expander = JpsProjectLoader.createModuleMacroExpander(pathVariables, path2);
                Element data = null;
                if (Files.exists(path2, new LinkOption[0])) {
                    data = JpsProjectLoader.loadRootElement(path2, expander);
                }
                Path path = externalPath = externalModuleDir == null ? null : externalModuleDir.resolve(FileUtilRt.getNameWithoutExtension((String)path2.getFileName().toString()) + ".xml");
                if (externalPath != null && Files.exists(externalPath, new LinkOption[0])) {
                    Element externalData = JpsProjectLoader.loadRootElement(externalPath, expander);
                    if (data == null) {
                        data = externalData;
                    } else {
                        JDOMUtil.merge((Element)data, (Element)externalData);
                    }
                }
                if (data == null) {
                    LOG.info("Module '" + FileUtil.getNameWithoutExtension((String)path2.getFileName().toString()) + "' is skipped: " + path2.toAbsolutePath() + " doesn't exist");
                }
                return Pair.create((Object)path2, (Object)data);
            }));
        }
        try {
            ArrayList<String> classpathDirs = new ArrayList<String>();
            for (Future moduleFile : futureModuleFilesContents) {
                String classpathDir = ((Element)((Pair)moduleFile.get()).getSecond()).getAttributeValue(CLASSPATH_DIR_ATTRIBUTE);
                if (classpathDir == null) continue;
                classpathDirs.add(classpathDir);
            }
            ArrayList<Future> arrayList2 = new ArrayList<Future>();
            for (Future futureModuleFile : futureModuleFilesContents) {
                Pair moduleFile = (Pair)futureModuleFile.get();
                arrayList2.add(ourThreadPool.submit(() -> {
                    if (pathVariables == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathVariables", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "lambda$loadModules$2"));
                    }
                    return JpsProjectLoader.loadModule((Path)moduleFile.getFirst(), (Element)moduleFile.getSecond(), classpathDirs, projectSdkType, pathVariables);
                }));
            }
            for (Future future : arrayList2) {
                JpsModule module = (JpsModule)future.get();
                if (module == null) continue;
                modules.add(module);
            }
            arrayList = modules;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "loadModules"));
        }
        return arrayList;
    }

    @NotNull
    private static JpsModule loadModule(@NotNull Path file, @NotNull Element moduleRoot, List<String> paths, @Nullable JpsSdkType<?> projectSdkType, Map<String, String> pathVariables) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "loadModule"));
        }
        if (moduleRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRoot", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "loadModule"));
        }
        String name = FileUtil.getNameWithoutExtension((String)file.getFileName().toString());
        String typeId = moduleRoot.getAttributeValue("type");
        JpsModulePropertiesSerializer<?> serializer = JpsProjectLoader.getModulePropertiesSerializer(typeId);
        JpsModule module = JpsProjectLoader.createModule(name, moduleRoot, serializer);
        module.getContainer().setChild(JpsModuleSerializationDataExtensionImpl.ROLE, (JpsElement)new JpsModuleSerializationDataExtensionImpl(file.getParent()));
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            extension.loadModuleOptions(module, moduleRoot);
        }
        String baseModulePath = FileUtil.toSystemIndependentName((String)file.getParent().toString());
        String classpath = moduleRoot.getAttributeValue(CLASSPATH_ATTRIBUTE);
        if (classpath == null) {
            JpsModuleRootModelSerializer.loadRootModel(module, JDomSerializationUtil.findComponent(moduleRoot, "NewModuleRootManager"), projectSdkType);
        } else {
            for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
                JpsModuleClasspathSerializer classpathSerializer = extension.getClasspathSerializer();
                if (classpathSerializer == null || !classpathSerializer.getClasspathId().equals(classpath)) continue;
                String classpathDir = moduleRoot.getAttributeValue(CLASSPATH_DIR_ATTRIBUTE);
                JpsMacroExpander expander = JpsProjectLoader.createModuleMacroExpander(pathVariables, file);
                classpathSerializer.loadClasspath(module, classpathDir, baseModulePath, expander, paths, projectSdkType);
            }
        }
        JpsFacetSerializer.loadFacets(module, JDomSerializationUtil.findComponent(moduleRoot, "FacetManager"));
        JpsModule jpsModule = module;
        if (jpsModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "loadModule"));
        }
        return jpsModule;
    }

    static JpsMacroExpander createModuleMacroExpander(Map<String, String> pathVariables, @NotNull Path moduleFile) {
        if (moduleFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFile", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "createModuleMacroExpander"));
        }
        JpsMacroExpander expander = new JpsMacroExpander(pathVariables);
        String moduleDirPath = PathMacroUtil.getModuleDir(moduleFile.toAbsolutePath().toString());
        if (moduleDirPath != null) {
            expander.addFileHierarchyReplacements("MODULE_DIR", new File(FileUtil.toSystemDependentName((String)moduleDirPath)));
        }
        return expander;
    }

    private static <P extends JpsElement> JpsModule createModule(String name, Element moduleRoot, JpsModulePropertiesSerializer<P> loader) {
        String componentName = loader.getComponentName();
        Element component = componentName != null ? JDomSerializationUtil.findComponent(moduleRoot, componentName) : null;
        return JpsElementFactory.getInstance().createModule(name, (JpsModuleType)loader.getType(), loader.loadProperties(component));
    }

    private static JpsModulePropertiesSerializer<?> getModulePropertiesSerializer(@Nullable String typeId) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsModulePropertiesSerializer<?> loader : extension.getModulePropertiesSerializers()) {
                if (!loader.getTypeId().equals(typeId)) continue;
                return loader;
            }
        }
        return new JpsModulePropertiesSerializer<JpsDummyElement>((JpsModuleType)JpsJavaModuleType.INSTANCE, "JAVA_MODULE", null){

            @Override
            public JpsDummyElement loadProperties(@Nullable Element componentElement) {
                return JpsElementFactory.getInstance().createDummyElement();
            }

            @Override
            public void saveProperties(@NotNull JpsDummyElement properties, @NotNull Element componentElement) {
                if (properties == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/model/serialization/JpsProjectLoader$1", "saveProperties"));
                }
                if (componentElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentElement", "org/jetbrains/jps/model/serialization/JpsProjectLoader$1", "saveProperties"));
                }
            }
        };
    }
}

