/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.testframework.AbstractPatternBasedConfigurationProducer;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestMethodGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class PatternGradleConfigurationProducer
extends GradleTestRunConfigurationProducer {
    private final AbstractPatternBasedConfigurationProducer myBaseConfigurationProducer = new GradlePatternBasedConfigurationProducer((ConfigurationType)GradleExternalTaskConfigurationType.getInstance());

    protected PatternGradleConfigurationProducer() {
        super((ConfigurationType)GradleExternalTaskConfigurationType.getInstance());
    }

    @Override
    protected boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        LinkedHashSet tests = new LinkedHashSet();
        PsiElement element = this.myBaseConfigurationProducer.checkPatterns(context, tests);
        if (element == null) {
            return false;
        }
        sourceElement.set((Object)element);
        String projectPath = null;
        LinkedHashSet scriptParameters = ContainerUtil.newLinkedHashSet();
        LinkedHashSet tasksToRun = ContainerUtil.newLinkedHashSet();
        Project project = context.getProject();
        ArrayList resolvedTests = ContainerUtil.newArrayList();
        for (String test : tests) {
            PsiFile psiFile;
            String aClass;
            int i = StringUtil.indexOf((CharSequence)test, (CharSequence)",");
            String string = aClass = i < 0 ? test : test.substring(0, i);
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(aClass, GlobalSearchScope.projectScope((Project)project));
            if (psiClass == null || (psiFile = psiClass.getContainingFile()) == null) continue;
            Module moduleForFile = ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(psiFile.getVirtualFile());
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)moduleForFile)) {
                return false;
            }
            projectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)moduleForFile);
            if (projectPath == null) {
                return false;
            }
            ContainerUtil.addAllNotNull((Collection)tasksToRun, PatternGradleConfigurationProducer.getTasksToRun(moduleForFile));
            String method = i != -1 && test.length() > i + 1 ? test.substring(i + 1) : null;
            scriptParameters.add(TestMethodGradleConfigurationProducer.createTestFilter(aClass, method));
            resolvedTests.add(psiClass.getName() + "," + (method == null ? "" : method));
        }
        if (tasksToRun.isEmpty() || projectPath == null) {
            return false;
        }
        configuration.getSettings().setExternalProjectPath(projectPath);
        configuration.getSettings().setTaskNames((List)ContainerUtil.newArrayList((Iterable)tasksToRun));
        configuration.getSettings().setScriptParameters(StringUtil.join((Collection)scriptParameters, (String)" "));
        String name = resolvedTests.size() > 1 ? (String)resolvedTests.get(0) + " and " + (resolvedTests.size() - 1) + " more" : StringUtil.join(tests, (String)"|");
        configuration.setName(name);
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, contextLocation);
        return true;
    }

    @Override
    protected boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        return false;
    }

    private static class GradlePatternBasedConfigurationProducer
    extends AbstractPatternBasedConfigurationProducer {
        public GradlePatternBasedConfigurationProducer(ConfigurationType configurationType) {
            super(configurationType);
        }

        protected boolean setupConfigurationFromContext(RunConfiguration configuration, ConfigurationContext context, Ref sourceElement) {
            return false;
        }

        public boolean isConfigurationFromContext(RunConfiguration configuration, ConfigurationContext context) {
            return false;
        }
    }
}

