/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleTreeStructureProvider
implements TreeStructureProvider {
    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
        }
        Project project = parent.getProject();
        if (project == null) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
            }
            return collection;
        }
        if (parent instanceof ProjectViewProjectNode) {
            Collection<AbstractTreeNode> collection = GradleTreeStructureProvider.getProjectNodeChildren(project, children);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
            }
            return collection;
        }
        if (parent instanceof ProjectViewModuleGroupNode) {
            List modifiedChildren = ContainerUtil.newSmartList();
            for (Object child : children) {
                if (child instanceof ProjectViewModuleNode) {
                    Module module = (Module)((ProjectViewModuleNode)child).getValue();
                    if (!GradleTreeStructureProvider.showUnderModuleGroup(module)) continue;
                    GradleProjectViewModuleNode sourceSetNode = GradleTreeStructureProvider.getGradleModuleNode(project, (ProjectViewModuleNode)child, settings);
                    child = sourceSetNode != null ? sourceSetNode : child;
                } else if (child instanceof PsiDirectoryNode) {
                    GradleModuleDirectoryNode sourceSetNode = GradleTreeStructureProvider.getGradleModuleNode(project, (PsiDirectoryNode)child, settings);
                    if (sourceSetNode != null && !GradleTreeStructureProvider.showUnderModuleGroup(sourceSetNode.myModule)) continue;
                    child = sourceSetNode != null ? sourceSetNode : child;
                }
                modifiedChildren.add(child);
            }
            List list = modifiedChildren;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
            }
            return list;
        }
        if (parent instanceof GradleProjectViewModuleNode) {
            Module module = (Module)((GradleProjectViewModuleNode)parent).getValue();
            String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
            List modifiedChildren = ContainerUtil.newSmartList();
            for (AbstractTreeNode child : children) {
                PsiDirectory psiDirectory;
                if (child instanceof PsiDirectoryNode && (psiDirectory = (PsiDirectory)((PsiDirectoryNode)child).getValue()) != null) {
                    VirtualFile virtualFile = psiDirectory.getVirtualFile();
                    if (projectPath != null && FileUtil.isAncestor((String)projectPath, (String)virtualFile.getPath(), (boolean)false)) continue;
                }
                modifiedChildren.add(child);
            }
            List list = modifiedChildren;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
            }
            return list;
        }
        if (parent instanceof PsiDirectoryNode) {
            List modifiedChildren = ContainerUtil.newSmartList();
            for (Object child : children) {
                if (child instanceof PsiDirectoryNode) {
                    GradleModuleDirectoryNode sourceSetNode = GradleTreeStructureProvider.getGradleModuleNode(project, (PsiDirectoryNode)child, settings);
                    child = sourceSetNode != null ? sourceSetNode : child;
                }
                modifiedChildren.add(child);
            }
            List list = modifiedChildren;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
            }
            return list;
        }
        Collection<AbstractTreeNode> collection = children;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "modify"));
        }
        return collection;
    }

    private static boolean showUnderModuleGroup(Module module) {
        if (ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
            for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                if (projectPath == null || FileUtil.isAncestor((String)projectPath, (String)root.getPath(), (boolean)true)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @NotNull
    private static Collection<AbstractTreeNode> getProjectNodeChildren(@NotNull Project project, @NotNull Collection<AbstractTreeNode> children) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "getProjectNodeChildren"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "getProjectNodeChildren"));
        }
        List modifiedChildren = ContainerUtil.newSmartList();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (AbstractTreeNode child : children) {
            PsiDirectory psiDirectory;
            Pair parentNodePair = null;
            if (child instanceof ProjectViewModuleGroupNode) {
                ProjectViewModuleGroupNode groupNode = (ProjectViewModuleGroupNode)child;
                Collection groupNodeChildren = groupNode.getChildren();
                for (AbstractTreeNode node : groupNodeChildren) {
                    if (node instanceof PsiDirectoryNode) {
                        PsiDirectoryNode psiDirectoryNode = (PsiDirectoryNode)node;
                        PsiDirectory psiDirectory2 = (PsiDirectory)psiDirectoryNode.getValue();
                        if (psiDirectory2 == null) {
                            parentNodePair = null;
                        } else {
                            VirtualFile virtualFile = psiDirectory2.getVirtualFile();
                            Module module = fileIndex.getModuleForFile(virtualFile);
                            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
                                parentNodePair = null;
                            } else {
                                if (parentNodePair == null || VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)((VirtualFile)parentNodePair.first), (boolean)false)) {
                                    parentNodePair = Pair.pair((Object)virtualFile, (Object)psiDirectoryNode);
                                    continue;
                                }
                                if (VfsUtilCore.isAncestor((VirtualFile)((VirtualFile)parentNodePair.first), (VirtualFile)virtualFile, (boolean)false)) continue;
                                parentNodePair = null;
                            }
                        }
                    } else {
                        parentNodePair = null;
                    }
                    break;
                }
            } else if (child instanceof PsiDirectoryNode && child.getParent() == null && (psiDirectory = (PsiDirectory)((PsiDirectoryNode)child).getValue()) != null) {
                VirtualFile directoryFile = psiDirectory.getVirtualFile();
                GradleModuleDirectoryNode gradleModuleNode = GradleTreeStructureProvider.getGradleModuleNode(project, (PsiDirectoryNode)child, ((PsiDirectoryNode)child).getSettings());
                if (gradleModuleNode != null) {
                    parentNodePair = Pair.pair((Object)directoryFile, (Object)((Object)gradleModuleNode));
                }
            }
            modifiedChildren.add(parentNodePair != null ? (AbstractTreeNode)parentNodePair.second : child);
        }
        List list = modifiedChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "getProjectNodeChildren"));
        }
        return list;
    }

    @Nullable
    private static GradleProjectViewModuleNode getGradleModuleNode(@NotNull Project project, @NotNull ProjectViewModuleNode moduleNode, ViewSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "getGradleModuleNode"));
        }
        if (moduleNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleNode", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "getGradleModuleNode"));
        }
        Module module = (Module)moduleNode.getValue();
        String moduleShortName = GradleTreeStructureProvider.getGradleModuleShortName(module);
        if (moduleShortName == null) {
            return null;
        }
        return new GradleProjectViewModuleNode(project, module, settings, moduleShortName);
    }

    @Nullable
    private static GradleModuleDirectoryNode getGradleModuleNode(@NotNull Project project, @NotNull PsiDirectoryNode directoryNode, ViewSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "getGradleModuleNode"));
        }
        if (directoryNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryNode", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider", "getGradleModuleNode"));
        }
        PsiDirectory psiDirectory = (PsiDirectory)directoryNode.getValue();
        if (psiDirectory == null) {
            return null;
        }
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        if (!ProjectRootsUtil.isModuleContentRoot((VirtualFile)virtualFile, (Project)project)) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = fileIndex.getModuleForFile(virtualFile);
        String moduleShortName = GradleTreeStructureProvider.getGradleModuleShortName(module);
        if (moduleShortName == null) {
            return null;
        }
        return new GradleModuleDirectoryNode(project, psiDirectory, settings, module, moduleShortName, directoryNode.getFilter());
    }

    @Nullable
    private static String getGradleModuleShortName(Module module) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        if ("sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module))) {
            return GradleProjectResolverUtil.getSourceSetName(module);
        }
        String moduleShortName = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        boolean isRootModule = StringUtil.equals((CharSequence)ExternalSystemApiUtil.getExternalProjectPath((Module)module), (CharSequence)ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
        if (isRootModule || moduleShortName == null) {
            return moduleShortName;
        }
        if (ModuleGrouperKt.isQualifiedModuleNamesEnabled()) {
            moduleShortName = StringUtil.getShortName((String)moduleShortName);
        }
        return StringUtil.getShortName((String)moduleShortName, (char)':');
    }

    private static class GradleProjectViewModuleNode
    extends ProjectViewModuleNode {
        @NotNull
        private final String myModuleShortName;

        public GradleProjectViewModuleNode(Project project, Module value, ViewSettings viewSettings, @NotNull String moduleShortName) {
            if (moduleShortName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleShortName", "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider$GradleProjectViewModuleNode", "<init>"));
            }
            super(project, value, viewSettings);
            this.myModuleShortName = moduleShortName;
        }

        public void update(PresentationData presentation) {
            super.update(presentation);
            presentation.setPresentableText(this.myModuleShortName);
            presentation.addText(this.myModuleShortName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }

        protected boolean showModuleNameInBold() {
            return false;
        }
    }

    private static class GradleModuleDirectoryNode
    extends PsiDirectoryNode {
        private String myModuleShortName;
        private Module myModule;

        public GradleModuleDirectoryNode(Project project, PsiDirectory psiDirectory, ViewSettings settings, Module module, String moduleShortName, PsiFileSystemItemFilter filter) {
            super(project, psiDirectory, settings, filter);
            this.myModuleShortName = moduleShortName;
            this.myModule = module;
        }

        protected boolean shouldShowModuleName() {
            return false;
        }

        protected void updateImpl(PresentationData data) {
            super.updateImpl(data);
            PsiDirectory psiDirectory = (PsiDirectory)this.getValue();
            assert (psiDirectory != null);
            VirtualFile directoryFile = psiDirectory.getVirtualFile();
            if (StringUtil.isNotEmpty((String)this.myModuleShortName) && !StringUtil.equalsIgnoreCase((CharSequence)this.myModuleShortName.replace("-", ""), (CharSequence)directoryFile.getName().replace("-", ""))) {
                data.addText("[" + this.myModuleShortName + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        }
    }
}

