/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.DelegatingGradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;

@State(name="GradleSettings", storages={@Storage(value="gradle.xml")})
public class GradleSettings
extends AbstractExternalSystemSettings<GradleSettings, GradleProjectSettings, GradleSettingsListener>
implements PersistentStateComponent<MyState> {
    private final GradleSystemSettings mySystemSettings;

    public GradleSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/settings/GradleSettings", "<init>"));
        }
        super(GradleSettingsListener.TOPIC, project);
        this.mySystemSettings = GradleSystemSettings.getInstance();
    }

    @NotNull
    public static GradleSettings getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/settings/GradleSettings", "getInstance"));
        }
        GradleSettings gradleSettings = (GradleSettings)((Object)ServiceManager.getService((Project)project, GradleSettings.class));
        if (gradleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/settings/GradleSettings", "getInstance"));
        }
        return gradleSettings;
    }

    public void subscribe(@NotNull ExternalSystemSettingsListener<GradleProjectSettings> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/gradle/settings/GradleSettings", "subscribe"));
        }
        this.getProject().getMessageBus().connect((Disposable)this.getProject()).subscribe(GradleSettingsListener.TOPIC, (Object)new DelegatingGradleSettingsListenerAdapter(listener));
    }

    protected void copyExtraSettingsFrom(@NotNull GradleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/gradle/settings/GradleSettings", "copyExtraSettingsFrom"));
        }
    }

    @Nullable
    public MyState getState() {
        MyState state = new MyState();
        this.fillState(state);
        return state;
    }

    public void loadState(MyState state) {
        super.loadState((AbstractExternalSystemSettings.State)state);
    }

    @Nullable
    public String getServiceDirectoryPath() {
        return this.mySystemSettings.getServiceDirectoryPath();
    }

    public void setServiceDirectoryPath(@Nullable String newPath) {
        String myServiceDirectoryPath = this.mySystemSettings.getServiceDirectoryPath();
        if (!Comparing.equal((String)myServiceDirectoryPath, (String)newPath)) {
            this.mySystemSettings.setServiceDirectoryPath(newPath);
            ((GradleSettingsListener)this.getPublisher()).onServiceDirectoryPathChange(myServiceDirectoryPath, newPath);
        }
    }

    @Nullable
    public String getGradleVmOptions() {
        return this.mySystemSettings.getGradleVmOptions();
    }

    public void setGradleVmOptions(@Nullable String gradleVmOptions) {
        String myGradleVmOptions = this.mySystemSettings.getGradleVmOptions();
        if (!Comparing.equal((String)myGradleVmOptions, (String)gradleVmOptions)) {
            this.mySystemSettings.setGradleVmOptions(gradleVmOptions);
            ((GradleSettingsListener)this.getPublisher()).onGradleVmOptionsChange(myGradleVmOptions, gradleVmOptions);
        }
    }

    public boolean isOfflineWork() {
        return this.mySystemSettings.isOfflineWork();
    }

    public void setOfflineWork(boolean isOfflineWork) {
        this.mySystemSettings.setOfflineWork(isOfflineWork);
    }

    protected void checkSettings(@NotNull GradleProjectSettings old, @NotNull GradleProjectSettings current) {
        if (old == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "old", "org/jetbrains/plugins/gradle/settings/GradleSettings", "checkSettings"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "org/jetbrains/plugins/gradle/settings/GradleSettings", "checkSettings"));
        }
        if (!Comparing.equal((String)old.getGradleHome(), (String)current.getGradleHome())) {
            ((GradleSettingsListener)this.getPublisher()).onGradleHomeChange(old.getGradleHome(), current.getGradleHome(), current.getExternalProjectPath());
        }
        if (old.getDistributionType() != current.getDistributionType()) {
            ((GradleSettingsListener)this.getPublisher()).onGradleDistributionTypeChange(current.getDistributionType(), current.getExternalProjectPath());
        }
        if (old.isResolveModulePerSourceSet() != current.isResolveModulePerSourceSet()) {
            ExternalProjectsManager.getInstance((Project)this.getProject()).getExternalProjectsWatcher().markDirty(current.getExternalProjectPath());
        }
    }

    public static class MyState
    implements AbstractExternalSystemSettings.State<GradleProjectSettings> {
        private Set<GradleProjectSettings> myProjectSettings = ContainerUtilRt.newTreeSet();

        @AbstractCollection(surroundWithTag=false, elementTypes={GradleProjectSettings.class})
        public Set<GradleProjectSettings> getLinkedExternalProjectsSettings() {
            return this.myProjectSettings;
        }

        public void setLinkedExternalProjectsSettings(Set<GradleProjectSettings> settings) {
            if (settings != null) {
                this.myProjectSettings.addAll(settings);
            }
        }
    }
}

