/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeBuilder;
import org.intellij.markdown.parser.TreeBuilder;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J6\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J \u0010\u0019\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\fH\u0014J(\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, d2={"Lorg/intellij/markdown/parser/MyBuilder;", "Lorg/intellij/markdown/parser/TreeBuilder;", "nodeBuilder", "Lorg/intellij/markdown/ast/ASTNodeBuilder;", "tokensCache", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "(Lorg/intellij/markdown/ast/ASTNodeBuilder;Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;)V", "currentTokenPosition", "", "addRawTokens", "", "childrenWithWhitespaces", "", "Lorg/intellij/markdown/ast/ASTNode;", "from", "dx", "exitOffset", "createASTNodeOnClosingEvent", "Lorg/intellij/markdown/parser/TreeBuilder$MyASTNodeWrapper;", "event", "Lorg/intellij/markdown/parser/TreeBuilder$MyEvent;", "currentNodeChildren", "", "isTopmostNode", "", "flushEverythingBeforeEvent", "flushOneTokenToTree"})
public final class MyBuilder
extends TreeBuilder {
    private int currentTokenPosition;
    private final TokensCache tokensCache;

    @Override
    protected void flushEverythingBeforeEvent(@NotNull TreeBuilder.MyEvent event, @Nullable List<TreeBuilder.MyASTNodeWrapper> currentNodeChildren) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (this.currentTokenPosition == -1) {
            this.currentTokenPosition = event.getPosition();
        }
        while (this.currentTokenPosition < event.getPosition()) {
            this.flushOneTokenToTree(this.tokensCache, currentNodeChildren, this.currentTokenPosition);
            int n = this.currentTokenPosition;
            this.currentTokenPosition = n + 1;
        }
    }

    private final void flushOneTokenToTree(TokensCache tokensCache, List<TreeBuilder.MyASTNodeWrapper> currentNodeChildren, int currentTokenPosition) {
        boolean bl;
        TokensCache.Iterator iterator = new TokensCache.Iterator(tokensCache, currentTokenPosition);
        boolean bl2 = bl = iterator.getType() != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ASTNodeBuilder aSTNodeBuilder = this.getNodeBuilder();
        IElementType iElementType = iterator.getType();
        if (iElementType == null) {
            Intrinsics.throwNpe();
        }
        List<ASTNode> nodes = aSTNodeBuilder.createLeafNodes(iElementType, iterator.getStart(), iterator.getEnd());
        for (ASTNode node : nodes) {
            List<TreeBuilder.MyASTNodeWrapper> list = currentNodeChildren;
            if (list == null) continue;
            list.add(new TreeBuilder.MyASTNodeWrapper(node, iterator.getIndex(), iterator.getIndex() + 1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected TreeBuilder.MyASTNodeWrapper createASTNodeOnClosingEvent(@NotNull TreeBuilder.MyEvent event, @NotNull List<TreeBuilder.MyASTNodeWrapper> currentNodeChildren, boolean isTopmostNode) {
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull(currentNodeChildren, (String)"currentNodeChildren");
        IElementType type = event.getInfo().getType();
        int startTokenId = event.getInfo().getRange().getStart();
        int endTokenId = event.getInfo().getRange().getEndInclusive();
        ArrayList<ASTNode> childrenWithWhitespaces = new ArrayList<ASTNode>(currentNodeChildren.size());
        if (isTopmostNode) {
            this.addRawTokens(this.tokensCache, (List<ASTNode>)childrenWithWhitespaces, startTokenId, -1, 1);
        }
        if ((n2 = 1) <= (n = currentNodeChildren.size() - 1)) {
            while (true) {
                void i;
                TreeBuilder.MyASTNodeWrapper prev = currentNodeChildren.get((int)(i - true));
                TreeBuilder.MyASTNodeWrapper next = currentNodeChildren.get((int)i);
                childrenWithWhitespaces.add(prev.getAstNode());
                this.addRawTokens(this.tokensCache, (List<ASTNode>)childrenWithWhitespaces, prev.getEndTokenIndex() - 1, 1, new TokensCache.Iterator(this.tokensCache, next.getStartTokenIndex()).getStart());
                if (i == n) break;
                ++i;
            }
        }
        if (!currentNodeChildren.isEmpty()) {
            childrenWithWhitespaces.add(((TreeBuilder.MyASTNodeWrapper)CollectionsKt.last(currentNodeChildren)).getAstNode());
        }
        if (isTopmostNode) {
            this.addRawTokens(this.tokensCache, (List<ASTNode>)childrenWithWhitespaces, endTokenId - 1, 1, new TokensCache.Iterator(this.tokensCache, endTokenId).getStart());
        }
        ASTNode newNode = this.getNodeBuilder().createCompositeNode(type, (List<? extends ASTNode>)childrenWithWhitespaces);
        return new TreeBuilder.MyASTNodeWrapper(newNode, startTokenId, endTokenId);
    }

    private final void addRawTokens(TokensCache tokensCache, List<ASTNode> childrenWithWhitespaces, int from, int dx, int exitOffset) {
        TokensCache.Iterator iterator = new TokensCache.Iterator(tokensCache, from);
        int rawIdx = 0;
        while (iterator.rawLookup(rawIdx + dx) != null && iterator.rawStart(rawIdx + dx) != exitOffset) {
            rawIdx += dx;
        }
        while (rawIdx != 0) {
            IElementType rawType;
            if (iterator.rawLookup(rawIdx) == null) {
                Intrinsics.throwNpe();
            }
            childrenWithWhitespaces.addAll((Collection<ASTNode>)this.getNodeBuilder().createLeafNodes(rawType, iterator.rawStart(rawIdx), iterator.rawStart(rawIdx + 1)));
            rawIdx -= dx;
        }
    }

    public MyBuilder(@NotNull ASTNodeBuilder nodeBuilder, @NotNull TokensCache tokensCache) {
        Intrinsics.checkParameterIsNotNull((Object)nodeBuilder, (String)"nodeBuilder");
        Intrinsics.checkParameterIsNotNull((Object)tokensCache, (String)"tokensCache");
        super(nodeBuilder);
        this.tokensCache = tokensCache;
        this.currentTokenPosition = -1;
    }
}

