/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.DomElement;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.plugin.MavenDomPluginModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;

public class MavenPluginDomUtil {
    @Nullable
    public static MavenProject findMavenProject(@NotNull DomElement domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "org/jetbrains/idea/maven/dom/MavenPluginDomUtil", "findMavenProject"));
        }
        XmlElement xmlElement = domElement.getXmlElement();
        if (xmlElement == null) {
            return null;
        }
        PsiFile psiFile = xmlElement.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        return MavenProjectsManager.getInstance(psiFile.getProject()).findProject(file);
    }

    @Nullable
    public static MavenDomPluginModel getMavenPluginModel(DomElement element) {
        MavenProject mavenProject;
        Project project = element.getManager().getProject();
        MavenDomPlugin pluginElement = (MavenDomPlugin)element.getParentOfType(MavenDomPlugin.class, false);
        if (pluginElement == null) {
            return null;
        }
        String groupId = pluginElement.getGroupId().getStringValue();
        String artifactId = pluginElement.getArtifactId().getStringValue();
        String version = pluginElement.getVersion().getStringValue();
        if (StringUtil.isEmpty((String)version) && (mavenProject = MavenPluginDomUtil.findMavenProject(element)) != null) {
            for (MavenPlugin plugin : mavenProject.getPlugins()) {
                if (!MavenArtifactUtil.isPluginIdEquals(groupId, artifactId, plugin.getGroupId(), plugin.getArtifactId())) continue;
                MavenId pluginMavenId = plugin.getMavenId();
                version = pluginMavenId.getVersion();
                break;
            }
        }
        return MavenPluginDomUtil.getMavenPluginModel(project, groupId, artifactId, version);
    }

    @Nullable
    public static MavenDomPluginModel getMavenPluginModel(Project project, String groupId, String artifactId, String version) {
        VirtualFile pluginXmlFile = MavenPluginDomUtil.getPluginXmlFile(project, groupId, artifactId, version);
        if (pluginXmlFile == null) {
            return null;
        }
        return MavenDomUtil.getMavenDomModel(project, pluginXmlFile, MavenDomPluginModel.class);
    }

    public static boolean isPlugin(@NotNull MavenDomConfiguration configuration, @Nullable String groupId, @NotNull String artifactId) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/idea/maven/dom/MavenPluginDomUtil", "isPlugin"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/dom/MavenPluginDomUtil", "isPlugin"));
        }
        MavenDomPlugin domPlugin = (MavenDomPlugin)configuration.getParentOfType(MavenDomPlugin.class, true);
        if (domPlugin == null) {
            return false;
        }
        return MavenPluginDomUtil.isPlugin(domPlugin, groupId, artifactId);
    }

    public static boolean isPlugin(@NotNull MavenDomPlugin plugin, @Nullable String groupId, @NotNull String artifactId) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "org/jetbrains/idea/maven/dom/MavenPluginDomUtil", "isPlugin"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/dom/MavenPluginDomUtil", "isPlugin"));
        }
        if (!artifactId.equals(plugin.getArtifactId().getStringValue())) {
            return false;
        }
        String pluginGroupId = plugin.getGroupId().getStringValue();
        if (groupId == null) {
            return pluginGroupId == null || pluginGroupId.equals("org.apache.maven.plugins") || pluginGroupId.equals("org.codehaus.mojo");
        }
        if (pluginGroupId == null && (groupId.equals("org.apache.maven.plugins") || groupId.equals("org.codehaus.mojo"))) {
            return true;
        }
        return groupId.equals(pluginGroupId);
    }

    @Nullable
    private static VirtualFile getPluginXmlFile(Project project, String groupId, String artifactId, String version) {
        File file = MavenArtifactUtil.getArtifactFile(MavenProjectsManager.getInstance(project).getLocalRepository(), groupId, artifactId, version, "jar");
        VirtualFile pluginFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (pluginFile == null) {
            return null;
        }
        VirtualFile pluginJarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(pluginFile);
        if (pluginJarRoot == null) {
            return null;
        }
        return pluginJarRoot.findFileByRelativePath("META-INF/maven/plugin.xml");
    }
}

