/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters.repositories;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashMap;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.repositories.beans.RepositoriesBean;
import org.jetbrains.idea.maven.dom.converters.repositories.beans.RepositoryBeanInfo;

public class MavenRepositoriesProvider {
    final Map<String, RepositoryBeanInfo> myRepositoriesMap = new THashMap();

    public static MavenRepositoriesProvider getInstance() {
        return (MavenRepositoriesProvider)ServiceManager.getService(MavenRepositoriesProvider.class);
    }

    public MavenRepositoriesProvider() {
        RepositoriesBean repositoriesBean = (RepositoriesBean)XmlSerializer.deserialize((URL)MavenRepositoriesProvider.class.getResource("repositories.xml"), RepositoriesBean.class);
        RepositoryBeanInfo[] repositories = repositoriesBean.getRepositories();
        assert (repositories != null);
        for (RepositoryBeanInfo repository : repositories) {
            this.registerRepository(repository.getId(), repository);
        }
    }

    public void registerRepository(@NotNull String id, RepositoryBeanInfo info) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoriesProvider", "registerRepository"));
        }
        this.myRepositoriesMap.put(id, info);
    }

    @NotNull
    public Set<String> getRepositoryIds() {
        Set<String> set = this.myRepositoriesMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoriesProvider", "getRepositoryIds"));
        }
        return set;
    }

    @Nullable
    public String getRepositoryName(@Nullable String id) {
        RepositoryBeanInfo pair = this.myRepositoriesMap.get(id);
        return pair != null ? pair.getName() : null;
    }

    @Nullable
    public String getRepositoryUrl(@Nullable String id) {
        RepositoryBeanInfo pair = this.myRepositoriesMap.get(id);
        return pair != null ? pair.getUrl() : null;
    }
}

