/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public class FileFinder {
    public static List<VirtualFile> findPomFiles(VirtualFile[] roots, final boolean lookForNested, final MavenProgressIndicator indicator, final List<VirtualFile> result) throws MavenProcessCanceledException {
        for (VirtualFile f : roots) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)f, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean visitFile(@NotNull VirtualFile f) {
                    if (f == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/idea/maven/utils/FileFinder$1", "visitFile"));
                    }
                    try {
                        indicator.checkCanceled();
                        indicator.setText2(f.getPath());
                        if (f.isDirectory()) {
                            if (!lookForNested) return false;
                            f.refresh(false, false);
                            return true;
                        } else {
                            if (!StringUtil.startsWithIgnoreCase((String)f.getName(), (String)"pom.")) return true;
                            result.add(f);
                        }
                        return true;
                    }
                    catch (InvalidVirtualFileAccessException e) {
                        MavenLog.LOG.info((Throwable)e);
                        return true;
                    }
                    catch (MavenProcessCanceledException e) {
                        throw new VirtualFileVisitor.VisitorException((Throwable)e);
                    }
                }
            }, MavenProcessCanceledException.class);
        }
        return result;
    }
}

