/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.model;

import com.intellij.beanValidation.model.xml.Bean;
import com.intellij.beanValidation.model.xml.ConstraintMappings;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.util.xml.ConvertContext;

public class BvModelUtils {
    public static String getDefaultPackageName(ConvertContext context) {
        PsiPackage aPackage;
        ConstraintMappings mappings = (ConstraintMappings)context.getInvocationElement().getParentOfType(ConstraintMappings.class, true);
        if (mappings != null && (aPackage = (PsiPackage)mappings.getDefaultPackage().getValue()) != null) {
            return aPackage.getQualifiedName();
        }
        return null;
    }

    public static String getQualifiedName(PsiElement element, ConvertContext context, boolean useDefaultPackage) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiQualifiedNamedElement) {
            String packageName;
            String fqn = ((PsiQualifiedNamedElement)element).getQualifiedName();
            if (fqn == null) {
                return null;
            }
            if (useDefaultPackage && (packageName = BvModelUtils.getDefaultPackageName(context)) != null && fqn.startsWith(packageName)) {
                return fqn.substring(packageName.length() + 1);
            }
            return fqn;
        }
        return null;
    }

    public static PsiField getBeanField(String name, ConvertContext context) {
        Bean bean = (Bean)context.getInvocationElement().getParentOfType(Bean.class, true);
        if (bean == null) {
            return null;
        }
        PsiClass psiClass = (PsiClass)bean.getClassAttr().getValue();
        if (psiClass == null) {
            return null;
        }
        return psiClass.findFieldByName(name, false);
    }
}

