/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.SimpleEventRenderer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;

public class EventIconRenderer
implements SimpleEventRenderer {
    private Icon myLightThemeIcon;
    private Icon myDarkThemeIcon;
    private int myIconWidth;

    private static Icon load(String path) {
        return IconLoader.getIcon((String)path, EventIconRenderer.class);
    }

    public EventIconRenderer(String lightTheme, String darkTheme) {
        this.myDarkThemeIcon = EventIconRenderer.load(darkTheme);
        this.myLightThemeIcon = EventIconRenderer.load(lightTheme);
        this.myIconWidth = this.myDarkThemeIcon.getIconWidth();
    }

    @Override
    public void draw(Component parent, Graphics2D g2d, AffineTransform transform, double length) {
        Icon icon = UIUtil.isUnderDarcula() ? this.myDarkThemeIcon : this.myLightThemeIcon;
        AffineTransform originalTransform = g2d.getTransform();
        g2d.setTransform(transform);
        icon.paintIcon(parent, g2d, -this.myIconWidth / 2, 0);
        g2d.setTransform(originalTransform);
    }
}

