/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.LegendRenderData;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineConfig {
    public static final BasicStroke DEFAULT_LINE_STROKE = new BasicStroke(2.0f);
    public static final BasicStroke DEFAULT_DASH_STROKE = new BasicStroke(2.0f, 0, 2, 10.0f, new float[]{8.0f, 5.0f}, 0.0f);
    private static final Color[] COLORS = new Color[]{new JBColor(7057110, 7057110), new JBColor(0xFF0000, 0xFF0000), new JBColor(16616764, 16616764), new JBColor(65442, 65442), new JBColor(4080, 4080), new JBColor(13101504, 13101504), new JBColor(10394312, 10394312), new JBColor(14342891, 14342891), new JBColor(0x969696, 0x969696), new JBColor(0xD9D9D9, 0xD9D9D9)};
    private boolean myIsStepped;
    private boolean myIsFilled;
    private boolean myIsStacked;
    @Nullable
    private LegendRenderData.IconType myLegendIconType;
    @NotNull
    private Stroke myStroke;
    @NotNull
    private Color mColor;

    public LineConfig(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/adtui/chart/linechart/LineConfig", "<init>"));
        }
        this.myIsStepped = false;
        this.myIsFilled = false;
        this.myIsStacked = false;
        this.mColor = color;
        this.myStroke = DEFAULT_LINE_STROKE;
    }

    @NotNull
    public LineConfig setStepped(boolean isStepped) {
        this.myIsStepped = isStepped;
        LineConfig lineConfig = this;
        if (lineConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/chart/linechart/LineConfig", "setStepped"));
        }
        return lineConfig;
    }

    public boolean isStepped() {
        return this.myIsStepped;
    }

    @NotNull
    public LineConfig setFilled(boolean isFilled) {
        this.myIsFilled = isFilled;
        LineConfig lineConfig = this;
        if (lineConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/chart/linechart/LineConfig", "setFilled"));
        }
        return lineConfig;
    }

    public boolean isFilled() {
        return this.myIsFilled;
    }

    @NotNull
    public LineConfig setStacked(boolean isStacked) {
        this.myIsStacked = isStacked;
        LineConfig lineConfig = this;
        if (lineConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/chart/linechart/LineConfig", "setStacked"));
        }
        return lineConfig;
    }

    public boolean isStacked() {
        return this.myIsStacked;
    }

    @NotNull
    public Color getColor() {
        Color color = this.mColor;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/chart/linechart/LineConfig", "getColor"));
        }
        return color;
    }

    @NotNull
    public LineConfig setColor(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/adtui/chart/linechart/LineConfig", "setColor"));
        }
        this.mColor = color;
        LineConfig lineConfig = this;
        if (lineConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/chart/linechart/LineConfig", "setColor"));
        }
        return lineConfig;
    }

    @NotNull
    public LineConfig setStroke(@NotNull Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stroke", "com/android/tools/adtui/chart/linechart/LineConfig", "setStroke"));
        }
        this.myStroke = stroke;
        LineConfig lineConfig = this;
        if (lineConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/chart/linechart/LineConfig", "setStroke"));
        }
        return lineConfig;
    }

    @NotNull
    public Stroke getStroke() {
        Stroke stroke = this.myStroke;
        if (stroke == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/chart/linechart/LineConfig", "getStroke"));
        }
        return stroke;
    }

    public LineConfig setLegendIconType(@Nullable LegendRenderData.IconType legendIconType) {
        this.myLegendIconType = legendIconType;
        return this;
    }

    @Nullable
    public LegendRenderData.IconType getLegendIconType() {
        return this.myLegendIconType;
    }

    @NotNull
    public static Color getColor(int index) {
        Color color = COLORS[index % COLORS.length];
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/chart/linechart/LineConfig", "getColor"));
        }
        return color;
    }
}

