/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import java.util.LinkedList;
import java.util.List;

public class Range {
    protected double myMin;
    protected double myMax;

    public Range(double min, double max) {
        this.myMin = min;
        this.myMax = max;
    }

    public Range() {
        this.clear();
    }

    public void setMin(double min) {
        this.myMin = min;
    }

    public void setMax(double max) {
        this.myMax = max;
    }

    public void set(double min, double max) {
        this.setMin(min);
        this.setMax(max);
    }

    public void set(Range other) {
        this.set(other.getMin(), other.getMax());
    }

    public double getMin() {
        return this.myMin;
    }

    public double getMax() {
        return this.myMax;
    }

    public double getLength() {
        return Math.abs(this.getMax() - this.getMin());
    }

    public boolean isPoint() {
        return this.getMax() == this.getMin();
    }

    public boolean isEmpty() {
        return this.myMin > this.myMax;
    }

    public boolean contains(double value) {
        return this.myMin <= value && value <= this.myMax;
    }

    public void clear() {
        this.myMax = -1.7976931348623157E308;
        this.myMin = Double.MAX_VALUE;
    }

    public double clamp(double value) {
        return Math.min(Math.max(this.getMin(), value), this.getMax());
    }

    public void shift(double delta) {
        this.set(this.getMin() + delta, this.getMax() + delta);
    }

    public List<Range> subtract(Range range) {
        LinkedList<Range> ret = new LinkedList<Range>();
        Range intersection = this.getIntersection(range);
        if (intersection.isEmpty()) {
            ret.add(this);
        } else {
            Range left = new Range(this.myMin, intersection.getMin());
            Range right = new Range(intersection.getMax(), this.myMax);
            if (!left.isPoint()) {
                ret.add(left);
            }
            if (!right.isPoint()) {
                ret.add(right);
            }
        }
        return ret;
    }

    public Range getIntersection(Range range) {
        if (this.isEmpty() || range.isEmpty() || range.getMin() > this.getMax() || range.getMax() < this.getMin()) {
            return new Range();
        }
        return new Range(Math.max(this.getMin(), range.getMin()), Math.min(this.getMax(), range.getMax()));
    }

    public void expand(double min, double max) {
        this.set(Math.min(min, this.myMin), Math.max(max, this.myMax));
    }
}

