/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.FloatingToolWindowManager;
import com.android.tools.adtui.workbench.LayeredPanel;
import com.android.tools.adtui.workbench.Layout;
import com.android.tools.adtui.workbench.MinimizedPanel;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.SideModel;
import com.android.tools.adtui.workbench.SidePanel;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBenchManager;
import com.google.common.base.Splitter;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class WorkBench<T>
extends JBLayeredPane
implements Disposable {
    private final String myName;
    private final PropertiesComponent myPropertiesComponent;
    private final WorkBenchManager myWorkBenchManager;
    private final FloatingToolWindowManager myFloatingToolWindowManager;
    private final FileEditorManager myFileEditorManager;
    private final List<ToolWindowDefinition<T>> myToolDefinitions;
    private final SideModel<T> myModel;
    private final ThreeComponentsSplitter mySplitter;
    private final JPanel myMainPanel;
    private final MinimizedPanel<T> myLeftMinimizePanel;
    private final MinimizedPanel<T> myRightMinimizePanel;
    private final AttachedToolWindow.ButtonDragListener<T> myButtonDragListener;
    private FileEditor myFileEditor;

    public WorkBench(@NotNull Project project, @NotNull String name, FileEditor fileEditor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/adtui/workbench/WorkBench", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/adtui/workbench/WorkBench", "<init>"));
        }
        this(project, name, fileEditor, InitParams.createParams(project));
    }

    public void init(@NotNull JComponent content, @NotNull T context, @NotNull List<ToolWindowDefinition<T>> definitions) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/android/tools/adtui/workbench/WorkBench", "init"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/adtui/workbench/WorkBench", "init"));
        }
        if (definitions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitions", "com/android/tools/adtui/workbench/WorkBench", "init"));
        }
        content.addComponentListener(this.createWidthUpdater());
        this.mySplitter.setInnerComponent(content);
        this.mySplitter.setFirstSize(this.getInitialSideWidth(Side.LEFT));
        this.mySplitter.setLastSize(this.getInitialSideWidth(Side.RIGHT));
        this.myToolDefinitions.addAll(definitions);
        this.myModel.setContext(context);
        this.addToolsToModel();
        this.myWorkBenchManager.register(this);
        this.myFloatingToolWindowManager.register(this.myFileEditor, this);
    }

    public void setToolContext(T context) {
        this.myModel.setContext(context);
    }

    public void setFileEditor(FileEditor fileEditor) {
        this.myFloatingToolWindowManager.unregister(this.myFileEditor);
        this.myFloatingToolWindowManager.register(fileEditor, this);
        this.myFileEditor = fileEditor;
        if (fileEditor != null && this.isCurrentEditor(fileEditor)) {
            this.myFloatingToolWindowManager.updateToolWindowsForWorkBench(this);
        }
    }

    public void dispose() {
        this.myWorkBenchManager.unregister(this);
        this.myFloatingToolWindowManager.unregister(this.myFileEditor);
    }

    WorkBench(@NotNull Project project, @NotNull String name, FileEditor fileEditor, @NotNull InitParams<T> params) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/adtui/workbench/WorkBench", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/adtui/workbench/WorkBench", "<init>"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/android/tools/adtui/workbench/WorkBench", "<init>"));
        }
        this.myName = name;
        this.myFileEditor = fileEditor;
        this.myPropertiesComponent = PropertiesComponent.getInstance();
        this.myWorkBenchManager = WorkBenchManager.getInstance();
        this.myFloatingToolWindowManager = FloatingToolWindowManager.getInstance(project);
        this.myFileEditorManager = FileEditorManager.getInstance((Project)project);
        this.myToolDefinitions = new ArrayList<ToolWindowDefinition<T>>(4);
        this.myModel = ((InitParams)params).myModel;
        this.myModel.addListener(this::modelChanged);
        this.myButtonDragListener = new MyButtonDragListener();
        this.mySplitter = this.initSplitter(((InitParams)params).mySplitter);
        this.myLeftMinimizePanel = ((InitParams)params).myLeftMinimizePanel;
        this.myRightMinimizePanel = ((InitParams)params).myRightMinimizePanel;
        LayeredPanel<T> layeredPanel = new LayeredPanel<T>(this.myName, (JComponent)this.mySplitter, this.myModel);
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add(this.myLeftMinimizePanel, "West");
        this.myMainPanel.add((Component)((Object)layeredPanel), "Center");
        this.myMainPanel.add(this.myRightMinimizePanel, "East");
        this.add(this.myMainPanel, JLayeredPane.DEFAULT_LAYER);
        Disposer.register((Disposable)this, (Disposable)this.mySplitter);
        Disposer.register((Disposable)this, layeredPanel);
    }

    private boolean isCurrentEditor(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/android/tools/adtui/workbench/WorkBench", "isCurrentEditor"));
        }
        for (FileEditor editor : this.myFileEditorManager.getSelectedEditors()) {
            if (fileEditor != editor) continue;
            return true;
        }
        return false;
    }

    public void addNotify() {
        super.addNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this::autoHide);
    }

    public void removeNotify() {
        super.removeNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this::autoHide);
    }

    private void autoHide(@NotNull PropertyChangeEvent event) {
        JComponent newComponent;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/WorkBench", "autoHide"));
        }
        AttachedToolWindow<T> autoToolWindow = this.myModel.getVisibleAutoHideTool();
        if (autoToolWindow == null) {
            return;
        }
        Object newValue = event.getNewValue();
        if (newValue instanceof JComponent && !SwingUtilities.isDescendingFrom(newComponent = (JComponent)newValue, autoToolWindow.getComponent()) && !SwingUtilities.isDescendingFrom(autoToolWindow.getComponent(), newComponent)) {
            autoToolWindow.setPropertyAndUpdate(AttachedToolWindow.PropertyType.MINIMIZED, true);
        }
    }

    @NotNull
    private ThreeComponentsSplitter initSplitter(@NotNull ThreeComponentsSplitter splitter) {
        if (splitter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitter", "com/android/tools/adtui/workbench/WorkBench", "initSplitter"));
        }
        splitter.setDividerWidth(0);
        splitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setFirstComponent(new SidePanel<T>(Side.LEFT, this.myModel));
        splitter.setLastComponent(new SidePanel<T>(Side.RIGHT, this.myModel));
        splitter.setShowDividerControls(true);
        ThreeComponentsSplitter threeComponentsSplitter = splitter;
        if (threeComponentsSplitter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/WorkBench", "initSplitter"));
        }
        return threeComponentsSplitter;
    }

    public void setMinimizePanelsVisible(boolean visible) {
        this.myLeftMinimizePanel.setVisible(visible);
        this.myRightMinimizePanel.setVisible(visible);
    }

    @NotNull
    private String getWidthPropertyName(@NotNull Layout layout, @NotNull Side side) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/adtui/workbench/WorkBench", "getWidthPropertyName"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/WorkBench", "getWidthPropertyName"));
        }
        String string = "ATTACHED_TOOL_WINDOW." + layout.getPrefix() + this.myName + "." + side.name() + ".WIDTH";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/WorkBench", "getWidthPropertyName"));
        }
        return string;
    }

    private int getSideWidth(@NotNull Layout layout, @NotNull Side side) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/adtui/workbench/WorkBench", "getSideWidth"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/WorkBench", "getSideWidth"));
        }
        return this.myPropertiesComponent.getInt(this.getWidthPropertyName(layout, side), -1);
    }

    private void setSideWidth(@NotNull Layout layout, @NotNull Side side, int value) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/adtui/workbench/WorkBench", "setSideWidth"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/WorkBench", "setSideWidth"));
        }
        this.myPropertiesComponent.setValue(this.getWidthPropertyName(layout, side), value, 200);
    }

    private int getInitialSideWidth(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/WorkBench", "getInitialSideWidth"));
        }
        int width = this.getSideWidth(Layout.CURRENT, side);
        if (width != -1) {
            return width;
        }
        Optional<Integer> minimumWidth = this.myToolDefinitions.stream().filter(tool -> {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/WorkBench", "lambda$getInitialSideWidth$0"));
            }
            return tool.getSide() == side;
        }).map(ToolWindowDefinition::getInitialMinimumWidth).max(Comparator.comparing(size -> size));
        width = minimumWidth.orElse(200);
        this.setSideWidth(Layout.DEFAULT, side, width);
        this.setSideWidth(Layout.CURRENT, side, width);
        return width;
    }

    @NotNull
    private ComponentListener createWidthUpdater() {
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                WorkBench.this.updateBothWidths();
            }
        };
        if (componentAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/WorkBench", "createWidthUpdater"));
        }
        return componentAdapter;
    }

    private void updateBothWidths() {
        this.updateWidth(Side.LEFT);
        this.updateWidth(Side.RIGHT);
    }

    private void restoreBothWidths() {
        this.mySplitter.setFirstSize(this.getInitialSideWidth(Side.LEFT));
        this.mySplitter.setLastSize(this.getInitialSideWidth(Side.RIGHT));
    }

    private void updateWidth(@NotNull Side side) {
        int width;
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/android/tools/adtui/workbench/WorkBench", "updateWidth"));
        }
        int n = width = side.isLeft() ? this.mySplitter.getFirstSize() : this.mySplitter.getLastSize();
        if (width != 0 && width != this.getSideWidth(Layout.CURRENT, side)) {
            this.setSideWidth(Layout.CURRENT, side, width);
        }
    }

    @NotNull
    private String getToolOrderPropertyName(@NotNull Layout layout) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/adtui/workbench/WorkBench", "getToolOrderPropertyName"));
        }
        String string = "ATTACHED_TOOL_WINDOW." + layout.getPrefix() + this.myName + ".TOOL_ORDER";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/WorkBench", "getToolOrderPropertyName"));
        }
        return string;
    }

    private void restoreToolOrder(@NotNull List<AttachedToolWindow<T>> tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/android/tools/adtui/workbench/WorkBench", "restoreToolOrder"));
        }
        String orderAsString = this.myPropertiesComponent.getValue(this.getToolOrderPropertyName(Layout.CURRENT));
        if (orderAsString == null) {
            return;
        }
        HashMap<String, Integer> order = new HashMap<String, Integer>(8);
        int number = 1;
        for (String string : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)orderAsString)) {
            order.put(string, number++);
        }
        for (AttachedToolWindow attachedToolWindow : tools) {
            Integer placement = (Integer)order.get(attachedToolWindow.getToolName());
            if (placement == null) {
                placement = number++;
            }
            attachedToolWindow.setToolOrder(placement);
        }
        tools.sort((t1, t2) -> Integer.compare(t1.getToolOrder(), t2.getToolOrder()));
    }

    private void storeToolOrder(@NotNull Layout layout, @NotNull List<AttachedToolWindow<T>> tools) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/adtui/workbench/WorkBench", "storeToolOrder"));
        }
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/android/tools/adtui/workbench/WorkBench", "storeToolOrder"));
        }
        StringBuilder builder = new StringBuilder();
        for (AttachedToolWindow<T> tool : tools) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(tool.getToolName());
        }
        this.myPropertiesComponent.setValue(this.getToolOrderPropertyName(layout), builder.toString());
    }

    private void setDefaultOrderIfMissing(@NotNull List<AttachedToolWindow<T>> tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/android/tools/adtui/workbench/WorkBench", "setDefaultOrderIfMissing"));
        }
        if (!this.myPropertiesComponent.isValueSet(this.getToolOrderPropertyName(Layout.CURRENT))) {
            this.storeToolOrder(Layout.DEFAULT, tools);
            this.storeToolOrder(Layout.CURRENT, tools);
        }
    }

    private void modelChanged(@NotNull SideModel model, @NotNull SideModel.EventType type) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/workbench/WorkBench", "modelChanged"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/adtui/workbench/WorkBench", "modelChanged"));
        }
        switch (type) {
            case SWAP: {
                this.mySplitter.setFirstSize(this.getSideWidth(Layout.CURRENT, Side.RIGHT));
                this.mySplitter.setLastSize(this.getSideWidth(Layout.CURRENT, Side.LEFT));
                this.updateBothWidths();
                this.myWorkBenchManager.updateOtherWorkBenches(this);
                break;
            }
            case UPDATE_FLOATING_WINDOW: {
                this.myWorkBenchManager.updateOtherWorkBenches(this);
                this.myFloatingToolWindowManager.updateToolWindowsForWorkBench(this);
                break;
            }
            case LOCAL_UPDATE: {
                break;
            }
            case UPDATE_TOOL_ORDER: {
                this.storeToolOrder(Layout.CURRENT, this.myModel.getAllTools());
                this.myWorkBenchManager.updateOtherWorkBenches(this);
                break;
            }
            default: {
                this.myWorkBenchManager.updateOtherWorkBenches(this);
            }
        }
    }

    private void addToolsToModel() {
        ArrayList<AttachedToolWindow<T>> tools = new ArrayList<AttachedToolWindow<T>>(this.myToolDefinitions.size());
        for (ToolWindowDefinition<T> definition : this.myToolDefinitions) {
            AttachedToolWindow<T> toolWindow = new AttachedToolWindow<T>(definition, this.myButtonDragListener, this.myName, this.myModel);
            Disposer.register((Disposable)this, toolWindow);
            tools.add(toolWindow);
        }
        this.setDefaultOrderIfMissing(tools);
        this.restoreToolOrder(tools);
        this.myModel.setTools(tools);
    }

    public List<AttachedToolWindow<T>> getFloatingToolWindows() {
        return this.myModel.getFloatingTools();
    }

    public void storeDefaultLayout() {
        String orderAsString = this.myPropertiesComponent.getValue(this.getToolOrderPropertyName(Layout.CURRENT));
        this.myPropertiesComponent.setValue(this.getToolOrderPropertyName(Layout.DEFAULT), orderAsString);
        this.setSideWidth(Layout.DEFAULT, Side.LEFT, this.getSideWidth(Layout.CURRENT, Side.LEFT));
        this.setSideWidth(Layout.DEFAULT, Side.RIGHT, this.getSideWidth(Layout.CURRENT, Side.RIGHT));
        for (AttachedToolWindow<T> tool : this.myModel.getAllTools()) {
            tool.storeDefaultLayout();
        }
    }

    public void restoreDefaultLayout() {
        String orderAsString = this.myPropertiesComponent.getValue(this.getToolOrderPropertyName(Layout.DEFAULT));
        this.myPropertiesComponent.setValue(this.getToolOrderPropertyName(Layout.CURRENT), orderAsString);
        this.setSideWidth(Layout.CURRENT, Side.LEFT, this.getSideWidth(Layout.DEFAULT, Side.LEFT));
        this.setSideWidth(Layout.CURRENT, Side.RIGHT, this.getSideWidth(Layout.DEFAULT, Side.RIGHT));
        for (AttachedToolWindow<T> tool : this.myModel.getAllTools()) {
            tool.restoreDefaultLayout();
        }
        this.updateModel();
    }

    public void updateModel() {
        this.restoreBothWidths();
        this.restoreToolOrder(this.myModel.getAllTools());
        this.myModel.updateLocally();
    }

    public void doLayout() {
        this.myMainPanel.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    static class InitParams<T> {
        private final SideModel<T> myModel;
        private final ThreeComponentsSplitter mySplitter;
        private final MinimizedPanel<T> myLeftMinimizePanel;
        private final MinimizedPanel<T> myRightMinimizePanel;

        InitParams(@NotNull SideModel<T> model, @NotNull ThreeComponentsSplitter splitter, @NotNull MinimizedPanel<T> leftMinimizePanel, @NotNull MinimizedPanel<T> rightMinimizePanel) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/adtui/workbench/WorkBench$InitParams", "<init>"));
            }
            if (splitter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitter", "com/android/tools/adtui/workbench/WorkBench$InitParams", "<init>"));
            }
            if (leftMinimizePanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftMinimizePanel", "com/android/tools/adtui/workbench/WorkBench$InitParams", "<init>"));
            }
            if (rightMinimizePanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightMinimizePanel", "com/android/tools/adtui/workbench/WorkBench$InitParams", "<init>"));
            }
            this.myModel = model;
            this.mySplitter = splitter;
            this.myLeftMinimizePanel = leftMinimizePanel;
            this.myRightMinimizePanel = rightMinimizePanel;
        }

        private static <T> InitParams<T> createParams(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/adtui/workbench/WorkBench$InitParams", "createParams"));
            }
            SideModel model = new SideModel(project);
            return new InitParams(model, new ThreeComponentsSplitter(), new MinimizedPanel(Side.LEFT, model), new MinimizedPanel(Side.RIGHT, model));
        }
    }

    private class MyButtonDragListener
    implements AttachedToolWindow.ButtonDragListener<T> {
        private final int BUTTON_PANEL_WIDTH = JBUI.scale((int)21);
        private boolean myIsDragging;
        private MinimizedPanel<T> myPreviousButtonPanel;

        private MyButtonDragListener() {
        }

        @Override
        public void buttonDragged(@NotNull AttachedToolWindow<T> toolWindow, @NotNull AttachedToolWindow.DragEvent event) {
            if (toolWindow == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/android/tools/adtui/workbench/WorkBench$MyButtonDragListener", "buttonDragged"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/WorkBench$MyButtonDragListener", "buttonDragged"));
            }
            if (!this.myIsDragging) {
                this.startDragging(event);
            }
            this.moveDragImage(toolWindow, event);
            this.notifyButtonPanel(toolWindow, event, false);
        }

        @Override
        public void buttonDropped(@NotNull AttachedToolWindow<T> toolWindow, @NotNull AttachedToolWindow.DragEvent event) {
            if (toolWindow == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/android/tools/adtui/workbench/WorkBench$MyButtonDragListener", "buttonDropped"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/WorkBench$MyButtonDragListener", "buttonDropped"));
            }
            if (this.myIsDragging) {
                this.notifyButtonPanel(toolWindow, event, true);
                this.stopDragging(toolWindow, event);
            }
        }

        private void startDragging(@NotNull AttachedToolWindow.DragEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/WorkBench$MyButtonDragListener", "startDragging"));
            }
            WorkBench.this.add(event.getDragImage(), JLayeredPane.DRAG_LAYER);
            this.myIsDragging = true;
        }

        private void stopDragging(@NotNull AttachedToolWindow<T> tool, @NotNull AttachedToolWindow.DragEvent event) {
            if (tool == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/WorkBench$MyButtonDragListener", "stopDragging"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/WorkBench$MyButtonDragListener", "stopDragging"));
            }
            AbstractButton button = tool.getMinimizedButton();
            button.setVisible(true);
            WorkBench.this.remove(event.getDragImage());
            WorkBench.this.revalidate();
            WorkBench.this.repaint();
            this.myPreviousButtonPanel = null;
            this.myIsDragging = false;
        }

        private void moveDragImage(@NotNull AttachedToolWindow<T> tool, @NotNull AttachedToolWindow.DragEvent event) {
            if (tool == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/WorkBench$MyButtonDragListener", "moveDragImage"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/WorkBench$MyButtonDragListener", "moveDragImage"));
            }
            AbstractButton button = tool.getMinimizedButton();
            Point position = SwingUtilities.convertPoint(button, event.getMousePoint(), (Component)((Object)WorkBench.this));
            Dimension buttonSize = button.getPreferredSize();
            Point dragPosition = event.getDragPoint();
            position.x = this.translate(position.x, dragPosition.x, 0, WorkBench.this.getWidth() - buttonSize.width);
            position.y = this.translate(position.y, dragPosition.y, 0, WorkBench.this.getHeight() - buttonSize.height);
            Component dragImage = event.getDragImage();
            Dimension size = dragImage.getPreferredSize();
            dragImage.setBounds(position.x, position.y, size.width, size.height);
            dragImage.revalidate();
            dragImage.repaint();
        }

        private void notifyButtonPanel(@NotNull AttachedToolWindow<T> tool, @NotNull AttachedToolWindow.DragEvent event, boolean doDrop) {
            if (tool == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/WorkBench$MyButtonDragListener", "notifyButtonPanel"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/WorkBench$MyButtonDragListener", "notifyButtonPanel"));
            }
            AbstractButton button = tool.getMinimizedButton();
            Point position = SwingUtilities.convertPoint(button, event.getMousePoint(), (Component)((Object)WorkBench.this));
            int yMidOfButton = position.y - event.getDragPoint().y + button.getHeight() / 2;
            if (position.x < this.BUTTON_PANEL_WIDTH) {
                this.notifyButtonPanel(tool, yMidOfButton, WorkBench.this.myLeftMinimizePanel, doDrop);
            } else if (position.x > WorkBench.this.getWidth() - this.BUTTON_PANEL_WIDTH) {
                this.notifyButtonPanel(tool, yMidOfButton, WorkBench.this.myRightMinimizePanel, doDrop);
            } else if (this.myPreviousButtonPanel != null) {
                this.myPreviousButtonPanel.dragExit(tool);
                this.myPreviousButtonPanel = null;
            }
        }

        private void notifyButtonPanel(@NotNull AttachedToolWindow<T> tool, int y, @NotNull MinimizedPanel<T> buttonPanel, boolean doDrop) {
            if (tool == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/android/tools/adtui/workbench/WorkBench$MyButtonDragListener", "notifyButtonPanel"));
            }
            if (buttonPanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buttonPanel", "com/android/tools/adtui/workbench/WorkBench$MyButtonDragListener", "notifyButtonPanel"));
            }
            if (this.myPreviousButtonPanel != null && this.myPreviousButtonPanel != buttonPanel) {
                this.myPreviousButtonPanel.dragExit(tool);
            }
            this.myPreviousButtonPanel = buttonPanel;
            if (doDrop) {
                buttonPanel.dragDrop(tool, y);
            } else {
                buttonPanel.drag(tool, y);
            }
        }

        private int translate(int pos, int offset, int min, int max) {
            return Math.min(Math.max(pos - offset, min), max);
        }
    }
}

