/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbImplMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class EjbSuperMethodSearcher
implements QueryExecutor<MethodSignatureBackedByPsiMethod, SuperMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull SuperMethodsSearch.SearchParameters queryParameters, @NotNull Processor<MethodSignatureBackedByPsiMethod> consumer) {
        EjbMethodRole[] roles;
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/javaee/EjbSuperMethodSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javaee/EjbSuperMethodSearcher", "execute"));
        }
        PsiMethod derivedMethod = queryParameters.getMethod();
        if (DumbService.getInstance((Project)derivedMethod.getProject()).isDumb()) {
            return true;
        }
        PsiClass containingClass = derivedMethod.getContainingClass();
        if (!EjbUtil.isTopLevelClass(containingClass, EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS, OldEjbRolesUtil.getEjbRoles(containingClass))) {
            return true;
        }
        for (EjbMethodRole role : roles = OldEjbRolesUtil.getEjbRoles(derivedMethod)) {
            PsiMethod[] psiMethods;
            if (!(role instanceof EjbImplMethodRole)) continue;
            for (PsiMethod psiMethod : psiMethods = ((EjbImplMethodRole)role).findAllDeclarations()) {
                if (psiMethod.equals(derivedMethod) || consumer.process((Object)MethodSignatureBackedByPsiMethod.create((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY))) continue;
                return false;
            }
        }
        return true;
    }
}

