/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelRefactoringSupport;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ModelMergerUtil;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class JavaeeFieldRefactoringSupport<T extends CommonModelElement>
extends CommonModelRefactoringSupport<T, PsiMember> {
    private final Class<T> myFieldClass;

    public JavaeeFieldRefactoringSupport(Class<T> fieldClass) {
        super(PsiMember.class);
        this.myFieldClass = fieldClass;
    }

    protected FindUsagesHandler createFindUsagesHandler(@NotNull T field, @NotNull PsiElement originalElement) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/javaee/JavaeeFieldRefactoringSupport", "createFindUsagesHandler"));
        }
        if (originalElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElement", "com/intellij/javaee/JavaeeFieldRefactoringSupport", "createFindUsagesHandler"));
        }
        PsiElement psiElement = (PsiElement)ObjectUtils.assertNotNull((Object)field.getIdentifyingPsiElement());
        return new FindUsagesHandler(psiElement, (CommonModelElement)field, originalElement){
            final /* synthetic */ CommonModelElement val$field;
            final /* synthetic */ PsiElement val$originalElement;
            {
                this.val$field = commonModelElement;
                this.val$originalElement = psiElement;
                super(arg0);
            }

            @NotNull
            public PsiElement[] getSecondaryElements() {
                PsiElement[] psiElementArray;
                boolean b = JavaeeFieldRefactoringSupport.this.askUserIfAccessorsShouldBeTakenIntoAccount(this.val$field, this.val$originalElement);
                if (b) {
                    psiElementArray = PsiUtilCore.toPsiElementArray((Collection)JavaeeFieldRefactoringSupport.this.getAccessors(this.val$field));
                } else {
                    PsiElement[] psiElementArray2 = new PsiElement[1];
                    psiElementArray = psiElementArray2;
                    psiElementArray2[0] = this.val$originalElement;
                }
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/JavaeeFieldRefactoringSupport$1", "getSecondaryElements"));
                }
                return psiElementArray;
            }
        };
    }

    public T getModelElementFromMetaData(PsiElement psiElement) {
        if (psiElement instanceof XmlTag) {
            XmlTag tag = (XmlTag)psiElement;
            DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            return (T)((CommonModelElement)ObjectUtils.tryCast((Object)domElement, this.myFieldClass));
        }
        if (psiElement instanceof PsiMember) {
            PsiMember member = (PsiMember)psiElement;
            if (!this.acceptPsiMember(member)) {
                return null;
            }
            for (PersistentAttribute attribute : PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceAttributes(member)) {
                if (!this.myFieldClass.isInstance(attribute)) continue;
                return (T)((CommonModelElement)this.myFieldClass.cast(attribute));
            }
            return null;
        }
        Object modelObject = JamCommonUtil.getModelObject((PsiElement)psiElement);
        return (T)((CommonModelElement)ObjectUtils.tryCast((Object)modelObject, this.myFieldClass));
    }

    protected boolean acceptPsiMember(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/javaee/JavaeeFieldRefactoringSupport", "acceptPsiMember"));
        }
        return true;
    }

    boolean askUserIfAccessorsShouldBeTakenIntoAccount(@NotNull T field, @NotNull PsiElement originalElement) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/javaee/JavaeeFieldRefactoringSupport", "askUserIfAccessorsShouldBeTakenIntoAccount"));
        }
        if (originalElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElement", "com/intellij/javaee/JavaeeFieldRefactoringSupport", "askUserIfAccessorsShouldBeTakenIntoAccount"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        boolean isModelNavigationElement = !ModelMergerUtil.createFilteringProcessor(o -> {
            if (originalElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElement", "com/intellij/javaee/JavaeeFieldRefactoringSupport", "lambda$askUserIfAccessorsShouldBeTakenIntoAccount$0"));
            }
            return o.getNavigationElement() != originalElement;
        }).process((Object)field.getIdentifyingPsiElement());
        String name = ElementPresentationManager.getTypeNameForObject(field) + " " + ElementPresentationManager.getElementName(field);
        if (originalElement instanceof PsiField) {
            return Messages.showYesNoDialog((String)("Do you want to search for all accessors of " + name + "?"), (String)FindBundle.message((String)"find.field.accessors.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
        }
        if (originalElement instanceof PsiMethod && !isModelNavigationElement && PropertyUtil.isSimplePropertyAccessor((PsiMethod)((PsiMethod)originalElement))) {
            return Messages.showYesNoDialog((String)("Do you want to search for all accessors of " + name + "?"), (String)FindBundle.message((String)"find.field.accessors.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
        }
        return true;
    }
}

