/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.components;

import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FilteredFileSetScope
extends FileSetCompileScope {
    private final Set<FileType> myFileTypes;

    public FilteredFileSetScope(FileType[] acceptableFileTypes, Collection<VirtualFile> roots, Module[] modules) {
        super(roots, modules);
        this.myFileTypes = new THashSet(Arrays.asList(acceptableFileTypes));
    }

    @NotNull
    public VirtualFile[] getFiles(FileType fileType, boolean inSourceOnly) {
        if (fileType != null && !this.myFileTypes.contains(fileType)) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/components/FilteredFileSetScope", "getFiles"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] files = super.getFiles(fileType, inSourceOnly);
        ArrayList<VirtualFile> accepted = new ArrayList<VirtualFile>(files.length);
        for (VirtualFile file : files) {
            if (!this.myFileTypes.contains(file.getFileType())) continue;
            accepted.add(file);
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray(accepted);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/components/FilteredFileSetScope", "getFiles"));
        }
        return virtualFileArray;
    }
}

