/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.moduleLevel;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.VerificationException;
import com.intellij.javaee.ejb.EjbRelationUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.enums.CmrFieldType;
import com.intellij.javaee.model.enums.Multiplicity;
import com.intellij.javaee.model.enums.PersistenceType;
import com.intellij.javaee.model.xml.ejb.CmrField;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.ejb.EjbRelationshipRole;
import com.intellij.javaee.module.view.ejb.moduleLevel.RelationshipEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.ui.GuiUtils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ui.BaseControl;
import com.intellij.util.xml.ui.ComboControl;
import com.intellij.util.xml.ui.CommitAdapter;
import com.intellij.util.xml.ui.CommitListener;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.CompositeCommittable;
import com.intellij.util.xml.ui.DomUIControl;
import com.intellij.util.xml.ui.DomUIFactory;
import com.intellij.util.xml.ui.TextPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public abstract class RelationshipRolePanel
extends CompositeCommittable
implements CommittablePanel {
    private JComboBox myEjb;
    private JComboBox myMultiplicity;
    private JCheckBox myCascadeDelete;
    private TextPanel myRoleName;
    private TextPanel myCMRName;
    private JComboBox myCMRType;
    private JCheckBox mySetter;
    private JCheckBox myGetter;
    private JCheckBox myEnableCMR;
    private JLabel myFieldNameLabel;
    private JLabel myFieldTypeLabel;
    private JPanel myAccessorsPanel;
    private JPanel myPanel;
    private final Committable myParent;
    private final EjbJar myRoot;
    private final EjbRelationshipRole myRole;
    private final EjbRelationshipRole myOtherRole;
    private final ActionListener myEnableCmrListener;

    public RelationshipRolePanel(EjbRelationshipRole role, EjbRelationshipRole otherRole, final Committable parent, EjbJar root) {
        this.$$$setupUI$$$();
        this.myEnableCmrListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CmrField cmrField = RelationshipRolePanel.this.myRole.getCmrField();
                if (!RelationshipRolePanel.this.myEnableCMR.isEnabled()) {
                    RelationshipRolePanel.this.myEnableCMR.setSelected(false);
                }
                if (!RelationshipRolePanel.this.myEnableCMR.isSelected()) {
                    cmrField.undefine();
                } else {
                    cmrField.ensureTagExists();
                    cmrField.getCmrFieldName().setValue((Object)RelationshipEditor.suggestCmrName(RelationshipRolePanel.this.myRole, RelationshipRolePanel.this.getSelectedEjbName(), RelationshipRolePanel.this.getOtherEjbName(), (String)RelationshipRolePanel.this.myOtherRole.getCmrField().getCmrFieldName().getValue()));
                    if (RelationshipRolePanel.this.myOtherRole.getMultiplicity().getValue() == Multiplicity.MANY) {
                        cmrField.getCmrFieldType().setValue((Object)CmrFieldType.JAVA_UTIL_COLLECTION);
                    }
                }
                RelationshipRolePanel.this.myParent.reset();
            }
        };
        this.myRole = role;
        this.myOtherRole = otherRole;
        this.myParent = parent;
        this.myRoot = root;
        this.addComponent(this.myMultiplicity, role.getMultiplicity(), new CommitAdapter(){

            public void afterCommit(DomUIControl control) {
                RelationshipRolePanel.this.updateCascadeDelete();
                CmrField cmrField = RelationshipRolePanel.this.myOtherRole.getCmrField();
                if (cmrField.getXmlTag() != null) {
                    cmrField.getCmrFieldType().setValue((Object)(RelationshipRolePanel.this.isOne() ? null : CmrFieldType.JAVA_UTIL_COLLECTION));
                }
                parent.reset();
            }
        });
        this.addComponent(this.myCascadeDelete, role.getCascadeDelete(), new CommitAdapter(){

            public void afterCommit(DomUIControl control) {
                RelationshipRolePanel.this.updateCascadeDelete();
                parent.reset();
            }
        });
        ((BaseControl)this.addComponent((Committable)DomUIFactory.createTextControl((GenericDomValue)role.getEjbRelationshipRoleName(), (boolean)true))).bind((JComponent)this.myRoleName);
        ((BaseControl)this.addComponent((Committable)DomUIFactory.createTextControl((GenericDomValue)role.getCmrField().getCmrFieldName(), (boolean)true))).bind((JComponent)this.myCMRName);
        ((DomUIControl)this.addComponent((Committable)DomUIFactory.createControl((GenericDomValue)role.getCmrField().getCmrFieldType()))).bind((JComponent)this.myCMRType);
        ComboControl comboControl = new ComboControl(this.myRole.getRelationshipRoleSource().getEntityBean(), () -> {
            List list = this.myRoot.getEnterpriseBeans().getEntities();
            return ContainerUtil.mapNotNull((Collection)list, s -> s.getPersistenceType().getValue() != PersistenceType.CONTAINER ? null : Pair.create((Object)ElementPresentationManager.getElementName((Object)s), (Object)ElementPresentationManager.getIcon((Object)s)));
        });
        this.addComponent((Committable)comboControl);
        comboControl.bind((JComponent)this.myEjb);
        comboControl.addCommitListener(new CommitListener(){
            private String myOldEjbName;
            private boolean myCustomOtherFieldName;

            public void beforeCommit(DomUIControl control) {
                String ejbName;
                String name = (String)RelationshipRolePanel.this.myRole.getCmrField().getCmrFieldName().getValue();
                this.myOldEjbName = ejbName = RelationshipRolePanel.this.getSelectedEjbName();
                CmrField cmrField = RelationshipRolePanel.this.myOtherRole.getCmrField();
                if (cmrField.getXmlTag() == null) {
                    this.myCustomOtherFieldName = true;
                    return;
                }
                String suggestedOtherName = RelationshipEditor.suggestCmrName(RelationshipRolePanel.this.myOtherRole, RelationshipRolePanel.this.getOtherEjbName(), ejbName, name);
                String otherName = (String)cmrField.getCmrFieldName().getValue();
                this.myCustomOtherFieldName = StringUtil.isEmpty((String)otherName) || !Comparing.equal((String)otherName, (String)suggestedOtherName);
            }

            public void afterCommit(DomUIControl control) {
                if (!this.myCustomOtherFieldName) {
                    RelationshipRolePanel.this.myOtherRole.getCmrField().getCmrFieldName().setValue((Object)RelationshipEditor.suggestCmrName(RelationshipRolePanel.this.myOtherRole, RelationshipRolePanel.this.getOtherEjbName(), RelationshipRolePanel.this.getSelectedEjbName(), (String)RelationshipRolePanel.this.myRole.getCmrField().getCmrFieldName().getValue()));
                }
                RelationshipRolePanel.this.ejbNameChanged(this.myOldEjbName, RelationshipRolePanel.this.getSelectedEjbName());
            }
        });
        this.myGetter.setSelected(!EjbRelationUtil.getGetters((com.intellij.javaee.model.common.ejb.CmrField)this.myRole.getCmrField()).isEmpty());
        this.mySetter.setSelected(!EjbRelationUtil.getSetters((com.intellij.javaee.model.common.ejb.CmrField)this.myRole.getCmrField()).isEmpty());
    }

    private void updateCascadeDelete() {
        this.myOtherRole.getCascadeDelete().setValue((Object)(this.myRole.getCmrField().getXmlTag() != null && this.myOtherRole.getCmrField().getXmlTag() != null && this.isOne() ? 1 : 0));
    }

    private boolean isOne() {
        return this.myRole.getMultiplicity().getValue() == Multiplicity.ONE;
    }

    protected abstract void ejbNameChanged(String var1, String var2);

    private void addComponent(JComponent component, GenericDomValue bindTo, CommitAdapter listener) {
        DomUIControl control = (DomUIControl)this.addComponent((Committable)DomUIFactory.createControl((GenericDomValue)bindTo));
        control.bind(component);
        control.addCommitListener((CommitListener)listener);
    }

    private Project getProject() {
        return this.myRole.getManager().getProject();
    }

    public void reset() {
        this.myEnableCMR.removeActionListener(this.myEnableCmrListener);
        Multiplicity otherMultiplicity = (Multiplicity)this.myOtherRole.getMultiplicity().getValue();
        this.myCascadeDelete.setEnabled(otherMultiplicity == Multiplicity.ONE);
        EntityBean entityBean = this.myOtherRole.getCmrField().getEntityBean();
        boolean enableCmr = entityBean != null && entityBean.getLocal().getValue() != null;
        this.myEnableCMR.setEnabled(enableCmr);
        boolean hasCmr = enableCmr && this.myRole.getCmrField().getXmlTag() != null;
        this.myEnableCMR.setSelected(hasCmr);
        GuiUtils.enableChildren((boolean)hasCmr, (Component[])new Component[]{this.myAccessorsPanel, this.myFieldNameLabel, this.myFieldTypeLabel, this.myCMRName, this.myCMRType});
        GuiUtils.enableChildren((hasCmr && otherMultiplicity == Multiplicity.MANY ? 1 : 0) != 0, (Component[])new Component[]{this.myCMRType, this.myFieldTypeLabel});
        GuiUtils.enableChildren((hasCmr && this.getSelectedEjb() != null ? 1 : 0) != 0, (Component[])new Component[]{this.myGetter, this.mySetter});
        this.myEnableCMR.addActionListener(this.myEnableCmrListener);
        super.reset();
    }

    public final void enableCmrType(boolean enable) {
        GuiUtils.enableChildren((boolean)enable, (Component[])new Component[]{this.myCMRType, this.myFieldTypeLabel});
    }

    public final JComponent getComponent() {
        return this.myPanel;
    }

    public final JComboBox getMultiplicity() {
        return this.myMultiplicity;
    }

    public final JCheckBox getEnableCMR() {
        return this.myEnableCMR;
    }

    public final JComboBox getCMRType() {
        return this.myCMRType;
    }

    public final JCheckBox getCascadeDelete() {
        return this.myCascadeDelete;
    }

    public final EnterpriseBean getSelectedEjb() {
        return (EnterpriseBean)this.myRole.getRelationshipRoleSource().getEntityBean().getValue();
    }

    public final String getSelectedEjbName() {
        return this.myRole.getRelationshipRoleSource().getEntityBean().getStringValue();
    }

    public final String getOtherEjbName() {
        return this.myOtherRole.getRelationshipRoleSource().getEntityBean().getStringValue();
    }

    public void checkIsValid() throws VerificationException {
        CmrField cmrField = this.myRole.getCmrField();
        if (cmrField.getEntityBean() == null) {
            throw new VerificationException(J2EEBundle.message((String)"message.text.entity.bean.not.specified.for.cmr.field", (Object[])new Object[0]));
        }
        if (cmrField.getCmrFieldName().getXmlTag() != null) {
            String name = (String)cmrField.getCmrFieldName().getValue();
            if (StringUtil.isEmpty((String)name) || !PsiNameHelper.getInstance((Project)this.getProject()).isIdentifier(name)) {
                throw new VerificationException(J2EEBundle.message((String)"message.text.name.is.not.valid.identifier", (Object[])new Object[]{name}));
            }
            if (!Character.isLowerCase(name.charAt(0))) {
                throw new VerificationException(J2EEBundle.message((String)"message.text.cmr.field.name.should.begin.with.a.lower.case.letter", (Object[])new Object[0]));
            }
        }
    }

    public final boolean isGetter() {
        return this.myGetter.isEnabled() && this.myGetter.isSelected();
    }

    public final boolean isSetter() {
        return this.mySetter.isEnabled() && this.mySetter.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JComboBox jComboBox;
        JLabel jLabel;
        TextPanel textPanel;
        JLabel jLabel2;
        JCheckBox jCheckBox3;
        TextPanel textPanel2;
        JCheckBox jCheckBox4;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(3, 5, 5, 5), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.edit.relationship.ejb"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.edit.relationship.multiplicity"));
        jPanel2.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEjb = jComboBox3 = new JComboBox();
        jPanel2.add(jComboBox3, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        this.myMultiplicity = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myCascadeDelete = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/J2EEBundle").getString("checkbox.edit.relationship.cascade.delete"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.edit.relationship.role.name"));
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRoleName = textPanel2 = new TextPanel();
        jPanel2.add((Component)textPanel2, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 0, null, null, null));
        this.myEnableCMR = jCheckBox3 = new JCheckBox();
        jCheckBox3.setIconTextGap(4);
        jCheckBox3.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/J2EEBundle").getString("checkbox.edit.relationship.enable.cmr.field"));
        jCheckBox3.setLabel(ResourceBundle.getBundle("messages/J2EEBundle").getString("checkbox.edit.relationship.enable.cmr.field"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel3.add((Component)jSeparator, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myFieldNameLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.edit.relationship.field.name"));
        jPanel2.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCMRName = textPanel = new TextPanel();
        jPanel2.add((Component)textPanel, new GridConstraints(4, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFieldTypeLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.edit.relationship.field.type"));
        jPanel2.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCMRType = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(5, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        this.myAccessorsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 0, null, null, null));
        this.mySetter = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/J2EEBundle").getString("checkbox.edit.relationship.setter"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGetter = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/J2EEBundle").getString("checkbox.edit.relationship.getter"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel3.setLabelFor(jComboBox3);
        jLabel4.setLabelFor(jComboBox2);
        jLabel5.setLabelFor((Component)textPanel2);
        jLabel2.setLabelFor((Component)textPanel);
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

