/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.web.editor;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.icons.AllIcons;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.module.components.FrameworkElementAsVirtualFileImpl;
import com.intellij.javaee.module.components.FrameworkVirtualFileSystem;
import com.intellij.javaee.module.view.web.editor.ServletAsVirtualFile;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServletAsVirtualFileImpl
extends FrameworkElementAsVirtualFileImpl<WebFacet>
implements ServletAsVirtualFile {
    @NonNls
    public static final String SERVLET_TYPE = "Servlet";

    ServletAsVirtualFileImpl(FacetPointer<WebFacet> facetPointer, String elementName) {
        super(facetPointer, SERVLET_TYPE, elementName);
    }

    @Nullable
    public Servlet findElement(Project project) {
        WebFacet facet = (WebFacet)this.findFacet();
        return facet == null ? null : WebUtil.findServlet((WebFacet)facet, (String)this.getElementName());
    }

    @Override
    public String getPresentableName() {
        return J2EEBundle.message((String)"servlet.string.representation", (Object[])new Object[]{this.getElementName()});
    }

    @Nullable
    public static ServletAsVirtualFileImpl findFile(@NotNull CommonServlet servlet) {
        if (servlet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servlet", "com/intellij/javaee/module/view/web/editor/ServletAsVirtualFileImpl", "findFile"));
        }
        WebFacet webFacet = WebUtil.getWebFacet((JavaeeModelElement)servlet);
        if (webFacet == null) {
            return null;
        }
        String servletName = (String)servlet.getServletName().getValue();
        String path = ServletAsVirtualFileImpl.getPath((Facet)webFacet, SERVLET_TYPE, servletName);
        return (ServletAsVirtualFileImpl)FrameworkVirtualFileSystem.getJ2EEInstance().findFileByPath(path);
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Nodes.Servlet;
    }
}

