/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentDataEditor;
import com.intellij.javaee.oss.server.JavaeePersistentDataWithBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class JavaeePersistentDataWithBaseEditor<T extends JavaeePersistentDataWithBase>
extends JavaeePersistentDataEditor<T> {
    private static final Logger LOG = Logger.getInstance(JavaeePersistentDataWithBaseEditor.class);
    private JPanel myMainPanel;
    private JBLabel myBaseDirLabel;
    private TextFieldWithBrowseButton myBaseDirField;
    private JBLabel myBaseErrorLabel;
    private JPanel myBaseCustomPanelPlaceHolder;
    private boolean myIsSyncing = false;
    private boolean myShouldSyncBase;

    public JavaeePersistentDataWithBaseEditor(JavaeeIntegration integration) {
        super(integration);
        this.$$$setupUI$$$();
        String serverName = this.getServerName();
        this.myBaseDirLabel.setText(JavaeeBundle.getText("JavaeePersistentDataEditor.base.directory.label", serverName));
        this.myBaseDirField.addBrowseFolderListener(JavaeeBundle.getText("JavaeePersistentDataEditor.chooser.title.base.directory", serverName), JavaeeBundle.getText("JavaeePersistentDataEditor.chooser.description.base.directory", serverName), null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myBaseDirField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                JavaeePersistentDataWithBaseEditor.this.onBaseChanged();
            }
        });
        this.myBaseErrorLabel.setIcon(AllIcons.RunConfigurations.ConfigurationWarning);
        super.getCustomPanelPlaceHolder().add(this.myMainPanel);
    }

    protected void onBaseChanged() {
        if (!this.myIsSyncing) {
            this.myShouldSyncBase = false;
        }
        this.validateBaseDir();
    }

    private void syncBaseDirField() {
        this.myIsSyncing = true;
        try {
            this.myBaseDirField.setText(this.getHome());
        }
        finally {
            this.myIsSyncing = false;
        }
    }

    protected boolean isBaseDirSupported() {
        return true;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    @Override
    protected JPanel getCustomPanelPlaceHolder() {
        return this.myBaseCustomPanelPlaceHolder;
    }

    @Override
    protected void resetEditorFrom(@NotNull T settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javaee/oss/server/JavaeePersistentDataWithBaseEditor", "resetEditorFrom"));
        }
        String baseDir = ((JavaeePersistentDataWithBase)((Object)settings)).BASE;
        this.myShouldSyncBase = StringUtil.isEmpty((String)baseDir);
        if (!this.myShouldSyncBase) {
            this.myBaseDirField.setText(baseDir);
        }
        super.resetEditorFrom(settings);
    }

    @Override
    protected void applyEditorTo(@NotNull T settings) {
        String baseDir;
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javaee/oss/server/JavaeePersistentDataWithBaseEditor", "applyEditorTo"));
        }
        super.applyEditorTo(settings);
        ((JavaeePersistentDataWithBase)((Object)settings)).BASE = this.isBaseDirSupported() ? ((baseDir = this.getWorkDir()).equals(this.getHome()) ? "" : baseDir) : "";
    }

    @Override
    protected void onHomeChanged() {
        this.configureBaseDirPanel();
    }

    protected String getWorkDir() {
        String base = this.getInputBase();
        return StringUtil.isEmpty((String)base) || !this.isBaseDirSupported() ? this.getHome() : base;
    }

    protected String getInputBase() {
        return this.myBaseDirField.getTextField().getText();
    }

    protected void configureBaseDirPanel() {
        boolean baseDirSupported = this.isBaseDirSupported();
        this.myBaseErrorLabel.setVisible(baseDirSupported);
        this.myBaseDirField.setVisible(baseDirSupported);
        this.myBaseDirLabel.setVisible(baseDirSupported);
        if (baseDirSupported) {
            if (this.myShouldSyncBase) {
                this.syncBaseDirField();
            }
            this.validateBaseDir();
        }
    }

    private void validateBaseDir() {
        String baseDir = this.getInputBase();
        String errorText = "";
        if (StringUtil.isEmptyOrSpaces((String)baseDir)) {
            errorText = JavaeeBundle.getText("JavaeePersistentDataEditor.error.message.base.directory.path.should.not.be.empty", this.getServerName());
        }
        if (StringUtil.isEmpty((String)errorText)) {
            try {
                this.doValidateBaseDir(baseDir);
            }
            catch (Exception e) {
                errorText = e.getMessage();
                if (StringUtil.isEmpty((String)errorText)) {
                    errorText = e.getClass().getName();
                }
                LOG.debug((Throwable)e);
            }
        }
        this.myBaseErrorLabel.setVisible(!StringUtil.isEmpty((String)errorText));
        this.myBaseErrorLabel.setText(errorText);
    }

    protected void doValidateBaseDir(String baseDir) throws Exception {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myBaseDirField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myBaseDirLabel = jBLabel2 = new JBLabel();
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myBaseErrorLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myBaseCustomPanelPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

