/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.RunManager;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.jam.JamMessages;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaQueryReferenceProvider;
import com.intellij.jpa.engine.JpaConsole;
import com.intellij.jpa.engine.JpaConsoleBase;
import com.intellij.jpa.engine.JpaEngine;
import com.intellij.jpa.engine.QlScriptModel;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaConsoleProvider
extends PersistenceConsoleProvider {
    public static boolean canOpenConsoleInSeparatedProcess(PersistencePackage unit) {
        return unit.getModelHelper().getAdditionalMapping() == null;
    }

    public boolean hasRunners(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/jpa/JpaConsoleProvider", "hasRunners"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(dataContext);
        return project != null && facet != null && unit instanceof PersistenceUnit && unit.isValid() && JpaConsoleProvider.canOpenConsoleInSeparatedProcess(unit) && facet.getQlLanguage() != null && JpaEngine.isAvailable(facet.getModule());
    }

    public boolean hasRunners(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/JpaConsoleProvider", "hasRunners"));
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof QlFile || JamCommonUtil.isPlainJavaFile((PsiElement)file) || JamCommonUtil.isPlainXmlFile((PsiElement)file))) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null || !JpaEngine.isAvailable(module)) {
            return false;
        }
        return JpaConsoleProvider.findQlFile(file, element) != null;
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull DataContext dataContext) {
        boolean enable;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/jpa/JpaConsoleProvider", "getRunners"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(dataContext);
        boolean bl = enable = project != null && facet instanceof JpaFacet && unit != null && unit.isValid() && JpaConsoleProvider.canOpenConsoleInSeparatedProcess(unit) && facet.getQlLanguage() != null && JpaEngine.isAvailable(facet.getModule());
        if (!enable) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaConsoleProvider", "getRunners"));
            }
            return list;
        }
        PersistencePackageAsVirtualFileImpl unitFile = PersistencePackageAsVirtualFileImpl.findFile(unit, facet);
        if (unitFile == null) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaConsoleProvider", "getRunners"));
            }
            return list;
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        result.add(new MyRunner(project, unitFile));
        JpaConsoleProvider.addDefaultRunners(result, project, unitFile, null);
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaConsoleProvider", "getRunners"));
        }
        return arrayList;
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull PsiElement element, Editor editor) {
        QlScriptModel model;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/JpaConsoleProvider", "getRunners"));
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof QlFile || JamCommonUtil.isPlainJavaFile((PsiElement)file) || JamCommonUtil.isPlainXmlFile((PsiElement)file))) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaConsoleProvider", "getRunners"));
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null || !JpaEngine.isAvailable(module)) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaConsoleProvider", "getRunners"));
            }
            return list;
        }
        ArrayList<PersistencePackagePointer> unitFiles = new ArrayList<PersistencePackagePointer>();
        for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module)) {
            if (facet.getQlLanguage() == null) continue;
            for (PersistencePackage unit : facet.getPersistenceUnits()) {
                if (!(unit instanceof PersistenceUnit) || !JpaConsoleProvider.canOpenConsoleInSeparatedProcess(unit)) continue;
                ContainerUtil.addIfNotNull(unitFiles, (Object)((Object)PersistencePackageAsVirtualFileImpl.findFile(unit, facet)));
            }
        }
        if (unitFiles.isEmpty()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaConsoleProvider", "getRunners"));
            }
            return list;
        }
        QlFile qlFile = JpaConsoleProvider.findQlFile(file, element);
        QlScriptModel qlScriptModel = model = qlFile == null ? null : JpaConsoleProvider.createScriptModel(file, qlFile);
        if (model == null || model.statements().isEmpty()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaConsoleProvider", "getRunners"));
            }
            return list;
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        result.add(new MyQueryRunner(module.getProject(), unitFiles, model));
        for (PersistencePackagePointer unit : unitFiles) {
            JpaConsoleProvider.addDefaultRunners(result, module.getProject(), unit, model);
        }
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaConsoleProvider", "getRunners"));
        }
        return arrayList;
    }

    private static void addDefaultRunners(Collection<PersistenceConsoleProvider.Runner> result, Project project, PersistencePackagePointer unit, QlScriptModel model) {
        for (JpaConsole jpaConsole : JpaConsole.getActiveConsoles(project)) {
            if (!((PersistencePackagePointer)jpaConsole.getTarget()).equals(unit)) continue;
            result.add(new MyConsoleRunner(jpaConsole, model));
        }
    }

    public static QlScriptModel createScriptModel(@NotNull PsiFile file, @NotNull QlFile qlFile) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jpa/JpaConsoleProvider", "createScriptModel"));
        }
        if (qlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qlFile", "com/intellij/jpa/JpaConsoleProvider", "createScriptModel"));
        }
        Project project = file.getProject();
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)project);
        if (manager.isInjectedFragment((PsiFile)qlFile)) {
            String fileText = manager.getUnescapedText((PsiElement)qlFile);
            PsiFile file2 = PsiFileFactory.getInstance((Project)project).createFileFromText("a.ql", qlFile.getLanguage(), (CharSequence)fileText);
            QlFile qlFile2 = (QlFile)file2;
            return new QlScriptModel(qlFile2);
        }
        return new QlScriptModel(qlFile);
    }

    @Nullable
    public static QlFile findQlFile(PsiFile file, PsiElement element) {
        QlFile qlFile;
        if (file instanceof QlFile) {
            qlFile = (QlFile)file;
        } else {
            PsiLanguageInjectionHost host;
            if (JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
                PsiLiteralExpression literal = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLiteralExpression.class);
                JpaQueryReferenceProvider.QueryReference queryReference = literal == null ? null : JpaUtil.findReferenceOfType(literal.getReferences(), JpaQueryReferenceProvider.QueryReference.class);
                PsiElement queryElement = queryReference == null ? null : JpaUtil.getQueryElement(queryReference.resolveQuery());
                host = (PsiLanguageInjectionHost)ObjectUtils.tryCast((Object)ObjectUtils.chooseNotNull((Object)queryElement, (Object)literal), PsiLanguageInjectionHost.class);
            } else {
                host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLanguageInjectionHost.class);
            }
            Ref qlFileRef = Ref.create(null);
            if (host != null) {
                InjectedLanguageUtil.forceInjectionOnElement((PsiElement)host);
                InjectedLanguageUtil.enumerate((PsiElement)host, (injectedPsi, places) -> {
                    if (injectedPsi instanceof QlFile) {
                        qlFileRef.set((Object)((QlFile)injectedPsi));
                    }
                });
                qlFile = (QlFile)qlFileRef.get();
            } else {
                qlFile = null;
            }
        }
        return qlFile;
    }

    public static List<RunConfiguration> getJavaRunConfigurations(Project project) {
        ArrayList list = ContainerUtil.newArrayList();
        for (RunConfiguration o : RunManager.getInstance((Project)project).getAllConfigurationsList()) {
            String vmParameters = o instanceof ApplicationConfiguration ? ((CommonJavaRunConfigurationParameters)o).getVMParameters() : null;
            if (!StringUtil.isNotEmpty((String)vmParameters)) continue;
            list.add(o);
        }
        return list;
    }

    @Nullable
    public static ListPopupStep<?> getConfigurationsPopupStep(Project project, String selectedName, Processor<ConsoleRunConfiguration> processor) {
        List<RunConfiguration> runConfigurations = JpaConsoleProvider.getJavaRunConfigurations(project);
        if (runConfigurations.isEmpty()) {
            return null;
        }
        ConsoleRunConfiguration noArgs = ConsoleRunConfiguration.newConfiguration((Project)project);
        noArgs.setName("<default>");
        runConfigurations.add(0, (RunConfiguration)noArgs);
        return JpaConsoleProvider.createConfigurationsPopupStep(runConfigurations, selectedName, profile -> {
            ConsoleRunConfiguration result = ConsoleRunConfiguration.newConfiguration((Project)project);
            if (profile instanceof CommonJavaRunConfigurationParameters) {
                CommonJavaRunConfigurationParameters javaParams = (CommonJavaRunConfigurationParameters)profile;
                result.VM_PARAMETERS = javaParams.getVMParameters();
                result.VM_ENV = ContainerUtil.newLinkedHashMap((Map)javaParams.getEnvs());
                result.setName(profile.getName());
            }
            return processor.process((Object)result);
        });
    }

    @NotNull
    public static <T extends RunProfile> ListPopupStep<T> createConfigurationsPopupStep(@NotNull List<T> profiles, final @Nullable String selectedName, final @NotNull Processor<T> onChosen) {
        if (profiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profiles", "com/intellij/jpa/JpaConsoleProvider", "createConfigurationsPopupStep"));
        }
        if (onChosen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onChosen", "com/intellij/jpa/JpaConsoleProvider", "createConfigurationsPopupStep"));
        }
        ArrayList runConfigurations = ContainerUtil.newArrayList(profiles);
        Collections.sort(runConfigurations, Comparator.comparing(RunProfile::getName));
        BaseListPopupStep popupStep = new BaseListPopupStep<T>("Run Configurations", runConfigurations){

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @NotNull
            public String getTextFor(RunProfile configuration) {
                String name = configuration.getName();
                String string = selectedName != null && selectedName.equals(name) ? name + " *" : name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaConsoleProvider$1", "getTextFor"));
                }
                return string;
            }

            public Icon getIconFor(RunProfile o) {
                return o.getIcon();
            }

            public PopupStep onChosen(T configuration, boolean finalChoice) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (onChosen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onChosen", "com/intellij/jpa/JpaConsoleProvider$1", "lambda$onChosen$0"));
                    }
                    onChosen.process(configuration);
                });
                return PopupStep.FINAL_CHOICE;
            }
        };
        if (selectedName != null) {
            popupStep.setDefaultOptionIndex(-1);
            int size = runConfigurations.size();
            for (int i = 0; i < size; ++i) {
                RunProfile runConfiguration = (RunProfile)runConfigurations.get(i);
                if (!runConfiguration.getName().equals(selectedName)) continue;
                popupStep.setDefaultOptionIndex(i);
                break;
            }
        }
        BaseListPopupStep baseListPopupStep = popupStep;
        if (baseListPopupStep == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaConsoleProvider", "createConfigurationsPopupStep"));
        }
        return baseListPopupStep;
    }

    public static class MyConsoleRunner
    extends PersistenceConsoleProvider.Runner {
        private final JpaConsoleBase myConsole;
        private final ScriptModel myModel;

        public MyConsoleRunner(@NotNull JpaConsoleBase console, @Nullable ScriptModel model) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/jpa/JpaConsoleProvider$MyConsoleRunner", "<init>"));
            }
            this.myConsole = console;
            this.myModel = model;
        }

        public String getDisplayName() {
            return this.myConsole.getTitle();
        }

        public Icon getIcon() {
            return this.myConsole.getToolWindowIcon();
        }

        public boolean isAlreadyRunning() {
            return true;
        }

        public void run() {
            if (this.myModel == null) {
                this.myConsole.showConsole(true);
            } else if (this.myConsole.beforeExecuteQueries(this.myModel)) {
                this.myConsole.executeQueries((Editor)this.myConsole.getLanguageConsole().getCurrentEditor(), this.myModel);
            }
        }
    }

    public static class MyQueryRunner
    extends PersistenceConsoleProvider.Runner {
        private final Project myProject;
        private final List<PersistencePackagePointer> myUnits;
        private final QlScriptModel myModel;

        public MyQueryRunner(Project project, List<PersistencePackagePointer> units, QlScriptModel model) {
            this.myProject = project;
            this.myUnits = units;
            this.myModel = model;
        }

        public String getDisplayName() {
            return "JPA Console";
        }

        public Icon getIcon() {
            return JavaeeIcons.JPA_ICON;
        }

        public boolean isAlreadyRunning() {
            return false;
        }

        public Project getProject() {
            return this.myProject;
        }

        public PopupStep<?> getOptionsStep() {
            if (this.myUnits.size() == 1) {
                return this.getConfigurationStep(this.myUnits.get(0));
            }
            Collections.sort(this.myUnits, (o1, o2) -> Comparing.compare((Comparable)((Object)((VirtualFile)o1).getUrl()), (Comparable)((Object)((VirtualFile)o2).getUrl())));
            return new BaseListPopupStep<PersistencePackagePointer>("Persistence Unit", this.myUnits){

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(PersistencePackagePointer unit) {
                    PersistenceFacet facet = unit.getPersistenceFacet();
                    String unitName = unit.getElementName();
                    String string = facet.getModule().getName() + "/" + (StringUtil.isNotEmpty((String)unitName) ? unitName : JamMessages.message((String)"unnamed.element.presentable.name", (Object[])new Object[0]));
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaConsoleProvider$MyQueryRunner$1", "getTextFor"));
                    }
                    return string;
                }

                public Icon getIconFor(PersistencePackagePointer unit) {
                    return VirtualFilePresentation.getIcon((VirtualFile)((VirtualFile)unit));
                }

                public PopupStep onChosen(PersistencePackagePointer unit, boolean finalChoice) {
                    PopupStep popupStep = this.getConfigurationStep(unit);
                    if (popupStep != null) {
                        return popupStep;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> this.runInner(unit, ConsoleRunConfiguration.newConfiguration((Project)myProject), myModel));
                    return FINAL_CHOICE;
                }
            };
        }

        @Nullable
        private PopupStep<?> getConfigurationStep(PersistencePackagePointer unit) {
            return JpaConsoleProvider.getConfigurationsPopupStep(this.myProject, unit.getElementName(), (Processor<ConsoleRunConfiguration>)((Processor)configuration -> {
                this.runInner(unit, (ConsoleRunConfiguration)configuration, this.myModel);
                return true;
            }));
        }

        public void run() {
            this.runInner(this.myUnits.get(0), ConsoleRunConfiguration.newConfiguration((Project)this.myProject), this.myModel);
        }

        protected void runInner(@NotNull PersistencePackagePointer unit, @NotNull ConsoleRunConfiguration configuration, @NotNull QlScriptModel model) {
            if (unit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/JpaConsoleProvider$MyQueryRunner", "runInner"));
            }
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/jpa/JpaConsoleProvider$MyQueryRunner", "runInner"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/jpa/JpaConsoleProvider$MyQueryRunner", "runInner"));
            }
            String text = (String)model.statements().transform(ScriptModelUtil.TO_TEXT).first();
            JpaConsole console = JpaConsole.newConsole(unit).withRunConfiguration(configuration).withQuery(text).build();
            console.showConsole(false);
            if (console.beforeExecuteQueries(model)) {
                console.executeQueries((Editor)console.getLanguageConsole().getCurrentEditor(), model);
            }
        }
    }

    public static class MyRunner
    extends PersistenceConsoleProvider.Runner {
        private final Project myProject;
        private final PersistencePackagePointer myUnitFile;

        public MyRunner(Project project, PersistencePackageAsVirtualFileImpl unitFile) {
            this.myProject = project;
            this.myUnitFile = unitFile;
        }

        public String getDisplayName() {
            return "JPA Console";
        }

        public Icon getIcon() {
            return JavaeeIcons.JPA_ICON;
        }

        public boolean isAlreadyRunning() {
            return false;
        }

        public void run() {
            this.runInner(ConsoleRunConfiguration.newConfiguration((Project)this.myProject));
        }

        @Nullable
        public PopupStep<?> getOptionsStep() {
            return JpaConsoleProvider.getConfigurationsPopupStep(this.myProject, this.myUnitFile.getElementName(), (Processor<ConsoleRunConfiguration>)((Processor)configuration -> {
                this.runInner((ConsoleRunConfiguration)configuration);
                return true;
            }));
        }

        protected void runInner(ConsoleRunConfiguration configuration) {
            JpaConsole.newConsole(this.myUnitFile).withRunConfiguration(configuration).build().showConsole(true);
        }
    }
}

