/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.annotations.mapping;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.jpa.model.annotations.mapping.AttributeReferenceSet;
import com.intellij.jpa.model.annotations.mapping.JamAttributeBase;
import com.intellij.jpa.model.annotations.mapping.JpaAttributeReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.PersistentTransientAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamAttributeConverter
extends JamSimpleReferenceConverter<PersistentAttribute> {
    public static final JamConverter<PersistentAttribute> ATTRIBUTE_CONVERTER = new JamAttributeConverter(){

        @Override
        protected boolean acceptsAttribute(PersistentAttribute thatAttr, PersistentAttribute thisAttr, boolean resolve) {
            return !(thatAttr instanceof PersistentRelationshipAttribute) && !(thatAttr instanceof PersistentTransientAttribute);
        }
    };
    public static final JamAttributeConverter MAPPED_BY_ID_VALUE_CONVERTER = new JamAttributeConverter(){

        @Override
        protected AttributeReferenceSet newReferenceSet(JamStringAttributeElement<PersistentAttribute> context) {
            return new AttributeReferenceSet(this, (PsiElement)context.getPsiElement()){

                @Override
                @NotNull
                protected JpaAttributeReference createReference(TextRange range, int index) {
                    JpaAttributeReference jpaAttributeReference = index == 0 ? new JpaAttributeReference.MappedByIdReference(this, index, range) : super.createReference(range, index);
                    if (jpaAttributeReference == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/JamAttributeConverter$2$1", "createReference"));
                    }
                    return jpaAttributeReference;
                }
            };
        }
    };

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<PersistentAttribute> context) {
        AttributeReferenceSet set = this.createReferenceSet(context);
        PsiReference[] psiReferenceArray = set == null ? PsiReference.EMPTY_ARRAY : set.getPsiReferences();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/JamAttributeConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    @Nullable
    private AttributeReferenceSet createReferenceSet(JamStringAttributeElement<PersistentAttribute> context) {
        PsiLiteral literal = context.getPsiLiteral();
        return literal == null ? null : this.newReferenceSet(context);
    }

    protected AttributeReferenceSet newReferenceSet(JamStringAttributeElement<PersistentAttribute> context) {
        return new AttributeReferenceSet(this, (PsiElement)context.getPsiElement());
    }

    protected PsiElement getPsiElementFor(@NotNull PersistentAttribute target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/jpa/model/annotations/mapping/JamAttributeConverter", "getPsiElementFor"));
        }
        return target.getPsiMember();
    }

    public PersistentAttribute fromString(@Nullable String s, JamStringAttributeElement<PersistentAttribute> context) {
        AttributeReferenceSet set = this.createReferenceSet(context);
        JpaAttributeReference attributeReference = set == null ? null : (JpaAttributeReference)set.getLastReference();
        return attributeReference == null ? null : attributeReference.resolveAttribute();
    }

    protected boolean acceptsAttribute(PersistentAttribute thatAttr, PersistentAttribute thisAttr, boolean resolve) {
        return true;
    }

    protected boolean traverseCollection() {
        return false;
    }

    @Nullable
    public static PersistentAttribute getAttribute(PsiMember member) {
        if (member == null) {
            return null;
        }
        for (JamMemberMeta meta : AttributeType.getAllJamMetas()) {
            JamAttributeBase attr = (JamAttributeBase)meta.getJamElement((PsiModifierListOwner)member);
            if (attr == null) continue;
            return attr;
        }
        return null;
    }
}

