/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.util;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QueryParameterResolveHelper<T, Context> {
    protected boolean addParamMap(@NotNull PsiFile file, List<T> result, Context context) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jpa/util/QueryParameterResolveHelper", "addParamMap"));
        }
        return false;
    }

    protected boolean addParamMapsByQueryElement(@NotNull PsiElement element, List<T> result, Context context) {
        PsiLanguageInjectionHost host;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/util/QueryParameterResolveHelper", "addParamMapsByQueryElement"));
        }
        if (element instanceof PsiLanguageInjectionHost) {
            host = (PsiLanguageInjectionHost)element;
        } else if (element instanceof XmlTag) {
            XmlText[] texts = ((XmlTag)element).getValue().getTextElements();
            XmlText targetText = texts.length > 0 ? texts[0] : null;
            for (XmlText text : texts) {
                if (text.getText().trim().length() <= 0) continue;
                targetText = text;
            }
            host = (PsiLanguageInjectionHost)targetText;
        } else {
            host = null;
        }
        if (host != null) {
            InjectedLanguageUtil.forceInjectionOnElement((PsiElement)host);
            boolean[] found = new boolean[]{false};
            InjectedLanguageUtil.enumerate((PsiElement)host, (injectedPsi, places) -> {
                if (found[0]) {
                    return;
                }
                found[0] = this.addParamMap(injectedPsi, result, context);
            });
            return found[0];
        }
        return false;
    }

    private boolean addParameterMapsByQueryVariable(@NotNull PsiElement psiElement, final List<T> mapList, final Collection<PsiElement> visitedElements, final Context context) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/jpa/util/QueryParameterResolveHelper", "addParameterMapsByQueryVariable"));
        }
        Collection possibleInitializations = DfaUtil.getPossibleInitializationElements((PsiElement)psiElement);
        if (possibleInitializations.isEmpty()) {
            return false;
        }
        final Ref rc = Ref.create((Object)Boolean.FALSE);
        for (PsiElement element : possibleInitializations) {
            PsiElement variant = element instanceof PsiMethodCallExpression ? this.skipChainedMethodCalls((PsiExpression)element, context) : element;
            variant.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){
                boolean stop;

                public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                    if (!visitedElements.add(expression)) {
                        return;
                    }
                    for (PsiExpression psiExpression : expression.getArgumentList().getExpressions()) {
                        if (visitedElements.contains(psiExpression)) break;
                        psiExpression.accept((PsiElementVisitor)this);
                    }
                    PsiExpression qualifier = expression.getMethodExpression().getQualifierExpression();
                    if (qualifier != null) {
                        qualifier.accept((PsiElementVisitor)this);
                    }
                }

                public void visitExpression(PsiExpression expression) {
                    PsiLiteralExpression literal = QueryParameterResolveHelper.getFirstLiteral(expression);
                    if (literal != null) {
                        literal.accept((PsiElementVisitor)this);
                    }
                }

                public void visitElement(PsiElement element) {
                    if (this.stop) {
                        return;
                    }
                    super.visitElement(element);
                }

                public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
                    if (this.stop) {
                        return;
                    }
                    if (!visitedElements.add(expression)) {
                        return;
                    }
                    if (QueryParameterResolveHelper.this.addParamMapsByQueryElement((PsiElement)expression, mapList, context)) {
                        this.stop = true;
                        rc.set((Object)true);
                    }
                }

                public void visitLiteralExpression(PsiLiteralExpression literalExpression) {
                    if (this.stop) {
                        return;
                    }
                    if (!visitedElements.add(literalExpression)) {
                        return;
                    }
                    if (QueryParameterResolveHelper.this.addParamMapsByQueryElement((PsiElement)literalExpression, mapList, context)) {
                        this.stop = true;
                        rc.set((Object)true);
                    }
                }

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    if (this.stop) {
                        return;
                    }
                    if (QueryParameterResolveHelper.this.addParameterMapsByQueryReference(expression, mapList, visitedElements, context)) {
                        this.stop = true;
                        rc.set((Object)true);
                    }
                }
            });
        }
        return (Boolean)rc.get();
    }

    public boolean addParameterMapsByQueryReference(PsiReferenceExpression expression, List<T> result, Collection<PsiElement> visitedElements, Context context) {
        if (expression == null) {
            return false;
        }
        boolean rc = false;
        PsiElement resolveElement = expression.resolve();
        if (resolveElement instanceof PsiVariable && visitedElements.add(resolveElement)) {
            boolean ourVariable = this.addParameterMapsByQueryVariable((PsiElement)expression, result, visitedElements, context);
            if (ourVariable) {
                this.visitOurVariable((PsiVariable)resolveElement, result, context);
            }
            return ourVariable;
        }
        return rc;
    }

    protected boolean processPossibleQueryElement(PsiElement element, List<T> result, Collection<PsiElement> visitedElements, Context context) {
        if (element instanceof PsiExpression) {
            return this.addParameterMapsByQueryVariable(element, result, visitedElements, context);
        }
        return false;
    }

    public boolean processPossibleQueryElementsByParameter(PsiElement paramElement, List<T> result, Context context) {
        PsiMethodCallExpression expression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)paramElement, PsiMethodCallExpression.class);
        if (expression == null) {
            return false;
        }
        return this.processPossibleQueryElement((PsiElement)expression, result, QueryParameterResolveHelper.initialVisitedElements(paramElement), context);
    }

    public static Collection<PsiElement> initialVisitedElements(PsiElement element) {
        THashSet result = new THashSet();
        result.add((Object)element);
        return result;
    }

    @NotNull
    public PsiExpression skipChainedMethodCalls(@NotNull PsiExpression methodCallExpression, Context context) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/intellij/jpa/util/QueryParameterResolveHelper", "skipChainedMethodCalls"));
        }
        PsiType type = null;
        PsiExpression current = methodCallExpression;
        while (current instanceof PsiMethodCallExpression) {
            PsiExpression next;
            PsiType nextType;
            if (type == null) {
                PsiMethod method = ((PsiMethodCallExpression)current).resolveMethod();
                type = method == null ? null : method.getReturnType();
            }
            PsiType psiType = nextType = (next = ((PsiMethodCallExpression)current).getMethodExpression().getQualifierExpression()) == null ? null : next.getType();
            if (type == null) {
                type = nextType;
            }
            if (nextType == null || !type.isAssignableFrom(nextType) || !this.skipChainedMethodCall((PsiMethodCallExpression)current, context)) break;
            current = next;
        }
        PsiExpression psiExpression = current;
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/util/QueryParameterResolveHelper", "skipChainedMethodCalls"));
        }
        return psiExpression;
    }

    protected boolean skipChainedMethodCall(PsiMethodCallExpression expression, Context context) {
        return true;
    }

    protected void visitOurVariable(PsiVariable variable, List<T> result, Context context) {
    }

    @Nullable
    public static PsiLiteralExpression getFirstLiteral(PsiExpression expression) {
        while (true) {
            if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)expression;
                if (binaryExpression.getOperationTokenType() != JavaTokenType.PLUS) break;
                expression = binaryExpression.getOperands()[0];
                continue;
            }
            if (!(expression instanceof PsiParenthesizedExpression)) break;
            expression = ((PsiParenthesizedExpression)expression).getExpression();
        }
        return expression instanceof PsiLiteralExpression ? (PsiLiteralExpression)expression : null;
    }
}

