/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.view;

import com.intellij.database.view.DatabaseView;
import com.intellij.facet.Facet;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.tree.JamTreeParameters;
import com.intellij.jam.view.tree.JamTreeStructure;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.module.view.nodes.J2EEModuleParameters;
import com.intellij.javaee.ui.FrameworkToolWindowViewBase;
import com.intellij.jpa.view.JpaToolWindowFactory;
import com.intellij.jpa.view.nodes.PersistenceFacetNodeDescriptor;
import com.intellij.jpa.view.nodes.PersistenceUnitNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import icons.DatabaseIcons;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class JpaView
extends FrameworkToolWindowViewBase
implements Disposable {
    public JpaView(Project project) {
        super(project, new FrameworkToolWindowViewBase.FrameworkViewTreeStructureProvider(){

            public JamTreeStructure createTreeStructure(final @NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/view/JpaView$1", "createTreeStructure"));
                }
                return JamTreeStructure.asyncInstance((SimpleNode)new JamNodeDescriptor<Project>(project, null, (Object)new J2EEModuleParameters(true), project){

                    public JamNodeDescriptor[] getChildren() {
                        1 parentDescriptor = this;
                        JamTreeParameters parameters = (JamTreeParameters)this.getParameters();
                        return (JamNodeDescriptor[])ContainerUtil.map2Array((Collection)PersistenceCommonUtil.getAllPersistenceFacets((Project)project), JamNodeDescriptor.class, facet -> new PersistenceFacetNodeDescriptor((PersistenceFacet)facet, (NodeDescriptor)parentDescriptor, parameters));
                    }

                    protected String getNewNodeText() {
                        return project.getName();
                    }
                }, (Project)project);
            }
        });
        this.initComponents();
        PopupHandler.installPopupHandler((JComponent)this.myTree, (String)"JpaViewPopupMenu", (String)"J2EEViewPopup");
        ProjectWideFacetListenersRegistry.getInstance((Project)this.myProject).registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetConfigurationChanged(Facet facet) {
                JpaView.this.updateTree();
            }

            public void facetRemoved(Facet facet) {
                JpaView.this.updateTree();
            }

            public void facetAdded(Facet facet) {
                JpaView.this.updateTree();
            }
        }, (Disposable)this);
    }

    @Override
    protected void addTitleActions(List<AnAction> actions) {
        final AnAction baseAction = ActionManager.getInstance().getAction("Jpa.OpenConsole");
        AnAction consoleTitleAction = new AnAction(){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(true);
            }

            public void actionPerformed(AnActionEvent e) {
                PersistencePackage unit;
                JTree tree = JpaView.this.myBuilder.getTree();
                if (tree == null) {
                    return;
                }
                PersistenceFacetNodeDescriptor facetNodeDescriptor = (PersistenceFacetNodeDescriptor)((Object)DatabaseView.getSelectedElementOfType(PersistenceFacetNodeDescriptor.class, (boolean)false, (JTree)tree));
                PersistenceUnitNodeDescriptor unitNodeDescriptor = (PersistenceUnitNodeDescriptor)((Object)DatabaseView.getSelectedElementOfType(PersistenceUnitNodeDescriptor.class, (boolean)false, (JTree)tree));
                PersistenceFacet facet = facetNodeDescriptor != null ? (PersistenceFacet)facetNodeDescriptor.getElement() : null;
                PersistencePackage persistencePackage = unit = unitNodeDescriptor != null ? (PersistencePackage)unitNodeDescriptor.getElement() : null;
                if (unit != null && facet != null) {
                    DataContext dataContext = e.getDataContext();
                    HashMap map = new HashMap();
                    map.put((Object)PersistenceDataKeys.PERSISTENCE_FACET.getName(), (Object)facet);
                    map.put((Object)PersistenceDataKeys.PERSISTENCE_UNIT.getName(), (Object)unit);
                    baseAction.actionPerformed(new AnActionEvent(e.getInputEvent(), SimpleDataContext.getSimpleContext((Map)map, (DataContext)dataContext), e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers()));
                }
            }
        };
        consoleTitleAction.copyFrom(baseAction);
        consoleTitleAction.getTemplatePresentation().setIcon(DatabaseIcons.ConsoleRun);
        consoleTitleAction.getTemplatePresentation().setHoveredIcon(DatabaseIcons.ConsoleRunHover);
        actions.add(consoleTitleAction);
        super.addTitleActions(actions);
    }

    public Object getData(String dataId) {
        DeleteProvider provider;
        Object data = super.getData(dataId);
        if (data != null) {
            return data;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.persistence.tool.window";
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) && (provider = JamCommonUtil.createDeleteProvider((AbstractTreeBuilder)this.myBuilder)) != null) {
            return provider;
        }
        Set set = this.myBuilder.getSelectedElements();
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId) || CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            boolean isPsi = LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId);
            DataKey singleKey = isPsi ? CommonDataKeys.PSI_ELEMENT : CommonDataKeys.NAVIGATABLE;
            List result = ContainerUtil.newSmartList();
            for (Object node : set) {
                if (!(node instanceof JamNodeDescriptor) || !((JamNodeDescriptor)node).isValid()) continue;
                Object val = ((JamNodeDescriptor)node).getDataForElement(singleKey.getName());
                ContainerUtil.addIfNotNull((Collection)result, (Object)val);
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(isPsi ? new PsiElement[result.size()] : new Navigatable[result.size()]);
        }
        Object firstNode = ContainerUtil.getFirstItem((Collection)set);
        if (firstNode instanceof JamNodeDescriptor && ((JamNodeDescriptor)firstNode).isValid()) {
            return ((JamNodeDescriptor)firstNode).getDataForElement(dataId);
        }
        return null;
    }

    public static void select(Project project, Object[] path, boolean requestFocus) {
        if (path == null) {
            return;
        }
        Runnable runnable = () -> {
            JpaView view = JpaToolWindowFactory.getJpaView(project);
            if (view == null || view.myBuilder == null) {
                return;
            }
            if (requestFocus) {
                IdeFocusManager.getInstance((Project)project).requestFocus((Component)view.myTree, true);
            }
            JavaeeUtil.selectPath((AbstractTreeBuilder)view.myBuilder, path);
        };
        if (requestFocus) {
            ToolWindowManager.getInstance((Project)project).getToolWindow("Persistence").activate(runnable);
        } else {
            runnable.run();
        }
    }
}

