/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.web.WebContextManager;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetContextFolderFix
implements LocalQuickFix,
IntentionAction {
    private final PsiFileSystemItem myTarget;
    private final PsiFileSystemItem myContextFolder;

    @Nullable
    public static SetContextFolderFix[] create(@NotNull FileReference reference, @NotNull WebFacet facet) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SetContextFolderFix", "create"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SetContextFolderFix", "create"));
        }
        if (reference.getFileReferenceSet().isAbsolutePathReference()) {
            return null;
        }
        PsiFile psiFile = reference.getElement().getContainingFile();
        if (psiFile == null) {
            return null;
        }
        final WebDirectoryElement root = WebUtil.getWebUtil().findWebDirectoryElement("/", facet);
        if (root == null) {
            return null;
        }
        FileReference first = reference.getFileReferenceSet().getAllReferences()[0];
        FileReference fixedReference = new FileReference(first){

            @NotNull
            protected Collection<PsiFileSystemItem> getContexts() {
                Set<WebDirectoryElement> set = Collections.singleton(root);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SetContextFolderFix$1", "getContexts"));
                }
                return set;
            }
        };
        PsiDirectory parent = psiFile.getParent();
        if (fixedReference.multiResolve(false).length == 0) {
            return null;
        }
        if (parent != null) {
            return new SetContextFolderFix[]{new SetContextFolderFix((PsiFileSystemItem)root, (PsiFileSystemItem)psiFile), new SetContextFolderFix((PsiFileSystemItem)root, (PsiFileSystemItem)parent)};
        }
        return new SetContextFolderFix[]{new SetContextFolderFix((PsiFileSystemItem)root, (PsiFileSystemItem)psiFile)};
    }

    public SetContextFolderFix(@NotNull PsiFileSystemItem contextFolder, @NotNull PsiFileSystemItem target) {
        if (contextFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFolder", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SetContextFolderFix", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SetContextFolderFix", "<init>"));
        }
        this.myContextFolder = contextFolder;
        this.myTarget = target;
    }

    @NotNull
    public String getName() {
        String string = !this.myTarget.isDirectory() ? J2EEBundle.message((String)"web.context.fix", (Object[])new Object[]{this.myTarget.getName()}) : J2EEBundle.message((String)"web.context.fix.for.directory", (Object[])new Object[]{this.myTarget.getName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SetContextFolderFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SetContextFolderFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = J2EEBundle.message((String)"web.context.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SetContextFolderFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SetContextFolderFix", "isAvailable"));
        }
        return true;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SetContextFolderFix", "getElementToMakeWritable"));
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SetContextFolderFix", "invoke"));
        }
        WebContextManager.getInstance((Project)project).setContextFolder(this.myTarget, this.myContextFolder);
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SetContextFolderFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/impl/source/resolve/reference/impl/providers/SetContextFolderFix", "applyFix"));
        }
    }
}

