/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.batch.model.scope;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.scope.SpringCustomBeanScope;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringBatchCustomBeanScope
extends SpringCustomBeanScope {
    public String getScopeClassName() {
        return "org.springframework.batch.core.scope.StepScope";
    }

    public boolean process(List<SpringBeanScope> scopes, Set<SpringModel> models, @NotNull PsiClass scopeClass, PsiElement psiElement) {
        if (scopeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeClass", "com/intellij/spring/batch/model/scope/SpringBatchCustomBeanScope", "process"));
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (!(containingFile instanceof XmlFile)) {
            return true;
        }
        if (XmlUtil.findNamespacePrefixByURI((XmlFile)((XmlFile)containingFile), (String)"http://www.springframework.org/schema/batch") != null) {
            scopes.add(new SpringBeanScope("step"));
            return true;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)scopeClass);
        for (SpringModel model : models) {
            if (!SpringModelSearchers.doesBeanExist((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters)) continue;
            scopes.add(new SpringBeanScope("step"));
            return true;
        }
        return true;
    }
}

