/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.jetbrains.quirksmode.HtmlFilePattern;
import com.jetbrains.quirksmode.HtmlTagPattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlPatterns
extends PlatformPatterns {
    private HtmlPatterns() {
    }

    public static HtmlTagPattern htmlTag() {
        return (HtmlTagPattern)new HtmlTagPattern().withNamespace((ElementPattern)StandardPatterns.string().oneOf(new String[]{"http://www.w3.org/1999/html", "http://www.w3.org/1999/xhtml"}));
    }

    @NotNull
    public static HtmlTagPattern htmlTag(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/quirksmode/HtmlPatterns", "htmlTag"));
        }
        HtmlTagPattern htmlTagPattern = (HtmlTagPattern)HtmlPatterns.htmlTag().withLocalName(name);
        if (htmlTagPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/quirksmode/HtmlPatterns", "htmlTag"));
        }
        return htmlTagPattern;
    }

    public static HtmlFilePattern htmlFile() {
        return new HtmlFilePattern();
    }
}

