/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.aop.SpringAdvisedElementsSearcher;
import com.intellij.spring.aop.SpringAopBundle;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomFileElement;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnableAspectJQuickFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.model.highlighting.EnableAspectJQuickFix");
    private final CommonSpringModel myModel;

    public EnableAspectJQuickFix(CommonSpringModel beans) {
        this.myModel = beans;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpringAopBundle.message("aop.enable.aspectj.fix.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/EnableAspectJQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/EnableAspectJQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/EnableAspectJQuickFix", "applyFix"));
        }
        for (XmlSpringModel model : SpringAdvisedElementsSearcher.findXmlModels(this.myModel)) {
            Set roots = model.getLocalModelsRoots();
            if (!roots.iterator().hasNext()) continue;
            DomFileElement fileElement = (DomFileElement)roots.iterator().next();
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)fileElement.getFile())) {
                return;
            }
            XmlTag root = ((Beans)fileElement.getRootElement()).ensureTagExists();
            try {
                if (EnableAspectJQuickFix.isSchemaStyle(root)) {
                    WriteCommandAction.runWriteCommandAction((Project)project, () -> EnableAspectJQuickFix.addAspectjAutoproxy(root));
                    continue;
                }
                WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                    XmlTag childTag = root.createChildTag("bean", root.getNamespace(), null, false);
                    childTag.setAttribute("class", "org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator");
                    root.add((PsiElement)childTag);
                });
                return;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public static boolean isSchemaStyle(@Nullable XmlTag root) {
        return root != null && root.getNamespace().contains("http://www.springframework.org/schema/");
    }

    public static void addAspectjAutoproxy(XmlTag root) {
        try {
            if (root.getPrefixByNamespace("http://www.springframework.org/schema/aop") == null && root.getNamespaceByPrefix("aop") == "") {
                root.setAttribute("xmlns:aop", "http://www.springframework.org/schema/aop");
            }
            root.add((PsiElement)root.createChildTag("aspectj-autoproxy", "http://www.springframework.org/schema/aop", null, false));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

