/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopProvider;
import com.intellij.aop.jam.AopJavaAnnotator;
import com.intellij.aop.jam.AopLanguageInjector;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.concurrency.JobScheduler;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.aop.SpringAdvisedElementsSearcher;
import com.intellij.spring.aop.SpringAopBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.highlighting.EnableAspectJQuickFix;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.xml.aop.AopConfig;
import com.intellij.spring.model.xml.aop.AspectjAutoproxy;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.Idref;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.spring.model.xml.beans.TypeHolder;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkProxiedBeanTypeInspection
extends SpringBeanInspectionBase {
    private static final Key<CachedValue<Set<PsiClass>>> REPLACE_CLASS = Key.create((String)"ReplaceClassWithInterfaces");
    private static volatile boolean FORCE_TIMEOUT = false;

    protected SpringModelVisitor createVisitor(final DomElementAnnotationHolder holder, @NotNull Beans beans, @Nullable CommonSpringModel model) {
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/JdkProxiedBeanTypeInspection", "createVisitor"));
        }
        return new SpringModelVisitor(){

            protected boolean visitValueHolder(SpringValueHolder valueHolder) {
                Idref idref;
                List types = TypeHolderUtil.getRequiredTypes((TypeHolder)valueHolder);
                if (types.size() != 1 || !(types.get(0) instanceof PsiClassType)) {
                    return true;
                }
                PsiClass psiClass = ((PsiClassType)types.get(0)).resolve();
                if (psiClass == null || psiClass.isInterface()) {
                    return true;
                }
                JdkProxiedBeanTypeInspection.checkReference((GenericDomValue<SpringBeanPointer>)((GenericDomValue)valueHolder.getRefAttr()), holder);
                SpringRef ref = valueHolder.getRef();
                if (DomUtil.hasXml((DomElement)ref)) {
                    JdkProxiedBeanTypeInspection.checkReference((GenericDomValue<SpringBeanPointer>)((GenericDomValue)ref.getBean()), holder);
                    JdkProxiedBeanTypeInspection.checkReference((GenericDomValue<SpringBeanPointer>)((GenericDomValue)ref.getLocal()), holder);
                    JdkProxiedBeanTypeInspection.checkReference((GenericDomValue<SpringBeanPointer>)((GenericDomValue)ref.getParentAttr()), holder);
                }
                if (DomUtil.hasXml((DomElement)(idref = valueHolder.getIdref()))) {
                    JdkProxiedBeanTypeInspection.checkReference((GenericDomValue<SpringBeanPointer>)((GenericDomValue)idref.getBean()), holder);
                    JdkProxiedBeanTypeInspection.checkReference((GenericDomValue<SpringBeanPointer>)((GenericDomValue)idref.getLocal()), holder);
                }
                return true;
            }
        };
    }

    private static void checkReference(GenericDomValue<SpringBeanPointer> springBean, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml(springBean)) {
            return;
        }
        SpringBeanPointer pointer = (SpringBeanPointer)springBean.getValue();
        if (pointer != null) {
            ScheduledFuture<?> scheduledFuture;
            PsiClass psiClass = pointer.getBeanClass();
            if (psiClass == null || psiClass.isInterface()) {
                return;
            }
            THashSet interfaces = new THashSet();
            SensitiveProgressWrapper progress = new SensitiveProgressWrapper(ProgressManager.getInstance().getProgressIndicator());
            Runnable cancelOnTimeOut = () -> ((SensitiveProgressWrapper)progress).cancel();
            ScheduledFuture<?> scheduledFuture2 = scheduledFuture = FORCE_TIMEOUT ? null : JobScheduler.getScheduler().schedule(cancelOnTimeOut, 200L, TimeUnit.MILLISECONDS);
            if (FORCE_TIMEOUT) {
                cancelOnTimeOut.run();
            }
            try {
                ProgressManager.getInstance().runProcess(() -> JdkProxiedBeanTypeInspection.lambda$checkReference$0(progress, (Set)interfaces, psiClass), (ProgressIndicator)progress);
            }
            catch (ProcessCanceledException e) {
                if (FORCE_TIMEOUT) {
                    holder.createProblem(springBean, ProblemHighlightType.WEAK_WARNING, "Could not determine JDK-proxied bean type", null, JdkProxiedBeanTypeInspection.createFixes(springBean));
                    return;
                }
                throw e;
            }
            finally {
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(true);
                }
            }
            if (!interfaces.isEmpty()) {
                String s = StringUtil.join((Collection)ContainerUtil.map((Collection)interfaces, PsiClass::getQualifiedName), (String)", ");
                holder.createProblem(springBean, HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING, SpringAopBundle.message("jdk.proxy.intercepts.class", s), JdkProxiedBeanTypeInspection.createFixes(springBean));
            }
        }
    }

    private static LocalQuickFix[] createFixes(DomElement annotatedElement) {
        LocalQuickFix[] localQuickFixArray;
        if (EnableAspectJQuickFix.isSchemaStyle(DomUtil.getFileElement((DomElement)annotatedElement).getRootElement().getXmlTag())) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = new SwitchToCglibProxyingFix(annotatedElement);
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        return localQuickFixArray;
    }

    private static Set<PsiClass> getInterfacesToReplaceClassWith(final PsiClass psiClass) {
        CachedValue classes = (CachedValue)psiClass.getUserData(REPLACE_CLASS);
        if (classes == null) {
            classes = CachedValuesManager.getManager((Project)psiClass.getProject()).createCachedValue(() -> (CachedValueProvider.Result)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CachedValueProvider.Result<Set<PsiClass>>>(){

                public CachedValueProvider.Result<Set<PsiClass>> compute() {
                    ProgressManager.checkCanceled();
                    for (AopProvider provider : AopLanguageInjector.getAopProviders((PsiElement)psiClass)) {
                        SpringAdvisedElementsSearcher searcher;
                        AopAdvisedElementsSearcher elementsSearcher = provider.getAdvisedElementsSearcher(psiClass);
                        if (!(elementsSearcher instanceof SpringAdvisedElementsSearcher) || !(searcher = (SpringAdvisedElementsSearcher)elementsSearcher).isJdkProxyType() || !JdkProxiedBeanTypeInspection.isAdvised(psiClass)) continue;
                        THashSet interfaces = new THashSet();
                        JamCommonUtil.processSuperClassList((PsiClass)psiClass, (Collection)new ArrayListSet(), arg_0 -> 2.lambda$compute$0((Set)interfaces, arg_0));
                        return CachedValueProvider.Result.create((Object)interfaces, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                    }
                    return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                }

                private static /* synthetic */ boolean lambda$compute$0(Set interfaces, PsiClass psiClass1) {
                    ContainerUtil.addAll((Collection)interfaces, (Object[])psiClass1.getInterfaces());
                    return true;
                }
            }), false);
            psiClass.putUserData(REPLACE_CLASS, (Object)classes);
        }
        return (Set)classes.getValue();
    }

    @NotNull
    public String getShortName() {
        if ("JdkProxiedBeanTypeInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/JdkProxiedBeanTypeInspection", "getShortName"));
        }
        return "JdkProxiedBeanTypeInspection";
    }

    private static boolean isAdvised(PsiClass psiClass) {
        return !AopJavaAnnotator.getBoundAdvices((PsiClass)psiClass).isEmpty() || !AopJavaAnnotator.getBoundIntroductions((PsiClass)psiClass).isEmpty();
    }

    public static void setForceTimeout(boolean active) {
        FORCE_TIMEOUT = active;
    }

    private static /* synthetic */ void lambda$checkReference$0(SensitiveProgressWrapper progress, Set interfaces, PsiClass psiClass) {
        progress.checkCanceled();
        interfaces.addAll(JdkProxiedBeanTypeInspection.getInterfacesToReplaceClassWith(psiClass));
    }

    private static class SwitchToCglibProxyingFix
    implements LocalQuickFix {
        private final DomElement myElement;

        public SwitchToCglibProxyingFix(DomElement element) {
            this.myElement = element;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringAopBundle.message("use.cglib.proxying", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/JdkProxiedBeanTypeInspection$SwitchToCglibProxyingFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/JdkProxiedBeanTypeInspection$SwitchToCglibProxyingFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/JdkProxiedBeanTypeInspection$SwitchToCglibProxyingFix", "applyFix"));
            }
            Beans beans = (Beans)DomUtil.getFileElement((DomElement)this.myElement).getRootElement();
            List configs = DomUtil.getDefinedChildrenOfType((DomElement)beans, AopConfig.class, (boolean)true, (boolean)false);
            if (!configs.isEmpty()) {
                ((AopConfig)configs.get(0)).getProxyTargetClass().setValue((Object)Boolean.TRUE);
                return;
            }
            List autoproxyList = DomUtil.getDefinedChildrenOfType((DomElement)beans, AspectjAutoproxy.class, (boolean)true, (boolean)false);
            if (autoproxyList.isEmpty()) {
                EnableAspectJQuickFix.addAspectjAutoproxy(beans.getXmlTag());
                autoproxyList = DomUtil.getDefinedChildrenOfType((DomElement)beans, AspectjAutoproxy.class, (boolean)true, (boolean)false);
            }
            ((AspectjAutoproxy)autoproxyList.get(0)).getProxyTargetClass().setValue((Object)Boolean.TRUE);
        }
    }
}

