/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopAdviceType;
import com.intellij.aop.AopBundle;
import com.intellij.aop.ArgNamesManipulator;
import com.intellij.aop.LocalAopModel;
import com.intellij.aop.jam.AbstractAopInspection;
import com.intellij.aop.psi.AopPointcutExpressionHolder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AroundAdviceStyleInspection
extends AbstractAopInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.aop.jam.AroundAdviceStyleInspection");

    @Override
    protected void checkAopMethod(final PsiMethod pointcutMethod, LocalAopModel model, ProblemsHolder holder, AopPointcutExpressionHolder aopFile) {
        ArgNamesManipulator manipulator = model.getArgNamesManipulator();
        if (manipulator == null || manipulator.getAdviceType() != AopAdviceType.AROUND) {
            return;
        }
        final PsiElementFactory factory = JavaPsiFacade.getInstance((Project)pointcutMethod.getProject()).getElementFactory();
        if (PsiType.VOID.equals((Object)pointcutMethod.getReturnType()) && pointcutMethod.getReturnTypeElement() != null) {
            holder.registerProblem(manipulator.getCommonProblemElement(), AopBundle.message("around.advice.should.return.something", new Object[0]), new LocalQuickFix[]{new LocalQuickFix(){

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/aop/jam/AroundAdviceStyleInspection$1", "applyFix"));
                    }
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/aop/jam/AroundAdviceStyleInspection$1", "applyFix"));
                    }
                    if (!pointcutMethod.isValid()) {
                        return;
                    }
                    try {
                        PsiClassType object = PsiType.getJavaLangObject((PsiManager)pointcutMethod.getManager(), (GlobalSearchScope)pointcutMethod.getResolveScope());
                        pointcutMethod.getReturnTypeElement().replace((PsiElement)factory.createTypeElement((PsiType)object));
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }

                @NotNull
                public String getFamilyName() {
                    String string = AopBundle.message("change.return.type.to.Object", new Object[0]);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AroundAdviceStyleInspection$1", "getFamilyName"));
                    }
                    return string;
                }
            }});
            return;
        }
        PsiParameter[] parameters = pointcutMethod.getParameterList().getParameters();
        if (parameters.length == 0 || !parameters[0].getType().equalsToText("org.aspectj.lang.ProceedingJoinPoint")) {
            holder.registerProblem(manipulator.getCommonProblemElement(), AopBundle.message("around.advice.call.cannot.proceed", new Object[0]), new LocalQuickFix[]{new LocalQuickFix(){

                @NotNull
                public String getFamilyName() {
                    String string = AopBundle.message("add.pjp.parameter", new Object[0]);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AroundAdviceStyleInspection$2", "getFamilyName"));
                    }
                    return string;
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/aop/jam/AroundAdviceStyleInspection$2", "applyFix"));
                    }
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/aop/jam/AroundAdviceStyleInspection$2", "applyFix"));
                    }
                    if (!pointcutMethod.isValid()) {
                        return;
                    }
                    try {
                        PsiParameter newParameter = factory.createParameter("pjp", factory.createTypeFromText("org.aspectj.lang.ProceedingJoinPoint", (PsiElement)pointcutMethod));
                        PsiParameterList list = pointcutMethod.getParameterList();
                        if (list.getParametersCount() == 0) {
                            list.add((PsiElement)newParameter);
                        } else {
                            list.addBefore((PsiElement)newParameter, (PsiElement)list.getParameters()[0]);
                        }
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }});
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AopBundle.message("around.advice.style.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AroundAdviceStyleInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("AroundAdviceStyleInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AroundAdviceStyleInspection", "getShortName"));
        }
        return "AroundAdviceStyleInspection";
    }
}

