/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow;

import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowLocation;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowLocationPattern;
import com.intellij.spring.webflow.model.xml.Evaluate;
import com.intellij.spring.webflow.model.xml.ExceptionHandler;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.If;
import com.intellij.spring.webflow.model.xml.Render;
import com.intellij.spring.webflow.model.xml.Set;
import com.intellij.spring.webflow.model.xml.Transition;
import com.intellij.spring.webflow.model.xml.WebflowNamedAction;
import com.intellij.spring.webflow.util.WebflowUtil;
import icons.SpringApiIcons;
import javax.swing.Icon;

public class WebflowPresentationProvider
extends PresentationProvider {
    public String getName(Object o) {
        if (o instanceof Flow) {
            return WebflowUtil.getFlowName((Flow)o);
        }
        if (o instanceof Evaluate) {
            return ((Evaluate)o).getExpression().getStringValue();
        }
        if (o instanceof If) {
            return ((If)o).getTest().getStringValue();
        }
        if (o instanceof ExceptionHandler) {
            return ((ExceptionHandler)o).getBean().getStringValue();
        }
        if (o instanceof Transition) {
            Transition transition = (Transition)o;
            String onValue = transition.getOn().getStringValue();
            if (StringUtil.isNotEmpty((String)onValue)) {
                return onValue;
            }
            PsiClass psiClass = (PsiClass)transition.getOnException().getValue();
            return psiClass != null ? psiClass.getName() : transition.getTo().getStringValue();
        }
        if (o instanceof WebflowNamedAction) {
            WebflowNamedAction action = (WebflowNamedAction)o;
            String actionName = action.getName().getStringValue();
            if (StringUtil.isNotEmpty((String)actionName)) {
                return actionName;
            }
            String beanName = action.getBean().getStringValue();
            String methodName = action.getMethod().getStringValue();
            return StringUtil.isNotEmpty((String)methodName) ? beanName + "." + methodName : beanName;
        }
        if (o instanceof Render) {
            return ((Render)o).getFragments().getStringValue();
        }
        if (o instanceof Set) {
            return ((Set)o).getName().getStringValue();
        }
        return null;
    }

    public Icon getIcon(Object o) {
        if (o instanceof FlowLocation || o instanceof FlowLocationPattern) {
            return SpringApiIcons.SpringBean;
        }
        return null;
    }
}

