/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts;

import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts.NamedModelImpl;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.core.PsiBeanProperty;
import com.intellij.struts.core.PsiBeanPropertyCache;
import com.intellij.struts.core.PsiBeanPropertyImpl;
import com.intellij.struts.dom.Action;
import com.intellij.struts.dom.FormBean;
import com.intellij.struts.dom.FormProperty;
import com.intellij.struts.dom.Forward;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.struts.util.PsiClassUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsModelImpl
extends NamedModelImpl<StrutsConfig>
implements StrutsModel {
    private final CommonServlet myActionServlet;
    private final ServletMappingInfo myMappingInfo;
    @Nullable
    private final PsiElement myConfigurationTag;

    public StrutsModelImpl(@NotNull Set<XmlFile> configFiles, @NotNull DomFileElement<StrutsConfig> mergedModel, @NotNull ServletMappingInfo mappingInfo, @NotNull String modulePrefix, @Nullable PsiElement configurationTag) {
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFiles", "com/intellij/struts/StrutsModelImpl", "<init>"));
        }
        if (mergedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedModel", "com/intellij/struts/StrutsModelImpl", "<init>"));
        }
        if (mappingInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappingInfo", "com/intellij/struts/StrutsModelImpl", "<init>"));
        }
        if (modulePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePrefix", "com/intellij/struts/StrutsModelImpl", "<init>"));
        }
        super(configFiles, mergedModel, modulePrefix);
        this.myMappingInfo = mappingInfo;
        this.myActionServlet = mappingInfo.getServlet();
        this.myConfigurationTag = configurationTag;
    }

    @NotNull
    public String getModulePrefix() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/StrutsModelImpl", "getModulePrefix"));
        }
        return string;
    }

    @Nullable
    public WebDirectoryElement getModuleRoot() {
        WebFacet webFacet = WebUtil.getWebFacet((JavaeeModelElement)this.myActionServlet);
        WebDirectoryUtil directoryUtil = WebDirectoryUtil.getWebDirectoryUtil((Project)((StrutsConfig)this.getMergedModel()).getManager().getProject());
        return directoryUtil.findWebDirectoryElementByPath(this.getModulePrefix(), webFacet);
    }

    @Nullable
    public PsiElement getConfigurationTag() {
        return this.myConfigurationTag;
    }

    @NotNull
    public ServletMappingInfo getServletMappingInfo() {
        ServletMappingInfo servletMappingInfo = this.myMappingInfo;
        if (servletMappingInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/StrutsModelImpl", "getServletMappingInfo"));
        }
        return servletMappingInfo;
    }

    @NotNull
    public List<Action> getActions() {
        List list = ((StrutsConfig)this.getMergedModel()).getActionMappings().getActions();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/StrutsModelImpl", "getActions"));
        }
        return list;
    }

    @Nullable
    public Action findAction(@NotNull String actionPath) {
        if (actionPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionPath", "com/intellij/struts/StrutsModelImpl", "findAction"));
        }
        return (Action)DomUtil.findByName(this.getActions(), (String)actionPath);
    }

    @Nullable
    public Action resolveActionURL(String actionURL) {
        String actionPath = this.getActionName(actionURL);
        return actionPath == null ? this.findAction(actionURL) : this.findAction(actionPath);
    }

    @Nullable
    public String getActionName(String url) {
        ServletMappingInfo info = this.getServletMappingInfo();
        String trimmedUrl = WebUtil.trimURL((String)url);
        return info.stripMapping(trimmedUrl);
    }

    @NotNull
    public List<FormBean> getFormBeans() {
        List list = ((StrutsConfig)this.getMergedModel()).getFormBeans().getFormBeans();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/StrutsModelImpl", "getFormBeans"));
        }
        return list;
    }

    @Nullable
    public FormBean findFormBean(String formBeanName) {
        return (FormBean)DomUtil.findByName(this.getFormBeans(), (String)formBeanName);
    }

    @NotNull
    public List<Forward> getGlobalForwards() {
        List list = ((StrutsConfig)this.getMergedModel()).getGlobalForwards().getForwards();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/StrutsModelImpl", "getGlobalForwards"));
        }
        return list;
    }

    @Nullable
    public Forward findForward(String forwardName) {
        return (Forward)DomUtil.findByName(this.getGlobalForwards(), (String)forwardName);
    }

    public boolean isInputForward() {
        return false;
    }

    @NotNull
    public CommonServlet getActionServlet() {
        CommonServlet commonServlet = this.myActionServlet;
        if (commonServlet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/StrutsModelImpl", "getActionServlet"));
        }
        return commonServlet;
    }

    @NotNull
    public PsiBeanProperty[] getFormProperties(@NotNull FormBean form) {
        if (form == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "form", "com/intellij/struts/StrutsModelImpl", "getFormProperties"));
        }
        PsiClass type = (PsiClass)form.getType().getValue();
        if (type != null) {
            if (PsiClassUtil.isSuper(type, "org.apache.struts.action.DynaActionForm")) {
                List tags = form.getFormProperties();
                ArrayList props = new ArrayList();
                for (FormProperty tag : tags) {
                    PsiBeanProperty prop = PsiBeanPropertyImpl.create(tag);
                    ContainerUtil.addIfNotNull(props, (Object)prop);
                }
                PsiBeanProperty[] psiBeanPropertyArray = props.toArray(new PsiBeanProperty[props.size()]);
                if (psiBeanPropertyArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/StrutsModelImpl", "getFormProperties"));
                }
                return psiBeanPropertyArray;
            }
            PsiBeanProperty[] psiBeanPropertyArray = PsiBeanPropertyCache.getInstance(type.getProject()).getBeanProperties(type);
            if (psiBeanPropertyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/StrutsModelImpl", "getFormProperties"));
            }
            return psiBeanPropertyArray;
        }
        if (PsiBeanProperty.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/StrutsModelImpl", "getFormProperties"));
        }
        return PsiBeanProperty.EMPTY_ARRAY;
    }
}

