/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference.property;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.core.PsiBeanProperty;
import com.intellij.struts.core.PsiBeanPropertyImpl;
import com.intellij.struts.inplace.reference.property.PropertyReference;
import com.intellij.struts.inplace.reference.property.PropertyReferenceProvider;
import com.intellij.struts.inplace.reference.property.PropertyReferenceSet;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SetPropertyReferenceProvider
extends PropertyReferenceProvider {
    private static final PsiBeanProperty[] TILES_PROPS = new PsiBeanProperty[]{new PsiBeanPropertyImpl("definitions-config", "String"), new PsiBeanPropertyImpl("definitions-parser-validate", "boolean"), new PsiBeanPropertyImpl("definitions-factory-class", "String"), new PsiBeanPropertyImpl("definitions-parser-details", "String"), new PsiBeanPropertyImpl("definitions-debug", "String")};
    @NonNls
    private static final String TILES_PLUGIN = "org.apache.struts.tiles.TilesPlugin";
    private final String myClassNameAttribute;
    private final String myFolderAttribute;

    public SetPropertyReferenceProvider(@NonNls String classNameAttribute, @NonNls String folderAttribute) {
        super(null, null);
        this.myClassNameAttribute = classNameAttribute;
        this.myFolderAttribute = folderAttribute;
    }

    @NonNls
    protected String getClassNameAttribute(XmlTag tag) {
        return this.myClassNameAttribute;
    }

    @Override
    protected PropertyReference createReference(PropertyReferenceSet set, int index, TextRange range) {
        return new PropertyReference(set, index, range, this){
            {
                this.mySoft = true;
            }

            @Override
            @NotNull
            protected PsiBeanProperty[] getPropertiesForTag(boolean forVariants) {
                XmlTag element;
                Object[] result = PsiBeanProperty.EMPTY_ARRAY;
                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myValue, XmlTag.class);
                if (tag != null && (element = tag.getParentTag()) != null) {
                    String className = element.getAttributeValue(SetPropertyReferenceProvider.this.getClassNameAttribute(element));
                    if (className == null) {
                        XmlTag folder;
                        if (SetPropertyReferenceProvider.this.myFolderAttribute != null && (folder = element.getParentTag()) != null) {
                            className = folder.getAttributeValue(SetPropertyReferenceProvider.this.myFolderAttribute);
                        }
                        if (className == null) {
                            className = StrutsManager.getInstance().getDefaultClassname(SetPropertyReferenceProvider.this.myClassNameAttribute, element);
                        }
                    }
                    if (className != null) {
                        result = this.getProperties(className);
                        if (result == null || result.length == 0) {
                            result = this.getProperties(className);
                        }
                        if (className.equals(SetPropertyReferenceProvider.TILES_PLUGIN)) {
                            result = (PsiBeanProperty[])ArrayUtil.mergeArrays((Object[])result, (Object[])TILES_PROPS);
                        }
                    }
                }
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/property/SetPropertyReferenceProvider$1", "getPropertiesForTag"));
                }
                return result;
            }
        };
    }
}

