/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.dom.impl.PluginFieldNameConverter;

public class AddWithTagFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        if ("Add <with> tag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/AddWithTagFix", "getFamilyName"));
        }
        return "Add <with> tag";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/quickfix/AddWithTagFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/devkit/inspections/quickfix/AddWithTagFix", "applyFix"));
        }
        DomElement element = DomUtil.getDomElement((PsiElement)descriptor.getPsiElement());
        if (!(element instanceof ExtensionPoint)) {
            return;
        }
        ExtensionPoint extensionPoint = (ExtensionPoint)element;
        List<PsiField> fields = extensionPoint.collectMissingWithTags();
        XmlAttributeValue navTarget = null;
        for (PsiField field : fields) {
            With with = extensionPoint.addWith();
            String tagName = PluginFieldNameConverter.getAnnotationValue(field, Tag.class);
            if (tagName != null) {
                with.getTag().setStringValue(tagName);
            } else {
                String attributeName = PluginFieldNameConverter.getAttributeAnnotationValue(field);
                if (attributeName == null) {
                    attributeName = field.getName();
                }
                if (attributeName.equals("forClass")) continue;
                with.getAttribute().setStringValue(attributeName);
            }
            String epName = extensionPoint.getName().getStringValue();
            String className = "";
            if (epName != null) {
                int pos = epName.lastIndexOf(46);
                epName = StringUtil.capitalize((String)(pos >= 0 ? epName.substring(pos + 1) : epName));
                PsiClass[] classesByName = PsiShortNamesCache.getInstance((Project)project).getClassesByName(epName, ProjectScope.getAllScope((Project)project));
                if (classesByName.length == 1) {
                    className = classesByName[0].getQualifiedName();
                }
            }
            with.getImplements().setStringValue(className);
            if (navTarget != null) continue;
            navTarget = with.getImplements().getXmlAttributeValue();
        }
        if (navTarget != null) {
            PsiNavigateUtil.navigate(navTarget);
        }
    }
}

