/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.common.os.Platform;
import jogamp.common.os.PlatformPropsImpl;

public class MachineDataInfoRuntime {
    static volatile boolean initialized = false;
    static volatile MachineDataInfo runtimeMD = null;
    static volatile MachineDataInfo.StaticConfig staticMD = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize() {
        if (initialized) throw new InternalError("Already initialized");
        Class<MachineDataInfo> clazz = MachineDataInfo.class;
        synchronized (MachineDataInfo.class) {
            if (initialized) throw new InternalError("Already initialized");
            MachineDataInfo.StaticConfig.validateUniqueMachineDataInfo();
            MachineDataInfo machineDataInfo = MachineDataInfoRuntime.getRuntimeImpl();
            MachineDataInfo.StaticConfig staticConfig = MachineDataInfo.StaticConfig.findCompatible(machineDataInfo);
            if (null == staticConfig) {
                String string = PlatformPropsImpl.NEWLINE;
                String string2 = String.valueOf(machineDataInfo);
                throw new RuntimeException(new StringBuilder(55 + String.valueOf(string).length() + String.valueOf(string2).length()).append("No compatible MachineDataInfo.StaticConfig for runtime:").append(string).append(string2).toString());
            }
            if (!staticConfig.md.compatible(machineDataInfo)) {
                String string = PlatformPropsImpl.NEWLINE;
                String string3 = String.valueOf((Object)staticConfig);
                String string4 = PlatformPropsImpl.NEWLINE;
                String string5 = String.valueOf(machineDataInfo);
                throw new RuntimeException(new StringBuilder(46 + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("Incompatible MachineDataInfo:").append(string).append(" Static ").append(string3).append(string4).append(" Runtime ").append(string5).toString());
            }
            runtimeMD = machineDataInfo;
            staticMD = staticConfig;
            initialized = true;
            if (!PlatformPropsImpl.DEBUG) return;
            String string = PlatformPropsImpl.NEWLINE;
            String string6 = String.valueOf((Object)staticConfig);
            String string7 = PlatformPropsImpl.NEWLINE;
            String string8 = String.valueOf(machineDataInfo);
            System.err.println(new StringBuilder(53 + String.valueOf(string).length() + String.valueOf(string6).length() + String.valueOf(string7).length() + String.valueOf(string8).length()).append("MachineDataInfoRuntime.initialize():").append(string).append(" Static ").append(string6).append(string7).append(" Runtime ").append(string8).toString());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MachineDataInfo.StaticConfig getStatic() {
        if (initialized) return staticMD;
        Class<MachineDataInfo> clazz = MachineDataInfo.class;
        synchronized (MachineDataInfo.class) {
            if (initialized) return staticMD;
            throw new InternalError("Not set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MachineDataInfo getRuntime() {
        if (initialized) return runtimeMD;
        Class<MachineDataInfo> clazz = MachineDataInfo.class;
        synchronized (MachineDataInfo.class) {
            if (initialized) return runtimeMD;
            throw new InternalError("Not set");
        }
    }

    public static MachineDataInfo.StaticConfig guessStaticMachineDataInfo(Platform.OSType oSType, Platform.CPUType cPUType) {
        if (cPUType.is32Bit) {
            if (Platform.CPUFamily.ARM == cPUType.family || Platform.CPUType.MIPS_32 == cPUType) {
                return MachineDataInfo.StaticConfig.ARM_MIPS_32;
            }
            if (Platform.OSType.WINDOWS == oSType) {
                return MachineDataInfo.StaticConfig.X86_32_WINDOWS;
            }
            if (Platform.OSType.MACOS == oSType) {
                return MachineDataInfo.StaticConfig.X86_32_MACOS;
            }
            if (Platform.OSType.SUNOS == oSType && Platform.CPUType.SPARC_32 == cPUType) {
                return MachineDataInfo.StaticConfig.SPARC_32_SUNOS;
            }
            if (Platform.CPUType.PPC == cPUType) {
                return MachineDataInfo.StaticConfig.PPC_32_UNIX;
            }
            return MachineDataInfo.StaticConfig.X86_32_UNIX;
        }
        if (oSType == Platform.OSType.WINDOWS) {
            return MachineDataInfo.StaticConfig.X86_64_WINDOWS;
        }
        return MachineDataInfo.StaticConfig.LP64_UNIX;
    }

    private static MachineDataInfo getRuntimeImpl() {
        try {
            Platform.initSingleton();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return null;
        }
        int n = MachineDataInfoRuntime.getPointerSizeInBytesImpl();
        switch (n) {
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new RuntimeException(new StringBuilder(60).append("Unsupported pointer size ").append(n).append("bytes, please implement.").toString());
            }
        }
        long l = MachineDataInfoRuntime.getPageSizeInBytesImpl();
        if (Integer.MAX_VALUE < l) {
            throw new InternalError(new StringBuilder(52).append("PageSize exceeds integer value: ").append(l).toString());
        }
        return new MachineDataInfo(true, MachineDataInfoRuntime.getSizeOfIntImpl(), MachineDataInfoRuntime.getSizeOfLongImpl(), MachineDataInfoRuntime.getSizeOfFloatImpl(), MachineDataInfoRuntime.getSizeOfDoubleImpl(), MachineDataInfoRuntime.getSizeOfLongDoubleImpl(), n, (int)l, MachineDataInfoRuntime.getAlignmentInt8Impl(), MachineDataInfoRuntime.getAlignmentInt16Impl(), MachineDataInfoRuntime.getAlignmentInt32Impl(), MachineDataInfoRuntime.getAlignmentInt64Impl(), MachineDataInfoRuntime.getAlignmentIntImpl(), MachineDataInfoRuntime.getAlignmentLongImpl(), MachineDataInfoRuntime.getAlignmentFloatImpl(), MachineDataInfoRuntime.getAlignmentDoubleImpl(), MachineDataInfoRuntime.getAlignmentLongDoubleImpl(), MachineDataInfoRuntime.getAlignmentPointerImpl());
    }

    private static native int getPointerSizeInBytesImpl();

    private static native long getPageSizeInBytesImpl();

    private static native int getAlignmentInt8Impl();

    private static native int getAlignmentInt16Impl();

    private static native int getAlignmentInt32Impl();

    private static native int getAlignmentInt64Impl();

    private static native int getAlignmentIntImpl();

    private static native int getAlignmentLongImpl();

    private static native int getAlignmentPointerImpl();

    private static native int getAlignmentFloatImpl();

    private static native int getAlignmentDoubleImpl();

    private static native int getAlignmentLongDoubleImpl();

    private static native int getSizeOfIntImpl();

    private static native int getSizeOfLongImpl();

    private static native int getSizeOfPointerImpl();

    private static native int getSizeOfFloatImpl();

    private static native int getSizeOfDoubleImpl();

    private static native int getSizeOfLongDoubleImpl();
}

