/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.TransformationMethodVisitor;
import org.jetbrains.kotlin.codegen.optimization.CapturedVarsOptimizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.ConstantConditionEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.DeadCodeEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.FixStackWithLabelNormalizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantCheckCastEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantGotoMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantNopsCleanupMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.FastPopBackwardPropagationTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.PopBackwardPropagationTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxingMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.RedundantNullCheckMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.transformer.CompositeMethodTransformer;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor;", "Lorg/jetbrains/kotlin/codegen/TransformationMethodVisitor;", "delegate", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "disableOptimization", "", "access", "", "name", "", "desc", "signature", "exceptions", "", "(Lorg/jetbrains/org/objectweb/asm/MethodVisitor;ZILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "performTransformations", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "Companion", "backend"})
public final class OptimizationMethodVisitor
extends TransformationMethodVisitor {
    private final boolean disableOptimization;
    private static final int MEMORY_LIMIT_BY_METHOD_MB = 50;
    private static final FixStackWithLabelNormalizationMethodTransformer MANDATORY_METHOD_TRANSFORMER;
    private static final CompositeMethodTransformer OPTIMIZATION_TRANSFORMER;
    public static final Companion Companion;

    @Override
    protected void performTransformations(@NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        OptimizationMethodVisitor.Companion.getMANDATORY_METHOD_TRANSFORMER().transform("fake", methodNode);
        if (Companion.canBeOptimized(methodNode) && !this.disableOptimization) {
            OptimizationMethodVisitor.Companion.getOPTIMIZATION_TRANSFORMER().transform("fake", methodNode);
        }
        UtilKt.prepareForEmitting(methodNode);
    }

    public OptimizationMethodVisitor(@NotNull MethodVisitor delegate2, boolean disableOptimization, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        Intrinsics.checkParameterIsNotNull((Object)delegate2, (String)"delegate");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        super(delegate2, access, name2, desc, signature, exceptions);
        this.disableOptimization = disableOptimization;
    }

    static {
        Companion = new Companion(null);
        MEMORY_LIMIT_BY_METHOD_MB = 50;
        MANDATORY_METHOD_TRANSFORMER = new FixStackWithLabelNormalizationMethodTransformer();
        OPTIMIZATION_TRANSFORMER = new CompositeMethodTransformer(new CapturedVarsOptimizationMethodTransformer(), new RedundantNullCheckMethodTransformer(), new RedundantCheckCastEliminationMethodTransformer(), new ConstantConditionEliminationMethodTransformer(), new RedundantBoxingMethodTransformer(), new FastPopBackwardPropagationTransformer(), new PopBackwardPropagationTransformer(), new DeadCodeEliminationMethodTransformer(), new RedundantGotoMethodTransformer(), new RedundantNopsCleanupMethodTransformer());
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor$Companion;", "", "()V", "MANDATORY_METHOD_TRANSFORMER", "Lorg/jetbrains/kotlin/codegen/optimization/FixStackWithLabelNormalizationMethodTransformer;", "getMANDATORY_METHOD_TRANSFORMER", "()Lorg/jetbrains/kotlin/codegen/optimization/FixStackWithLabelNormalizationMethodTransformer;", "MEMORY_LIMIT_BY_METHOD_MB", "", "getMEMORY_LIMIT_BY_METHOD_MB", "()I", "OPTIMIZATION_TRANSFORMER", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/CompositeMethodTransformer;", "getOPTIMIZATION_TRANSFORMER", "()Lorg/jetbrains/kotlin/codegen/optimization/transformer/CompositeMethodTransformer;", "canBeOptimized", "", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "canBeOptimizedUsingSourceInterpreter", "backend"})
    public static final class Companion {
        private final int getMEMORY_LIMIT_BY_METHOD_MB() {
            return MEMORY_LIMIT_BY_METHOD_MB;
        }

        private final FixStackWithLabelNormalizationMethodTransformer getMANDATORY_METHOD_TRANSFORMER() {
            return MANDATORY_METHOD_TRANSFORMER;
        }

        private final CompositeMethodTransformer getOPTIMIZATION_TRANSFORMER() {
            return OPTIMIZATION_TRANSFORMER;
        }

        public final boolean canBeOptimized(@NotNull MethodNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            int totalFramesSizeMb = node.instructions.size() * (node.maxLocals + node.maxStack) / 0x100000;
            return totalFramesSizeMb < this.getMEMORY_LIMIT_BY_METHOD_MB();
        }

        public final boolean canBeOptimizedUsingSourceInterpreter(@NotNull MethodNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            int frameSize = node.maxLocals + node.maxStack;
            long methodSize = node.instructions.size();
            long totalFramesSizeMb = methodSize * methodSize * (long)frameSize / (long)0x100000;
            return totalFramesSizeMb < (long)this.getMEMORY_LIMIT_BY_METHOD_MB();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

