/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointFiltersPanel;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpoint;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpointPropertiesPanel;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinPropertyBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.breakpoints.dialog.AddFieldBreakpointDialog;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u001a\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0006\u0018\u00010\u001bH\u0016J\u001e\u0010\u001c\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0006\u0018\u00010\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\"\u001a\n $*\u0004\u0018\u00010#0#H\u0016J\u0018\u0010%\u001a\u0004\u0018\u00010\u00172\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\n\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0010\u0010(\u001a\n $*\u0004\u0018\u00010#0#H\u0016J\u0010\u0010)\u001a\n $*\u0004\u0018\u00010#0#H\u0016J\u0010\u0010*\u001a\n $*\u0004\u0018\u00010#0#H\u0016J\b\u0010+\u001a\u00020\u0011H\u0016J\u0018\u0010,\u001a\u0004\u0018\u00010\u00172\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\b\u0010-\u001a\u00020\fH\u0016J\b\u0010.\u001a\u00020\fH\u0016J\u0018\u0010/\u001a\u0002002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00101\u001a\u00020\u0017H\u0002\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpointType;", "Lcom/intellij/debugger/ui/breakpoints/JavaBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinPropertyBreakpointProperties;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "()V", "addBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljavax/swing/JComponent;", "canBeHitInOtherPlaces", "", "canPutAt", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "createBreakpointIfPropertyExists", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "Lorg/jetbrains/kotlin/psi/KtFile;", "className", "", "fieldName", "createBreakpointProperties", "createCustomPropertiesPanel", "Lcom/intellij/xdebugger/breakpoints/ui/XBreakpointCustomPropertiesPanel;", "createCustomRightPropertiesPanel", "createJavaBreakpoint", "Lcom/intellij/debugger/ui/breakpoints/Breakpoint;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "createProperties", "getDisabledIcon", "Ljavax/swing/Icon;", "kotlin.jvm.PlatformType", "getDisplayText", "getEditorsProvider", "", "getEnabledIcon", "getMutedDisabledIcon", "getMutedEnabledIcon", "getPriority", "getShortText", "isAddBreakpointButtonVisible", "isSuspendThreadSupported", "reportError", "", "message", "idea"})
public final class KotlinFieldBreakpointType
extends XLineBreakpointType<KotlinPropertyBreakpointProperties>
implements JavaBreakpointType<KotlinPropertyBreakpointProperties> {
    @NotNull
    public Breakpoint<KotlinPropertyBreakpointProperties> createJavaBreakpoint(@NotNull Project project, @NotNull XBreakpoint<KotlinPropertyBreakpointProperties> breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        return (Breakpoint)new KotlinFieldBreakpoint(project, breakpoint);
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return BreakpointTypeUtilsKt.canPutAt(file2, line, project, ((Object)((Object)this)).getClass());
    }

    public int getPriority() {
        return 120;
    }

    @Nullable
    public KotlinPropertyBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file2, int line) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return new KotlinPropertyBreakpointProperties(null, null, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public XLineBreakpoint<KotlinPropertyBreakpointProperties> addBreakpoint(@NotNull Project project, @Nullable JComponent parentComponent) {
        void result2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        AddFieldBreakpointDialog dialog2 = new AddFieldBreakpointDialog(this, project, (Ref.ObjectRef)result2, project){
            final /* synthetic */ KotlinFieldBreakpointType this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Ref.ObjectRef $result;

            protected boolean validateData() {
                Object object;
                String className2 = this.getClassName();
                CharSequence charSequence = className2;
                if (charSequence.length() == 0) {
                    String string = DebuggerBundle.message((String)"error.field.breakpoint.class.name.not.specified", (Object[])new Object[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DebuggerBundle.message(\"\u2026lass.name.not.specified\")");
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, string);
                    return false;
                }
                PsiClass psiClass2 = JavaPsiFacade.getInstance((Project)this.$project).findClass(className2, GlobalSearchScope.allScope((Project)this.$project));
                if (!(psiClass2 instanceof KtLightClass)) {
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, "Couldn't find '" + className2 + "' class");
                    return false;
                }
                String fieldName = this.getFieldName();
                CharSequence charSequence2 = fieldName;
                if (charSequence2.length() == 0) {
                    String string = DebuggerBundle.message((String)"error.field.breakpoint.field.name.not.specified", (Object[])new Object[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DebuggerBundle.message(\"\u2026ield.name.not.specified\")");
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, string);
                    return false;
                }
                charSequence2 = psiClass2;
                if (charSequence2 instanceof KtLightClassForFacade) {
                    object = (XLineBreakpoint)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((KtLightClassForFacade)psiClass2).getFiles()), (Function1)((Function1)new Function1<KtFile, XLineBreakpoint<KotlinPropertyBreakpointProperties>>(this, className2, fieldName){
                        final /* synthetic */ addBreakpoint.dialog.1 this$0;
                        final /* synthetic */ String $className;
                        final /* synthetic */ String $fieldName;

                        @Nullable
                        public final XLineBreakpoint<KotlinPropertyBreakpointProperties> invoke(@NotNull KtFile it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            KotlinFieldBreakpointType kotlinFieldBreakpointType = this.this$0.this$0;
                            KtDeclarationContainer ktDeclarationContainer = it;
                            String string = this.$className;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className");
                            String string2 = this.$fieldName;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fieldName");
                            return KotlinFieldBreakpointType.access$createBreakpointIfPropertyExists(kotlinFieldBreakpointType, ktDeclarationContainer, it, string, string2);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$className = string;
                            this.$fieldName = string2;
                            super(1);
                        }
                    })));
                } else if (charSequence2 instanceof KtLightClassForSourceDeclaration) {
                    KtClassOrObject jetClass = ((KtLightClassForSourceDeclaration)psiClass2).getKotlinOrigin();
                    KtDeclarationContainer ktDeclarationContainer = jetClass;
                    KtFile ktFile = jetClass.getContainingKtFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"jetClass.containingKtFile");
                    String string = className2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className");
                    String string2 = fieldName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fieldName");
                    object = KotlinFieldBreakpointType.access$createBreakpointIfPropertyExists(this.this$0, ktDeclarationContainer, ktFile, string, string2);
                } else {
                    object = this.$result.element = null;
                }
                if ((XLineBreakpoint)this.$result.element == null) {
                    String string = DebuggerBundle.message((String)"error.field.breakpoint.field.not.found", (Object[])new Object[]{className2, fieldName, fieldName});
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DebuggerBundle.message(\"\u2026me, fieldName, fieldName)");
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, string);
                }
                return (XLineBreakpoint)this.$result.element != null;
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
                this.$result = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
        dialog2.show();
        return (XLineBreakpoint)result2.element;
    }

    private final XLineBreakpoint<KotlinPropertyBreakpointProperties> createBreakpointIfPropertyExists(KtDeclarationContainer declaration2, KtFile file2, String className2, String fieldName) {
        Object v0;
        Project project;
        block3: {
            project = file2.getProject();
            Iterable $receiver$iv = declaration2.getDeclarations();
            for (Object element$iv : $receiver$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                if (!(it instanceof KtProperty && Intrinsics.areEqual((Object)((KtProperty)it).getName(), (Object)fieldName))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        KtDeclaration ktDeclaration = v0;
        if (ktDeclaration == null) {
            return null;
        }
        KtDeclaration property2 = ktDeclaration;
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        int line = document2.getLineNumber(property2.getTextOffset());
        return (XLineBreakpoint)ApplicationUtilsKt.runWriteAction((Function0)new Function0<XLineBreakpoint<KotlinPropertyBreakpointProperties>>(this, project, file2, line, fieldName, className2){
            final /* synthetic */ KotlinFieldBreakpointType this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ int $line;
            final /* synthetic */ String $fieldName;
            final /* synthetic */ String $className;

            @NotNull
            public final XLineBreakpoint<KotlinPropertyBreakpointProperties> invoke() {
                return XDebuggerManager.getInstance((Project)this.$project).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)this.this$0, this.$file.getVirtualFile().getUrl(), this.$line, (XBreakpointProperties)new KotlinPropertyBreakpointProperties(this.$fieldName, this.$className));
            }
            {
                this.this$0 = kotlinFieldBreakpointType;
                this.$project = project;
                this.$file = ktFile;
                this.$line = n;
                this.$fieldName = string;
                this.$className = string2;
                super(0);
            }
        });
    }

    private final void reportError(Project project, String message2) {
        Messages.showMessageDialog((Project)project, (String)message2, (String)DebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    public Icon getMutedEnabledIcon() {
        return AllIcons.Debugger.Db_muted_field_breakpoint;
    }

    public Icon getDisabledIcon() {
        return AllIcons.Debugger.Db_disabled_field_breakpoint;
    }

    public Icon getEnabledIcon() {
        return AllIcons.Debugger.Db_field_breakpoint;
    }

    public Icon getMutedDisabledIcon() {
        return AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    @Nullable
    public String getShortText(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        KotlinPropertyBreakpointProperties properties2 = (KotlinPropertyBreakpointProperties)breakpoint.getProperties();
        String className2 = properties2.getMyClassName();
        CharSequence charSequence = className2;
        return !(charSequence.length() == 0) ? className2 + "." + properties2.getMyFieldName() : properties2.getMyFieldName();
    }

    @Nullable
    public KotlinPropertyBreakpointProperties createProperties() {
        return new KotlinPropertyBreakpointProperties(null, null, 3, null);
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<KotlinPropertyBreakpointProperties>> createCustomPropertiesPanel() {
        return new KotlinFieldBreakpointPropertiesPanel();
    }

    @Nullable
    public String getDisplayText(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint) {
        BreakpointWithHighlighter kotlinBreakpoint;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Breakpoint breakpoint2 = BreakpointManager.getJavaBreakpoint((XBreakpoint)((XBreakpoint)breakpoint));
        if (!(breakpoint2 instanceof BreakpointWithHighlighter)) {
            breakpoint2 = null;
        }
        if ((kotlinBreakpoint = (BreakpointWithHighlighter)breakpoint2) != null) {
            return kotlinBreakpoint.getDescription();
        }
        return super.getDisplayText(breakpoint);
    }

    @Nullable
    public Void getEditorsProvider() {
        return null;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<KotlinPropertyBreakpointProperties>> createCustomRightPropertiesPanel(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return new KotlinBreakpointFiltersPanel(project);
    }

    public boolean isSuspendThreadSupported() {
        return true;
    }

    public KotlinFieldBreakpointType() {
        super("kotlin-field", KotlinBundle.message("debugger.field.watchpoints.tab.title", new Object[0]));
    }

    public static final /* synthetic */ void access$reportError(KotlinFieldBreakpointType $this, @NotNull Project project, @NotNull String message2) {
        $this.reportError(project, message2);
    }

    @Nullable
    public static final /* synthetic */ XLineBreakpoint access$createBreakpointIfPropertyExists(KotlinFieldBreakpointType $this, @NotNull KtDeclarationContainer declaration2, @NotNull KtFile file2, @NotNull String className2, @NotNull String fieldName) {
        return $this.createBreakpointIfPropertyExists(declaration2, file2, className2, fieldName);
    }
}

