/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.GutterIconTooltipHelper;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.asJava.elements.KtLightMethodImplKt;
import org.jetbrains.kotlin.idea.highlighter.markers.JavaPsiUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.markers.NavigationPopupDescriptor;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridingMethodsUpdater;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a6\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007H\u0000\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"buildNavigateToOverriddenMethodPopup", "Lorg/jetbrains/kotlin/idea/highlighter/markers/NavigationPopupDescriptor;", "e", "Ljava/awt/event/MouseEvent;", "element", "Lcom/intellij/psi/PsiElement;", "getOverriddenDeclarations", "", "T", "mappingToJava", "", "Lcom/intellij/psi/PsiMethod;", "classes", "Lcom/intellij/psi/PsiClass;", "getOverriddenMethodTooltip", "", "method", "isMethodWithDeclarationInOtherClass", "", "idea"})
public final class OverridenFunctionMarkerKt {
    private static final boolean isMethodWithDeclarationInOtherClass(@NotNull PsiMethod $receiver) {
        return $receiver instanceof KtLightMethod && KtLightMethodImplKt.isTraitFakeOverride((KtLightMethod)$receiver);
    }

    @NotNull
    public static final <T> Set<T> getOverriddenDeclarations(@NotNull Map<PsiMethod, T> mappingToJava, @NotNull Set<? extends PsiClass> classes2) {
        Intrinsics.checkParameterIsNotNull(mappingToJava, (String)"mappingToJava");
        Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
        HashSet overridden = new HashSet();
        for (PsiClass psiClass2 : classes2) {
            AllOverridingMethodsSearch.search((PsiClass)psiClass2).forEach((Processor)new Processor<Pair<PsiMethod, PsiMethod>>(mappingToJava, overridden){
                final /* synthetic */ Map $mappingToJava;
                final /* synthetic */ HashSet $overridden;

                public boolean process(@Nullable Pair<PsiMethod, PsiMethod> pair2) {
                    PsiMethod superMethod;
                    V declaration2;
                    ProgressManager.checkCanceled();
                    Pair<PsiMethod, PsiMethod> pair3 = pair2;
                    if (pair3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!OverridenFunctionMarkerKt.access$isMethodWithDeclarationInOtherClass((PsiMethod)pair3.getSecond()) && (declaration2 = this.$mappingToJava.get(superMethod = (PsiMethod)pair2.getFirst())) != null) {
                        this.$mappingToJava.remove(superMethod);
                        this.$overridden.add(declaration2);
                    }
                    return !this.$mappingToJava.isEmpty();
                }
                {
                    this.$mappingToJava = $captured_local_variable$0;
                    this.$overridden = $captured_local_variable$1;
                }
            });
        }
        return overridden;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getOverriddenMethodTooltip(@NotNull PsiMethod method) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(5);
        OverridingMethodsSearch.search((PsiMethod)method, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor2));
        boolean isAbstract = method.hasModifierProperty("abstract");
        if (processor2.isOverflow()) {
            return isAbstract ? DaemonBundle.message((String)"method.is.implemented.too.many", (Object[])new Object[0]) : DaemonBundle.message((String)"method.is.overridden.too.many", (Object[])new Object[0]);
        }
        Comparator comparator = new MethodCellRenderer(false).getComparator();
        Iterable iterable = $receiver$iv = (Iterable)processor2.getCollection();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiMethod it = (PsiMethod)element$iv$iv;
            if (!(!OverridenFunctionMarkerKt.isMethodWithDeclarationInOtherClass(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        Comparator comparator2 = comparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator2, (String)"comparator");
        List overridingJavaMethods = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator2);
        if (overridingJavaMethods.isEmpty()) {
            return null;
        }
        String start = isAbstract ? DaemonBundle.message((String)"method.is.implemented.header", (Object[])new Object[0]) : DaemonBundle.message((String)"method.is.overriden.header", (Object[])new Object[0]);
        return GutterIconTooltipHelper.composeText((Iterable)overridingJavaMethods, (String)start, (String)"&nbsp;&nbsp;&nbsp;&nbsp;{1}");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final NavigationPopupDescriptor buildNavigateToOverriddenMethodPopup(@Nullable MouseEvent e, @Nullable PsiElement element2) {
        Collection $receiver$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv2;
        PsiMethod psiMethod2 = JavaPsiUtilsKt.getPsiMethod(element2);
        if (psiMethod2 == null) {
            return null;
        }
        PsiMethod method = psiMethod2;
        if (DumbService.isDumb((Project)method.getProject())) {
            DumbService dumbService = DumbService.getInstance((Project)method.getProject());
            if (dumbService != null) {
                dumbService.showDumbModeNotification("Navigation to overriding classes is not possible during index update");
            }
            return null;
        }
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(2, (Collection)new THashSet());
        MouseEvent mouseEvent = e;
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(method, processor2){
            final /* synthetic */ PsiMethod $method;
            final /* synthetic */ PsiElementProcessor.CollectElementsWithLimit $processor;

            public final void run() {
                OverridingMethodsSearch.search((PsiMethod)this.$method, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)this.$processor));
            }
            {
                this.$method = psiMethod2;
                this.$processor = collectElementsWithLimit;
            }
        }, "Searching for overriding declarations", true, method.getProject(), (JComponent)(mouseEvent != null ? mouseEvent.getComponent() : null))) {
            return null;
        }
        Iterable iterable = $receiver$iv2 = (Iterable)processor2.getCollection();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiMethod it = (PsiMethod)element$iv$iv;
            if (!(!OverridenFunctionMarkerKt.isMethodWithDeclarationInOtherClass(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List overridingJavaMethods = (List)destination$iv$iv;
        if (overridingJavaMethods.isEmpty()) {
            return null;
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)overridingJavaMethods;
        PsiMethod[] psiMethodArray = thisCollection$iv.toArray(new PsiMethod[thisCollection$iv.size()]);
        if (psiMethodArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])psiMethodArray);
        MethodCellRenderer renderer2 = new MethodCellRenderer(showMethodNames);
        Iterable iterable2 = overridingJavaMethods;
        Comparator comparator = renderer2.getComparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator, (String)"renderer.comparator");
        overridingJavaMethods = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator);
        OverridingMethodsUpdater methodsUpdater = new OverridingMethodsUpdater(method, (PsiElementListCellRenderer<? extends PsiElement>)((PsiElementListCellRenderer)renderer2));
        return new NavigationPopupDescriptor(overridingJavaMethods, methodsUpdater.getCaption(overridingJavaMethods.size()), "Overriding declarations of " + method.getName(), (ListCellRenderer)renderer2, methodsUpdater);
    }

    public static final /* synthetic */ boolean access$isMethodWithDeclarationInOtherClass(@NotNull PsiMethod $receiver) {
        return OverridenFunctionMarkerKt.isMethodWithDeclarationInOtherClass($receiver);
    }
}

