/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/NullableBooleanEqualityCheckToElvisIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicable", "", "lhs", "Lorg/jetbrains/kotlin/psi/KtExpression;", "rhs", "isApplicableTo", "caretOffset", "", "idea"})
public final class NullableBooleanEqualityCheckToElvisIntention
extends SelfTargetingIntention<KtBinaryExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (Intrinsics.areEqual((Object)element2.getOperationToken(), (Object)((Object)KtTokens.EQEQ)) ^ true && Intrinsics.areEqual((Object)element2.getOperationToken(), (Object)((Object)KtTokens.EXCLEQ)) ^ true) {
            return false;
        }
        KtExpression ktExpression = element2.getLeft();
        if (ktExpression == null) {
            return false;
        }
        KtExpression lhs = ktExpression;
        KtExpression ktExpression2 = element2.getRight();
        if (ktExpression2 == null) {
            return false;
        }
        KtExpression rhs = ktExpression2;
        KtExpression ktExpression3 = lhs;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"lhs");
        KtExpression ktExpression4 = rhs;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"rhs");
        return this.isApplicable(ktExpression3, ktExpression4) || this.isApplicable(rhs, lhs);
    }

    private final boolean isApplicable(KtExpression lhs, KtExpression rhs) {
        if (!KtPsiUtil.isBooleanConstant(rhs)) {
            return false;
        }
        KotlinType kotlinType = ResolutionUtils.analyze(lhs, BodyResolveMode.PARTIAL).getType(lhs);
        if (kotlinType == null) {
            return false;
        }
        KotlinType lhsType = kotlinType;
        return TypeUtils.isNullableType(lhsType) && TypeUtilsKt.isBooleanOrNullableBoolean(lhsType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtBinaryExpression element2, @Nullable Editor editor) {
        Object object;
        void $receiver$iv;
        boolean bl;
        KtConstantExpression ktConstantExpression;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        boolean equality = Intrinsics.areEqual((Object)element2.getOperationToken(), (Object)((Object)KtTokens.EQEQ));
        KtExpression ktExpression = element2.getLeft();
        if (!(ktExpression instanceof KtConstantExpression)) {
            ktExpression = null;
        }
        if ((ktConstantExpression = (KtConstantExpression)ktExpression) == null) {
            KtExpression ktExpression2 = element2.getRight();
            if (!(ktExpression2 instanceof KtConstantExpression)) {
                ktExpression2 = null;
            }
            ktConstantExpression = (KtConstantExpression)ktExpression2;
        }
        if (ktConstantExpression == null) {
            return;
        }
        KtConstantExpression constPart = ktConstantExpression;
        KtExpression ktExpression3 = Intrinsics.areEqual((Object)element2.getRight(), (Object)constPart) ? element2.getLeft() : element2.getRight();
        if (ktExpression3 == null) {
            return;
        }
        KtExpression exprPart = ktExpression3;
        if (KtPsiUtil.isTrueConstant(constPart)) {
            bl = true;
        } else if (KtPsiUtil.isFalseConstant(constPart)) {
            bl = false;
        } else {
            return;
        }
        boolean constValue = bl;
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)constPart, false, 2, null);
        String string = "$0 ?: " + !constValue;
        Object[] objectArray = new Object[1];
        KtExpression ktExpression4 = exprPart;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"exprPart");
        objectArray[0] = ktExpression4;
        KtExpression elvis2 = CreateByPatternKt.createExpressionByPattern$default(factory2, string, objectArray, false, 4, null);
        PsiElement psiElement2 = (PsiElement)element2;
        PsiElement newElement$iv = (PsiElement)(constValue == equality ? elvis2 : CreateByPatternKt.createExpressionByPattern$default(factory2, "!($0)", new Object[]{elvis2}, false, 4, null));
        PsiElement result$iv = $receiver$iv.replace(newElement$iv);
        if (result$iv instanceof KtExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            object = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
    }

    public NullableBooleanEqualityCheckToElvisIntention() {
        super(KtBinaryExpression.class, "Convert Boolean? == const to elvis", null, 4, null);
    }
}

