/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorWithInitializerImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.VariableTypeAndInitializerResolver;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J2\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J(\u0010!\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J/\u0010(\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b,J\u0014\u0010-\u001a\u00020\u0012*\u00020.2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;", "", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "variableTypeAndInitializerResolver", "Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver;", "delegatedPropertyResolver", "Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver;Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "initializeWithDefaultGetterSetter", "", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl;", "process", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "typingContext", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingFacade;", "resolveLocalVariableDescriptor", "variable", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "resolveLocalVariableDescriptorWithType", "Lorg/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolveLocalVariableDescriptorWithType$frontend", "updateAccessorFlagsFromResolvedCallForDelegatedProperty", "Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;", "frontend"})
public final class LocalVariableResolver {
    private final ModifiersChecker modifiersChecker;
    private final IdentifierChecker identifierChecker;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final AnnotationResolver annotationResolver;
    private final VariableTypeAndInitializerResolver variableTypeAndInitializerResolver;
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    private final LanguageVersionSettings languageVersionSettings;

    @NotNull
    public final Pair<KotlinTypeInfo, VariableDescriptor> process(@NotNull KtProperty property2, @NotNull ExpressionTypingContext typingContext, @NotNull LexicalScope scope2, @NotNull ExpressionTypingFacade facade) {
        KotlinTypeInfo typeInfo;
        KtExpression initializer2;
        KtPropertyAccessor setter;
        KtPropertyAccessor getter;
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)typingContext, (String)"typingContext");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)facade, (String)"facade");
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceScope(scope2);
        KtTypeReference receiverTypeRef = property2.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            context.trace.report(Errors.LOCAL_EXTENSION_PROPERTY.on((KtTypeReference)((PsiElement)receiverTypeRef)));
        }
        if ((getter = property2.getGetter()) != null) {
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter)));
        }
        if ((setter = property2.getSetter()) != null) {
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter)));
        }
        KtVariableDeclaration ktVariableDeclaration = property2;
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        VariableDescriptor propertyDescriptor = this.resolveLocalVariableDescriptor(scope2, ktVariableDeclaration, dataFlowInfo, bindingTrace);
        KtExpression delegateExpression = property2.getDelegateExpression();
        if (delegateExpression != null) {
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.LocalDelegatedProperties)) {
                BindingTrace bindingTrace2 = context.trace;
                KtPropertyDelegate ktPropertyDelegate = property2.getDelegate();
                if (ktPropertyDelegate == null) {
                    Intrinsics.throwNpe();
                }
                bindingTrace2.report(Errors.UNSUPPORTED_FEATURE.on((PsiElement)ktPropertyDelegate, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.LocalDelegatedProperties), (Object)this.languageVersionSettings)));
            }
            if (propertyDescriptor instanceof VariableDescriptorWithAccessors) {
                DataFlowInfo dataFlowInfo2 = typingContext.dataFlowInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo2, (String)"typingContext.dataFlowInfo");
                VariableDescriptorWithAccessors variableDescriptorWithAccessors = (VariableDescriptorWithAccessors)propertyDescriptor;
                LexicalScope lexicalScope = typingContext.scope;
                Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"typingContext.scope");
                BindingTrace bindingTrace3 = typingContext.trace;
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace3, (String)"typingContext.trace");
                this.delegatedPropertyResolver.resolvePropertyDelegate(dataFlowInfo2, property2, variableDescriptorWithAccessors, delegateExpression, lexicalScope, bindingTrace3);
                VariableAccessorDescriptor variableAccessorDescriptor = ((VariableDescriptorWithAccessors)propertyDescriptor).getGetter();
                if (variableAccessorDescriptor != null) {
                    BindingTrace bindingTrace4 = typingContext.trace;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace4, (String)"typingContext.trace");
                    this.updateAccessorFlagsFromResolvedCallForDelegatedProperty(variableAccessorDescriptor, bindingTrace4);
                }
                VariableAccessorDescriptor variableAccessorDescriptor2 = ((VariableDescriptorWithAccessors)propertyDescriptor).getSetter();
                if (variableAccessorDescriptor2 != null) {
                    BindingTrace bindingTrace5 = typingContext.trace;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace5, (String)"typingContext.trace");
                    this.updateAccessorFlagsFromResolvedCallForDelegatedProperty(variableAccessorDescriptor2, bindingTrace5);
                }
            }
        }
        if ((initializer2 = property2.getInitializer()) != null) {
            KotlinType outType = propertyDescriptor.getType();
            KotlinTypeInfo kotlinTypeInfo = facade.getTypeInfo(initializer2, (ExpressionTypingContext)context.replaceExpectedType(outType));
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinTypeInfo, (String)"facade.getTypeInfo(initi\u2026aceExpectedType(outType))");
            typeInfo = kotlinTypeInfo;
            DataFlowInfo dataFlowInfo3 = typeInfo.getDataFlowInfo();
            KotlinType type2 = typeInfo.getType();
            if (type2 != null) {
                ExpressionTypingContext expressionTypingContext = context;
                Intrinsics.checkExpressionValueIsNotNull((Object)expressionTypingContext, (String)"context");
                DataFlowValue initializerDataFlowValue = DataFlowValueFactory.createDataFlowValue(initializer2, type2, expressionTypingContext);
                if (!propertyDescriptor.isVar() && initializerDataFlowValue.getCanBeBound()) {
                    context.trace.record(BindingContext.BOUND_INITIALIZER_VALUE, propertyDescriptor, initializerDataFlowValue);
                }
                if (property2.getTypeReference() == null) {
                    BindingContext bindingContext2 = context.trace.getBindingContext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context.trace.bindingContext");
                    DataFlowValue variableDataFlowValue = DataFlowValueFactory.createDataFlowValueForProperty(property2, propertyDescriptor, bindingContext2, DescriptorUtils.getContainingModuleOrNull(scope2.getOwnerDescriptor()));
                    typeInfo = typeInfo.replaceDataFlowInfo(dataFlowInfo3.assign(variableDataFlowValue, initializerDataFlowValue, this.languageVersionSettings));
                }
            }
        } else {
            ExpressionTypingContext expressionTypingContext = context;
            Intrinsics.checkExpressionValueIsNotNull((Object)expressionTypingContext, (String)"context");
            typeInfo = TypeInfoFactoryKt.noTypeInfo(expressionTypingContext);
        }
        ExpressionTypingUtils.checkVariableShadowing(context.scope, context.trace, propertyDescriptor);
        this.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration(property2, propertyDescriptor);
        KtDeclaration ktDeclaration = property2;
        BindingTrace bindingTrace6 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace6, (String)"context.trace");
        this.identifierChecker.checkDeclaration(ktDeclaration, bindingTrace6);
        return new Pair((Object)typeInfo.replaceType(this.dataFlowAnalyzer.checkStatementType(property2, context)), (Object)propertyDescriptor);
    }

    private final VariableDescriptor resolveLocalVariableDescriptor(LexicalScope scope2, KtVariableDeclaration variable2, DataFlowInfo dataFlowInfo, BindingTrace trace) {
        VariableDescriptorWithInitializerImpl result2;
        KotlinType type2;
        DeclarationDescriptor containingDeclaration = scope2.getOwnerDescriptor();
        if (KtPsiUtil.isScriptDeclaration(variable2)) {
            PropertyDescriptorImpl propertyDescriptor;
            PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor = PropertyDescriptorImpl.create(containingDeclaration, this.annotationResolver.resolveAnnotationsWithArguments(scope2, variable2.getModifierList(), trace), Modality.FINAL, Visibilities.INTERNAL, variable2.isVar(), KtPsiUtil.safeName(variable2.getName()), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(variable2), false, false, false, false, false, variable2 instanceof KtProperty && ((KtProperty)variable2).hasDelegate());
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptorImpl, (String)"propertyDescriptor");
            type2 = this.variableTypeAndInitializerResolver.resolveType(propertyDescriptorImpl, scope2, variable2, dataFlowInfo, trace, true);
            DeclarationDescriptor declarationDescriptor = containingDeclaration;
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ScriptDescriptor");
            }
            ReceiverParameterDescriptor receiverParameter = ((ScriptDescriptor)declarationDescriptor).getThisAsReceiverParameter();
            propertyDescriptor.setType(type2, (List<? extends TypeParameterDescriptor>)CollectionsKt.emptyList(), receiverParameter, (KotlinType)null);
            this.initializeWithDefaultGetterSetter(propertyDescriptor);
            trace.record(BindingContext.VARIABLE, variable2, propertyDescriptor);
            result2 = propertyDescriptor;
        } else {
            LocalVariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptorWithType$frontend(scope2, variable2, null, trace);
            type2 = this.variableTypeAndInitializerResolver.resolveType(variableDescriptor, scope2, variable2, dataFlowInfo, trace, true);
            variableDescriptor.setOutType(type2);
            result2 = variableDescriptor;
        }
        this.variableTypeAndInitializerResolver.setConstantForVariableIfNeeded(result2, scope2, variable2, dataFlowInfo, type2, trace);
        ForceResolveUtil.forceResolveAllContents(type2.getAnnotations());
        return result2;
    }

    private final void initializeWithDefaultGetterSetter(PropertyDescriptorImpl propertyDescriptor) {
        PropertySetterDescriptor setter;
        PropertyGetterDescriptorImpl getter = propertyDescriptor.getGetter();
        if (getter == null && !Visibilities.isPrivate(propertyDescriptor.getVisibility())) {
            getter = DescriptorFactory.createDefaultGetter(propertyDescriptor, Annotations.Companion.getEMPTY());
            getter.initialize(propertyDescriptor.getType());
        }
        if ((setter = propertyDescriptor.getSetter()) == null && propertyDescriptor.isVar()) {
            setter = DescriptorFactory.createDefaultSetter(propertyDescriptor, Annotations.Companion.getEMPTY());
        }
        propertyDescriptor.initialize(getter, setter);
    }

    @NotNull
    public final LocalVariableDescriptor resolveLocalVariableDescriptorWithType$frontend(@NotNull LexicalScope scope2, @NotNull KtVariableDeclaration variable2, @Nullable KotlinType type2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)variable2, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        boolean hasDelegate = variable2 instanceof KtProperty && ((KtProperty)variable2).hasDelegate();
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope2.getOwnerDescriptor(), this.annotationResolver.resolveAnnotationsWithArguments(scope2, variable2.getModifierList(), trace), UnderscoreUtilKt.isSingleUnderscore(variable2) ? Name.special("<underscore local var>") : KtPsiUtil.safeName(variable2.getName()), type2, variable2.isVar(), hasDelegate, KotlinSourceElementKt.toSourceElement(variable2));
        trace.record(BindingContext.VARIABLE, variable2, variableDescriptor);
        return variableDescriptor;
    }

    private final void updateAccessorFlagsFromResolvedCallForDelegatedProperty(@NotNull VariableAccessorDescriptor $receiver, BindingTrace trace) {
        if ($receiver instanceof FunctionDescriptorImpl) {
            FunctionDescriptor resultingDescriptor;
            ResolvedCall resolvedCall2 = (ResolvedCall)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, $receiver);
            FunctionDescriptor functionDescriptor2 = resultingDescriptor = resolvedCall2 != null ? (FunctionDescriptor)resolvedCall2.getResultingDescriptor() : null;
            if (resultingDescriptor != null) {
                ((FunctionDescriptorImpl)((Object)$receiver)).setSuspend(resultingDescriptor.isSuspend());
            }
        }
    }

    public LocalVariableResolver(@NotNull ModifiersChecker modifiersChecker, @NotNull IdentifierChecker identifierChecker, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull AnnotationResolver annotationResolver, @NotNull VariableTypeAndInitializerResolver variableTypeAndInitializerResolver, @NotNull DelegatedPropertyResolver delegatedPropertyResolver, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)modifiersChecker, (String)"modifiersChecker");
        Intrinsics.checkParameterIsNotNull((Object)identifierChecker, (String)"identifierChecker");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowAnalyzer, (String)"dataFlowAnalyzer");
        Intrinsics.checkParameterIsNotNull((Object)annotationResolver, (String)"annotationResolver");
        Intrinsics.checkParameterIsNotNull((Object)variableTypeAndInitializerResolver, (String)"variableTypeAndInitializerResolver");
        Intrinsics.checkParameterIsNotNull((Object)delegatedPropertyResolver, (String)"delegatedPropertyResolver");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.modifiersChecker = modifiersChecker;
        this.identifierChecker = identifierChecker;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.annotationResolver = annotationResolver;
        this.variableTypeAndInitializerResolver = variableTypeAndInitializerResolver;
        this.delegatedPropertyResolver = delegatedPropertyResolver;
        this.languageVersionSettings = languageVersionSettings;
    }
}

