/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 82\u00020\u0001:\u00018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u000f\u001a\u00020\u00102\u001a\u0010\u0011\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0015J$\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001f2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0015J$\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J.\u0010%\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010'\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00122\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)H\u0002J,\u0010*\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020+2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020$H\u0002J1\u0010/\u001a\u0012\u0012\u0004\u0012\u00020\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f002\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b1J*\u00102\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u00132\u0006\u00103\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u00106\u001a\u0002072\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getBuiltIns$frontend", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "constantValueFactory", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "getConstantValueFactory$frontend", "()Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "getLanguageVersionSettings$frontend", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkArgumentsAreCompileTimeConstants", "", "argumentsWithComponentType", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/types/KotlinType;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkCompileTimeConstant", "argumentExpression", "expectedType", "evaluateExpression", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "expression", "evaluateToConstantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "getAnnotationArgumentValue", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "getArgumentExpressionsForArrayCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getArgumentExpressionsForArrayLikeCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getArgumentExpressionsForCollectionLiteralCall", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "hasSpread", "", "argument", "resolveAnnotationArguments", "", "resolveAnnotationArguments$frontend", "resolveAnnotationValueArguments", "resolvedValueArgument", "updateNumberType", "numberType", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "Companion", "frontend"})
public final class ConstantExpressionEvaluator {
    @NotNull
    private final ConstantValueFactory constantValueFactory;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ConstantValueFactory getConstantValueFactory$frontend() {
        return this.constantValueFactory;
    }

    public final void updateNumberType(@NotNull KotlinType numberType, @Nullable KtExpression expression2, @NotNull StatementFilter statementFilter, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)numberType, (String)"numberType");
        Intrinsics.checkParameterIsNotNull((Object)statementFilter, (String)"statementFilter");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        if (expression2 == null) {
            return;
        }
        BindingContextUtils.updateRecordedType(numberType, expression2, trace, false);
        if (!(expression2 instanceof KtConstantExpression)) {
            KtExpression deparenthesized = KtPsiUtil.getLastElementDeparenthesized(expression2, statementFilter);
            if (deparenthesized != expression2) {
                this.updateNumberType(numberType, deparenthesized, statementFilter, trace);
            }
            return;
        }
        this.evaluateExpression(expression2, trace, numberType);
    }

    @NotNull
    public final Map<ValueParameterDescriptor, ConstantValue<?>> resolveAnnotationArguments$frontend(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        HashMap arguments2 = new HashMap();
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = resolvedCall2.getValueArguments().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            ValueParameterDescriptor parameterDescriptor = entry2.getKey();
            entry2 = entry;
            ResolvedValueArgument resolvedArgument = entry2.getValue();
            ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameterDescriptor");
            ResolvedValueArgument resolvedValueArgument = resolvedArgument;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"resolvedArgument");
            ConstantValue<?> value2 = this.getAnnotationArgumentValue(trace, valueParameterDescriptor, resolvedValueArgument);
            if (value2 == null) continue;
            arguments2.put(parameterDescriptor, value2);
        }
        return arguments2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConstantValue<?> getAnnotationArgumentValue(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ResolvedValueArgument resolvedArgument) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        KotlinType constantType;
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)resolvedArgument, (String)"resolvedArgument");
        KotlinType varargElementType = parameterDescriptor.getVarargElementType();
        boolean argumentsAsVararg = varargElementType != null && !this.hasSpread(resolvedArgument);
        KotlinType kotlinType = constantType = argumentsAsVararg ? varargElementType : parameterDescriptor.getType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        List<CompileTimeConstant<?>> compileTimeConstants = this.resolveAnnotationValueArguments(resolvedArgument, kotlinType, trace);
        Iterable iterable = $receiver$iv = (Iterable)compileTimeConstants;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)item$iv$iv;
            Collection collection = destination$iv$iv;
            ConstantValue constantValue = it.toConstantValue(constantType);
            collection.add(constantValue);
        }
        List constants = (List)destination$iv$iv;
        if (argumentsAsVararg) {
            if (parameterDescriptor.declaresDefaultValue() && compileTimeConstants.isEmpty()) {
                return null;
            }
            KotlinType kotlinType2 = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"parameterDescriptor.type");
            return this.constantValueFactory.createArrayValue(constants, kotlinType2);
        }
        return (ConstantValue)CollectionsKt.lastOrNull((List)constants);
    }

    private final void checkCompileTimeConstant(KtExpression argumentExpression, KotlinType expectedType, BindingTrace trace) {
        Pair<List<KtExpression>, KotlinType> it;
        Pair<List<KtExpression>, KotlinType> pair2;
        KotlinType expressionType = trace.getType(argumentExpression);
        if (expressionType == null || !KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, expectedType)) {
            return;
        }
        if (argumentExpression instanceof KtCallExpression) {
            Pair<List<KtExpression>, KotlinType> pair3 = this.getArgumentExpressionsForArrayCall((KtCallExpression)argumentExpression, trace);
            if (pair3 != null) {
                it = pair2 = pair3;
                this.checkArgumentsAreCompileTimeConstants(it, trace);
            }
        }
        if (argumentExpression instanceof KtCollectionLiteralExpression) {
            Pair<List<KtExpression>, KotlinType> pair4 = this.getArgumentExpressionsForCollectionLiteralCall((KtCollectionLiteralExpression)argumentExpression, trace);
            if (pair4 != null) {
                it = pair2 = pair4;
                this.checkArgumentsAreCompileTimeConstants(it, trace);
            }
        }
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
        CompileTimeConstant<?> constant = Companion.getConstant(argumentExpression, bindingContext2);
        if (constant != null && constant.getCanBeUsedInAnnotations()) {
            DoubleColonLHS doubleColonLhs;
            KtExpression lhsExpression;
            if (constant.getUsesNonConstValAsConstant()) {
                trace.report(Errors.NON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION.on((KtExpression)((PsiElement)argumentExpression)));
            }
            if (argumentExpression instanceof KtClassLiteralExpression && (lhsExpression = ((KtClassLiteralExpression)argumentExpression).getReceiverExpression()) != null && (doubleColonLhs = (DoubleColonLHS)trace.getBindingContext().get(BindingContext.DOUBLE_COLON_LHS, lhsExpression)) instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)doubleColonLhs).isObjectQualifier()) {
                trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_KCLASS_LITERAL.on((KtExpression)((PsiElement)argumentExpression)));
            }
            return;
        }
        ClassifierDescriptor descriptor2 = expressionType.getConstructor().getDeclarationDescriptor();
        if (descriptor2 != null && DescriptorUtils.isEnumClass(descriptor2)) {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_ENUM_CONST.on((KtExpression)((PsiElement)argumentExpression)));
        } else if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_KCLASS_LITERAL.on((KtExpression)((PsiElement)argumentExpression)));
        } else {
            trace.report(Errors.ANNOTATION_PARAMETER_MUST_BE_CONST.on((KtExpression)((PsiElement)argumentExpression)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkArgumentsAreCompileTimeConstants(Pair<? extends List<? extends KtExpression>, ? extends KotlinType> argumentsWithComponentType, BindingTrace trace) {
        void arguments2;
        Pair<? extends List<? extends KtExpression>, ? extends KotlinType> pair2 = argumentsWithComponentType;
        List list2 = (List)pair2.component1();
        KotlinType kotlinType = (KotlinType)pair2.component2();
        pair2 = null;
        for (KtExpression expression2 : arguments2) {
            void componentType;
            void v0 = componentType;
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            this.checkCompileTimeConstant(expression2, (KotlinType)v0, trace);
        }
    }

    private final Pair<List<KtExpression>, KotlinType> getArgumentExpressionsForArrayCall(KtCallExpression expression2, BindingTrace trace) {
        KtElement ktElement = expression2;
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext2);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        return this.getArgumentExpressionsForArrayLikeCall(resolvedCall3);
    }

    @Nullable
    public final Pair<List<KtExpression>, KotlinType> getArgumentExpressionsForCollectionLiteralCall(@NotNull KtCollectionLiteralExpression expression2, @NotNull BindingTrace trace) {
        ResolvedCall resolvedCall2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        ResolvedCall resolvedCall3 = (ResolvedCall)trace.get(BindingContext.COLLECTION_LITERAL_CALL, expression2);
        if (resolvedCall3 == null) {
            return null;
        }
        ResolvedCall resolvedCall4 = resolvedCall2 = resolvedCall3;
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall4, (String)"resolvedCall");
        return this.getArgumentExpressionsForArrayLikeCall(resolvedCall4);
    }

    private final Pair<List<KtExpression>, KotlinType> getArgumentExpressionsForArrayLikeCall(ResolvedCall<?> resolvedCall2) {
        if (!CompileTimeConstantUtils.isArrayFunctionCall(resolvedCall2)) {
            return null;
        }
        KotlinType kotlinType = resolvedCall2.getResultingDescriptor().getReturnType();
        if (kotlinType == null) {
            return null;
        }
        KotlinType returnType2 = kotlinType;
        KotlinType componentType = this.builtIns.getArrayElementType(returnType2);
        ArrayList<KtExpression> result2 = new ArrayList<KtExpression>();
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall2.getValueArguments();
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            ResolvedValueArgument resolvedValueArgument = entry2.getValue();
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                KtExpression valueArgumentExpression = valueArgument.getArgumentExpression();
                if (valueArgumentExpression == null) continue;
                result2.add(valueArgumentExpression);
            }
        }
        KotlinType kotlinType2 = componentType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"componentType");
        return new Pair(result2, (Object)kotlinType2);
    }

    private final boolean hasSpread(ResolvedValueArgument argument2) {
        List<ValueArgument> arguments2 = argument2.getArguments();
        return arguments2.size() == 1 && arguments2.get(0).getSpreadElement() != null;
    }

    private final List<CompileTimeConstant<?>> resolveAnnotationValueArguments(ResolvedValueArgument resolvedValueArgument, KotlinType expectedType, BindingTrace trace) {
        ArrayList constants = new ArrayList();
        for (ValueArgument argument2 : resolvedValueArgument.getArguments()) {
            KtExpression argumentExpression;
            if (argument2.getArgumentExpression() == null) {
                continue;
            }
            CompileTimeConstant<?> constant = this.evaluateExpression(argumentExpression, trace, expectedType);
            if (constant instanceof IntegerValueTypeConstant) {
                KotlinType defaultType2 = ((IntegerValueTypeConstant)constant).getType(expectedType);
                this.updateNumberType(defaultType2, argumentExpression, StatementFilter.NONE, trace);
            }
            if (constant != null) {
                constants.add(constant);
            }
            this.checkCompileTimeConstant(argumentExpression, expectedType, trace);
        }
        return constants;
    }

    @Nullable
    public final CompileTimeConstant<?> evaluateExpression(@NotNull KtExpression expression2, @NotNull BindingTrace trace, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        ConstantExpressionEvaluatorVisitor visitor2 = new ConstantExpressionEvaluatorVisitor(this, trace);
        CompileTimeConstant<?> compileTimeConstant = visitor2.evaluate(expression2, expectedType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> constant = compileTimeConstant;
        return !constant.isError() ? constant : null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CompileTimeConstant evaluateExpression$default(ConstantExpressionEvaluator constantExpressionEvaluator, KtExpression ktExpression, BindingTrace bindingTrace, KotlinType kotlinType, int n, Object object) {
        if ((n & 4) != 0) {
            kotlinType = TypeUtils.NO_EXPECTED_TYPE;
        }
        return constantExpressionEvaluator.evaluateExpression(ktExpression, bindingTrace, kotlinType);
    }

    @Nullable
    public final ConstantValue<?> evaluateToConstantValue(@NotNull KtExpression expression2, @NotNull BindingTrace trace, @NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        CompileTimeConstant<?> compileTimeConstant = this.evaluateExpression(expression2, trace, expectedType);
        return compileTimeConstant != null ? compileTimeConstant.toConstantValue(expectedType) : null;
    }

    @NotNull
    public final KotlinBuiltIns getBuiltIns$frontend() {
        return this.builtIns;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings$frontend() {
        return this.languageVersionSettings;
    }

    public ConstantExpressionEvaluator(@NotNull KotlinBuiltIns builtIns, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.builtIns = builtIns;
        this.languageVersionSettings = languageVersionSettings;
        this.constantValueFactory = new ConstantValueFactory(this.builtIns);
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        return Companion.getConstant(expression2, bindingContext2);
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        return Companion.getPossiblyErrorConstant(expression2, bindingContext2);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001e\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator$Companion;", "", "()V", "getConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getPossiblyErrorConstant", "frontend"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            CompileTimeConstant<?> compileTimeConstant = this.getPossiblyErrorConstant(expression2, bindingContext2);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> constant = compileTimeConstant;
            return !constant.isError() ? constant : null;
        }

        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            return (CompileTimeConstant)bindingContext2.get(BindingContext.COMPILE_TIME_VALUE, expression2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

