/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.reference;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.struts2.reference.TaglibUtil;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class StaticStringValuesReferenceProvider
extends PsiReferenceProvider {
    private final boolean allowOtherValues;
    private final String[] values;

    public StaticStringValuesReferenceProvider(String ... values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/struts2/reference/StaticStringValuesReferenceProvider", "<init>"));
        }
        this(true, values);
    }

    public StaticStringValuesReferenceProvider(boolean allowOtherValues, String ... values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/struts2/reference/StaticStringValuesReferenceProvider", "<init>"));
        }
        this.allowOtherValues = allowOtherValues;
        Arrays.sort(values);
        this.values = values;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts2/reference/StaticStringValuesReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts2/reference/StaticStringValuesReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<XmlAttributeValue>((XmlAttributeValue)element){

            public PsiElement resolve() {
                String myValue = ((XmlAttributeValue)this.myElement).getValue();
                if (StaticStringValuesReferenceProvider.this.allowOtherValues || TaglibUtil.isDynamicExpression(myValue)) {
                    return this.myElement;
                }
                return Arrays.binarySearch(StaticStringValuesReferenceProvider.this.values, myValue) > -1 ? this.myElement : null;
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = StaticStringValuesReferenceProvider.this.values;
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/StaticStringValuesReferenceProvider$1", "getVariants"));
                }
                return objectArray;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/StaticStringValuesReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

